/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.bflog;

import de.binfalse.bflog.LogCallback;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class LOGGER {
    public static final int ERROR = 8;
    public static final int WARN = 4;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    public static final SimpleDateFormat dateformat = new SimpleDateFormat("dd.MM HH:mm:ss");
    public static final String NEWLINE = System.getProperty("line.separator");
    protected static int logLevel = 12;
    private static File logFileFile;
    private static BufferedWriter logFile;
    private static boolean logToFile;
    private static boolean logToStdOut;
    private static boolean logToStdErr;
    private static boolean logStackTrace;
    private static Vector<LogCallback> callBacks;

    public static boolean setLogFile(String fileName) {
        return LOGGER.setLogFile(new File(fileName));
    }

    public static boolean setLogFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!(file.isFile() && file.canRead() && file.canWrite())) {
                return false;
            }
            logFileFile = file;
        }
        catch (IOException e) {
            LOGGER.error("cannot set logfile", e);
            return false;
        }
        return true;
    }

    private static boolean openLogFile() {
        try {
            logFile = new BufferedWriter(new FileWriter(logFileFile, true));
        }
        catch (IOException e) {
            LOGGER.error("error opening log file: " + logFileFile.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    private static boolean closeLogFile() {
        if (logFile == null) {
            return true;
        }
        try {
            logFile.flush();
            logFile.close();
        }
        catch (IOException e) {
            LOGGER.error("error closing logfile", e);
            return false;
        }
        logFile = null;
        return true;
    }

    public static void closeLogger() {
        LOGGER.closeLogFile();
        logToStdErr = false;
        logToStdOut = false;
        logLevel = 0;
    }

    public static boolean setLogToFile(boolean log) {
        if (logFileFile == null) {
            return false;
        }
        logToFile = log;
        if (logToFile) {
            return LOGGER.openLogFile();
        }
        return LOGGER.closeLogFile();
    }

    public static void setLogStackTrace(boolean log) {
        logStackTrace = log;
    }

    public static void setLogToStdErr(boolean log) {
        logToStdErr = log;
    }

    public static void setLogToStdOut(boolean log) {
        logToStdOut = log;
    }

    public static void setMinLevel(int level) {
        logLevel = 0;
        int lvl = 1;
        for (int i = 0; i < 4; ++i) {
            if (lvl >= level) {
                logLevel |= lvl;
            }
            lvl *= 2;
        }
    }

    public static void setLevel(int level) {
        logLevel = level;
    }

    public static void addLevel(int level) {
        logLevel |= level;
    }

    public static void rmLevel(int level) {
        logLevel &= ~level;
    }

    public static boolean hasLevel(int level) {
        return (logLevel & level) == level;
    }

    public static boolean isInfoEnabled() {
        return LOGGER.hasLevel(2);
    }

    public static boolean isDebugEnabled() {
        return LOGGER.hasLevel(1);
    }

    public static boolean isErrorEnabled() {
        return LOGGER.hasLevel(8);
    }

    public static boolean isWarnEnabled() {
        return LOGGER.hasLevel(4);
    }

    private static void publish(int level, String line) {
        if (logToStdOut) {
            System.out.println(line);
        }
        if (logToStdErr) {
            System.err.println(line);
        }
        if (logToFile && logFile != null) {
            try {
                logFile.write(line);
                logFile.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (LogCallback lcb : callBacks) {
            lcb.logged(level, line);
        }
    }

    private static void log(int level, Object ... msg) {
        StringBuilder sb = LOGGER.preMsg(level, Thread.currentThread().getStackTrace()[3]);
        for (Object m : msg) {
            sb.append(m);
        }
        LOGGER.publish(level, sb.toString());
    }

    private static void log(int level, Exception e, Object ... msg) {
        StringBuilder sb = LOGGER.preMsg(level, Thread.currentThread().getStackTrace()[3]);
        for (Object m : msg) {
            sb.append(m);
        }
        sb.append(" (throwing ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append(")");
        if (logStackTrace) {
            StackTraceElement[] ste;
            sb.append(NEWLINE).append("\t").append(e.getClass().getName()).append(": ").append(e.getMessage());
            for (StackTraceElement el : ste = e.getStackTrace()) {
                sb.append(NEWLINE).append("\t\tat ").append(el.getClassName()).append(".").append(el.getMethodName()).append("(").append(el.getFileName()).append(":").append(el.getLineNumber()).append(")");
            }
        }
        LOGGER.publish(level, sb.toString());
    }

    @Deprecated
    public static void error(String msg, Exception e) {
        if ((logLevel & 8) > 0) {
            LOGGER.log(8, e, msg);
        }
    }

    @Deprecated
    public static void info(String msg, Exception e) {
        if ((logLevel & 2) > 0) {
            LOGGER.log(2, e, msg);
        }
    }

    @Deprecated
    public static void debug(String msg, Exception e) {
        if ((logLevel & 1) > 0) {
            LOGGER.log(1, e, msg);
        }
    }

    @Deprecated
    public static void warn(String msg, Exception e) {
        if ((logLevel & 4) > 0) {
            LOGGER.log(4, e, msg);
        }
    }

    public static void error(Exception e, Object ... msg) {
        if ((logLevel & 8) > 0) {
            LOGGER.log(8, e, msg);
        }
    }

    public static void info(Exception e, Object ... msg) {
        if ((logLevel & 2) > 0) {
            LOGGER.log(2, e, msg);
        }
    }

    public static void debug(Exception e, Object ... msg) {
        if ((logLevel & 1) > 0) {
            LOGGER.log(1, e, msg);
        }
    }

    public static void warn(Exception e, Object ... msg) {
        if ((logLevel & 4) > 0) {
            LOGGER.log(4, e, msg);
        }
    }

    public static void error(Object ... msg) {
        if ((logLevel & 8) > 0) {
            LOGGER.log(8, msg);
        }
    }

    public static void info(Object ... msg) {
        if ((logLevel & 2) > 0) {
            LOGGER.log(2, msg);
        }
    }

    public static void debug(Object ... msg) {
        if ((logLevel & 1) > 0) {
            LOGGER.log(1, msg);
        }
    }

    public static void warn(Object ... msg) {
        if ((logLevel & 4) > 0) {
            LOGGER.log(4, msg);
        }
    }

    public static void addCallback(LogCallback callBack) {
        callBacks.add(callBack);
    }

    public static void rmCallBack(LogCallback callBack) {
        callBacks.remove(callBack);
    }

    private static StringBuilder preMsg(int level, StackTraceElement ste) {
        return new StringBuilder(dateformat.format(new Date())).append(" ").append(LOGGER.levelString(level)).append(" ").append(ste.getClassName()).append("@").append(ste.getLineNumber()).append(": ");
    }

    private static final String levelString(int level) {
        switch (level) {
            case 8: {
                return "ERROR";
            }
            case 4: {
                return "WARNS";
            }
            case 1: {
                return "DEBUG";
            }
            case 2: {
                return "INFOS";
            }
        }
        return "UNKWN";
    }

    static {
        logToFile = false;
        logToStdOut = false;
        logToStdErr = true;
        logStackTrace = false;
        callBacks = new Vector();
    }
}

