/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.bfutils;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class FileRetriever {
    public static File CACHE_DIR;
    private static boolean keepCache;
    public static boolean FIND_LOCAL;
    public static boolean FIND_REMOTE;
    private static Properties cacheProps;
    private static File cacheFile;

    private static void setUpCache() {
        cacheProps = new Properties();
        try {
            CACHE_DIR = Files.createTempDirectory("BFToolsFileRetrieverCache", new FileAttribute[0]).toFile();
            CACHE_DIR.deleteOnExit();
        }
        catch (IOException e) {
            LOGGER.error(e, "error creating temporary directory for caching");
        }
    }

    public static boolean setUpCache(File directory) throws IOException {
        keepCache = false;
        CACHE_DIR = directory;
        if (CACHE_DIR == null) {
            return false;
        }
        if (!CACHE_DIR.exists()) {
            CACHE_DIR.mkdirs();
        }
        if (CACHE_DIR.exists() && CACHE_DIR.isDirectory() && CACHE_DIR.canWrite() && CACHE_DIR.canRead()) {
            keepCache = true;
            cacheFile = new File(CACHE_DIR + File.separator + "cache.props");
            if (cacheFile.exists()) {
                FileInputStream in = new FileInputStream(cacheFile);
                cacheProps.load(in);
                in.close();
            } else {
                cacheFile.createNewFile();
            }
            return true;
        }
        LOGGER.warn("cache directory isn't appropriate");
        CACHE_DIR = null;
        return false;
    }

    private static void storeCacheProps() throws IOException {
        if (cacheFile != null) {
            FileOutputStream out = new FileOutputStream(cacheFile);
            cacheProps.store(out, "---No Comment---");
            out.close();
        }
    }

    public static URI getUri(String href, URI base) throws URISyntaxException, IOException {
        URI theUri = new URI(href);
        if (theUri.isAbsolute()) {
            return theUri;
        }
        if (href.startsWith("/")) {
            return new URI("file://" + href);
        }
        if (base == null || !base.isAbsolute()) {
            throw new IOException("don't know where this relative path points to: " + href + " (no base provided, or base also relative).");
        }
        return base.resolve(theUri);
    }

    protected static String copy(URI from, File to, boolean local) throws IOException {
        if (local && !FIND_LOCAL) {
            throw new IOException("local resolving disabled");
        }
        LOGGER.debug("copying " + from + " to " + to);
        Files.copy(Paths.get(from), Paths.get(to.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        return null;
    }

    protected static String download(URI from, File to, boolean downloadAnyway, Map<String, String> addidionalHeaders) throws IOException {
        Matcher matcher;
        if (!FIND_REMOTE) {
            throw new IOException("remote resolving disabled");
        }
        LOGGER.debug("downloading ", from, " to ", to);
        String chacheAdd = "";
        HttpGet httpGet = new HttpGet(from);
        httpGet.addHeader("User-Agent", "Java FileRetriever of the BFUtils package (http://binfalse.de)");
        if (addidionalHeaders != null) {
            for (String addHead : addidionalHeaders.keySet()) {
                String value = addidionalHeaders.get(addHead);
                LOGGER.debug("user supplied additional header: ", addHead, value);
                httpGet.addHeader(addHead, value);
                chacheAdd = chacheAdd + "?" + addHead + "!" + value;
            }
        }
        File cached = null;
        String cachedName = GeneralTools.encodeBase64((from.toString() + chacheAdd).getBytes());
        if (CACHE_DIR != null) {
            String cachedDir = CACHE_DIR.getAbsolutePath() + File.separatorChar;
            while (cachedName.length() > 51) {
                cachedDir = cachedDir + cachedName.substring(0, 50) + File.separatorChar;
                cachedName = cachedName.substring(50);
            }
            cached = new File(cachedDir + cachedName);
            if (cached.exists()) {
                FileRetriever.copy(cached.toURI(), to, false);
                return cacheProps.getProperty(cachedName, null);
            }
        }
        String suggestedName = null;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpResponse getResponse = client.execute(httpGet);
        if (!downloadAnyway && getResponse.getStatusLine().getStatusCode() != 200) {
            throw new IOException(getResponse.getStatusLine().getStatusCode() + " " + getResponse.getStatusLine().getReasonPhrase() + " while download " + from);
        }
        HttpEntity entity = getResponse.getEntity();
        if (entity == null) {
            throw new IOException("No content returned while donwloading remote file " + from);
        }
        Header dispositionHeader = getResponse.getFirstHeader("Content-Disposition");
        if (dispositionHeader != null && dispositionHeader.getValue() != null && !dispositionHeader.getValue().isEmpty() && (matcher = Pattern.compile("filename=\\\"?(([a-zA-Z0-9-_\\+]+).(\\w+))\\\"?", 2).matcher(dispositionHeader.getValue())).find()) {
            suggestedName = matcher.group(1);
        }
        FileOutputStream output = new FileOutputStream(to);
        IOUtils.copy(entity.getContent(), (OutputStream)output);
        if (CACHE_DIR != null) {
            cached.getParentFile().mkdirs();
            FileRetriever.copy(to.toURI(), cached, false);
            if (suggestedName != null) {
                cacheProps.put(cachedName, suggestedName);
            }
            if (!keepCache) {
                cached.deleteOnExit();
            }
        }
        return suggestedName;
    }

    public static String getFile(URI file, File dest) throws IOException, URISyntaxException {
        if (!dest.canWrite()) {
            throw new IOException("cannot write to file: " + dest.getAbsolutePath());
        }
        LOGGER.info("trying to retrieve file from ", file, " to ", dest);
        if (file.getScheme() == null || file.getScheme().toLowerCase().startsWith("file")) {
            return FileRetriever.copy(file, dest, true);
        }
        return FileRetriever.download(file, dest, false, null);
    }

    public static String getFile(URI file, File dest, Map<String, String> additionalDownloadHeaders) throws IOException, URISyntaxException {
        if (!dest.canWrite()) {
            throw new IOException("cannot write to file: " + dest.getAbsolutePath());
        }
        LOGGER.info("trying to retrieve file from ", file, " to ", dest);
        if (file.getScheme() == null || file.getScheme().toLowerCase().startsWith("file")) {
            return FileRetriever.copy(file, dest, true);
        }
        return FileRetriever.download(file, dest, false, additionalDownloadHeaders);
    }

    static {
        keepCache = false;
        FIND_LOCAL = true;
        FIND_REMOTE = true;
        FileRetriever.setUpCache();
    }
}

