/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.bfutils;

import de.binfalse.bflog.LOGGER;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import javax.xml.bind.DatatypeConverter;

public class GeneralTools {
    public static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int computeLevenshteinDistance(String str1, String str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 1; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = GeneralTools.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    public static String repeat(String s, int times) {
        if (times <= 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            str.append(s);
        }
        return str.toString();
    }

    public static String prettyDouble(Double d, Integer neglect) {
        if (d == null) {
            return "";
        }
        if (d == Math.rint(d) && !Double.isInfinite(d) && !Double.isNaN(d)) {
            int s = d.intValue();
            if (neglect != null && s == neglect) {
                return "";
            }
            return s + "";
        }
        return d.toString();
    }

    public static String prettyDouble(Double d, Integer neglect, String pre, String post) {
        if (d == null) {
            return "";
        }
        if (d == Math.rint(d) && !Double.isInfinite(d) && !Double.isNaN(d)) {
            int s = d.intValue();
            if (neglect != null && s == neglect) {
                return "";
            }
            return pre + s + "" + post;
        }
        return pre + d.toString() + post;
    }

    public static String byteToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String hash(String msg) {
        String hash = GeneralTools.hashSha256(msg);
        if (hash == null) {
            hash = GeneralTools.hashSha1(msg);
        }
        if (hash == null) {
            hash = GeneralTools.hashSha512(msg);
        }
        if (hash == null) {
            hash = GeneralTools.hashMd5(msg);
        }
        return hash;
    }

    private static String hash(String msg, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(msg.getBytes());
            return DatatypeConverter.printHexBinary((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e, "cannot hash message because algorithm unknown");
            return null;
        }
    }

    public static String hashMd5(String msg) {
        return GeneralTools.hash(msg, "MD5");
    }

    public static String hashSha1(String msg) {
        return GeneralTools.hash(msg, "SHA-1");
    }

    public static String hashSha256(String msg) {
        return GeneralTools.hash(msg, "SHA-256");
    }

    public static String hashSha512(String msg) {
        return GeneralTools.hash(msg, "SHA-512");
    }

    public static String encodeBase64(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public static byte[] decodeBase64(String str) {
        return DatatypeConverter.parseBase64Binary((String)str);
    }

    public static String fileToString(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuilder sb = new StringBuilder();
        while (br.ready()) {
            sb.append(br.readLine()).append(LOGGER.NEWLINE);
        }
        br.close();
        return sb.toString();
    }

    public static void stringToFile(String s, File f) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        bw.write(s);
        bw.close();
    }

    public static int sizeOfIterable(Iterable<?> iterable) {
        int size = 0;
        if (iterable instanceof Collection) {
            size = ((Collection)iterable).size();
        } else {
            for (Object i : iterable) {
                ++size;
            }
        }
        return size;
    }

    public static boolean delete(File f) throws IOException {
        boolean succ = true;
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                succ = succ && GeneralTools.delete(c);
            }
        }
        if (!f.delete()) {
            succ = false;
        }
        return succ;
    }
}

