/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.bfutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class Downloader {
    public static final String download(String remoteUrl, File target, boolean downloadAnyway) throws IOException {
        Matcher matcher;
        String name = null;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpResponse getResponse = client.execute(new HttpGet(remoteUrl));
        if (!downloadAnyway && getResponse.getStatusLine().getStatusCode() != 200) {
            throw new IOException(getResponse.getStatusLine().getStatusCode() + " " + getResponse.getStatusLine().getReasonPhrase() + " while download " + remoteUrl);
        }
        HttpEntity entity = getResponse.getEntity();
        if (entity == null) {
            throw new IOException("No content returned while donwloading remote file " + remoteUrl);
        }
        Header dispositionHeader = getResponse.getFirstHeader("Content-Disposition");
        if (dispositionHeader != null && dispositionHeader.getValue() != null && !dispositionHeader.getValue().isEmpty() && (matcher = Pattern.compile("filename=\\\"?(([a-zA-Z0-9-_\\+]+).(\\w+))\\\"?", 2).matcher(dispositionHeader.getValue())).find()) {
            name = matcher.group(1);
        }
        FileOutputStream output = new FileOutputStream(target);
        IOUtils.copy(entity.getContent(), (OutputStream)output);
        return name;
    }
}

