/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNode;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import java.util.Collection;
import java.util.HashMap;

public class CellMLHierarchyNetwork {
    private String relationship;
    private String name;
    private HashMap<CellMLComponent, CellMLHierarchyNode> componentMapper;

    public CellMLHierarchyNetwork(String relationship, String name) {
        this.relationship = relationship;
        this.name = name;
        this.componentMapper = new HashMap();
    }

    public CellMLHierarchyNode getNode(CellMLComponent component) {
        return this.componentMapper.get(component);
    }

    public Collection<CellMLHierarchyNode> getNodes() {
        return this.componentMapper.values();
    }

    public CellMLHierarchyNode putNode(CellMLComponent component) {
        CellMLHierarchyNode node = this.componentMapper.get(component);
        if (node == null) {
            node = new CellMLHierarchyNode(component);
            this.componentMapper.put(component, node);
        }
        return node;
    }

    public void connectHierarchically(CellMLComponent parent, CellMLComponent kid) throws BivesLogicalException {
        CellMLHierarchyNode pNode = this.componentMapper.get(parent);
        CellMLHierarchyNode kNode = this.componentMapper.get(kid);
        if (pNode == null) {
            pNode = new CellMLHierarchyNode(parent);
            this.componentMapper.put(parent, pNode);
        }
        if (kNode == null) {
            kNode = new CellMLHierarchyNode(kid);
            this.componentMapper.put(kid, kNode);
        }
        if (kNode.getParent() != null) {
            throw new BivesLogicalException("encapsulation failed: child wants to have two parents? (component: " + kid.getName() + ", parents: " + parent.getName() + "," + kNode.getParent().getComponent().getName() + ")");
        }
        pNode.addChild(kNode);
        kNode.setParent(pNode);
    }

    public String getRelationship() {
        return this.relationship;
    }

    public String getName() {
        return this.name;
    }
}

