/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.AlphabetIterator;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLConnection;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchy;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNetwork;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNode;
import de.unirostock.sems.bives.cellml.parser.CellMLImporter;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.ds.rdf.RDF;
import de.unirostock.sems.bives.ds.rdf.RDFDescription;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesFlattenException;
import de.unirostock.sems.bives.exception.BivesImportException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.exception.XmlDocumentConsistencyException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class CellMLModel
extends CellMLEntity {
    private String name;
    private CellMLDocument doc;
    private CellMLUnitDictionary unitDict;
    private HashMap<String, CellMLComponent> components;
    private List<CellMLComponent> importedComponents;
    private List<CellMLUserUnit> importedUnits;
    private HashMap<TreeNode, CellMLEntity> nodeMapper;
    private HashMap<String, CellMLEntity> metaIdMapper;
    private CellMLHierarchy hierarchy;
    private boolean containsImports;
    private List<CellMLConnection.ConnectedComponents> connectedComponents;
    private List<RDF> rdfBlocks;
    private Map<String, List<RDFDescription>> rdfMapper;

    public CellMLModel(CellMLDocument doc, DocumentNode rootNode) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, IOException, URISyntaxException, BivesImportException {
        super(rootNode, null);
        this.model = this;
        this.doc = doc;
        this.containsImports = false;
        this.name = rootNode.getAttributeValue("name");
        this.unitDict = new CellMLUnitDictionary(this);
        this.components = new HashMap();
        this.hierarchy = new CellMLHierarchy(this);
        this.importedUnits = new ArrayList<CellMLUserUnit>();
        this.importedComponents = new ArrayList<CellMLComponent>();
        this.connectedComponents = new ArrayList<CellMLConnection.ConnectedComponents>();
        this.nodeMapper = new HashMap();
        this.metaIdMapper = new HashMap();
        this.rdfBlocks = new ArrayList<RDF>();
        this.rdfMapper = new HashMap<String, List<RDFDescription>>();
        this.registerMetaId(this.getMetaId(), this);
        for (RDF block : this.getRdfBlocks()) {
            this.registerRdfBlock(block);
        }
        this.readDocument(rootNode);
    }

    public String getName() {
        return this.name;
    }

    public boolean containsImports() {
        return this.containsImports;
    }

    private void readDocument(DocumentNode root) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, IOException, URISyntaxException, BivesImportException {
        LOGGER.info((Object[])new Object[]{"reading imports in ", this.doc.getBaseUri()});
        this.readImports(root);
        LOGGER.info((Object[])new Object[]{"after import:"});
        for (String c : this.components.keySet()) {
            LOGGER.info((Object[])new Object[]{"comp: ", c, " -> ", this.components.get(c).getName()});
        }
        LOGGER.info((Object[])new Object[]{"reading units in ", this.doc.getBaseUri()});
        this.readUnits(root);
        LOGGER.info((Object[])new Object[]{"reading components in ", this.doc.getBaseUri()});
        this.readComponents(root);
        LOGGER.info((Object[])new Object[]{"reading groups in ", this.doc.getBaseUri()});
        this.readGroups(root);
        LOGGER.info((Object[])new Object[]{"reading connections in ", this.doc.getBaseUri()});
        this.readConnections(root);
        LOGGER.info((Object[])new Object[]{"evaluating rdf in ", this.doc.getBaseUri()});
        this.evaluateRdf();
    }

    private void readUnits(DocumentNode root) throws BivesDocumentConsistencyException, BivesCellMLParseException, BivesLogicalException {
        List kids = root.getChildrenWithTag("units");
        boolean nextRound = true;
        ArrayList<String> problems = new ArrayList<String>();
        while (nextRound && kids.size() > 0) {
            nextRound = false;
            problems.clear();
            for (int i = kids.size() - 1; i >= 0; --i) {
                TreeNode kid = (TreeNode)kids.get(i);
                if (kid.getType() != 1) continue;
                try {
                    this.unitDict.addUnit(null, new CellMLUserUnit(this.model, this.unitDict, null, (DocumentNode)kid), false);
                }
                catch (BivesDocumentConsistencyException ex) {
                    problems.add(ex.getMessage());
                    continue;
                }
                kids.remove(i);
                nextRound = true;
            }
        }
        if (kids.size() != 0) {
            throw new BivesDocumentConsistencyException("inconsistencies for " + kids.size() + " units, problems: " + problems);
        }
    }

    private void readImports(DocumentNode root) throws BivesCellMLParseException, IOException, URISyntaxException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException {
        List kids = root.getChildrenWithTag("import");
        for (TreeNode kid : kids) {
            if (kid.getType() != 1) continue;
            CellMLImporter importer = new CellMLImporter((DocumentNode)kid, this);
            importer.parse();
            this.containsImports = true;
        }
    }

    private void readConnections(DocumentNode root) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException {
        List kids = root.getChildrenWithTag("connection");
        for (TreeNode kid : kids) {
            CellMLConnection.ConnectedComponents c;
            if (kid.getType() != 1 || (c = CellMLConnection.parseConnection(this, this.hierarchy, (DocumentNode)kid, null)) == null) continue;
            this.connectedComponents.add(c);
        }
    }

    private void readGroups(DocumentNode root) throws BivesCellMLParseException, BivesLogicalException {
        List kids = root.getChildrenWithTag("group");
        for (TreeNode kid : kids) {
            if (kid.getType() != 1) continue;
            this.hierarchy.parseGroup((DocumentNode)kid);
        }
    }

    private void readComponents(DocumentNode root) throws BivesDocumentConsistencyException, BivesCellMLParseException, BivesLogicalException {
        List kids = root.getChildrenWithTag("component");
        for (TreeNode kid : kids) {
            if (kid.getType() != 1) continue;
            this.addComponent(new CellMLComponent(this, (DocumentNode)kid));
        }
    }

    private void evaluateRdf() {
        for (RDF rdf : this.rdfBlocks) {
            for (RDFDescription descr : rdf.getDescriptions()) {
                String about = descr.getAbout();
                if (about == null) continue;
                if (about.length() == 0) {
                    this.getDocument().associateRdfDescription(descr);
                    continue;
                }
                CellMLEntity entity = this.getEntityByMetaId(about);
                if (entity == null) continue;
                entity.associateRdfDescription(descr);
            }
        }
    }

    public void importUnit(CellMLUserUnit unit) throws BivesDocumentConsistencyException {
        this.addUnit(unit, true);
        this.importedUnits.add(unit);
    }

    public void addUnit(CellMLUserUnit unit, boolean imported) throws BivesDocumentConsistencyException {
        this.unitDict.addUnit(null, unit, imported);
    }

    public CellMLUnitDictionary getUnits() {
        return this.unitDict;
    }

    public CellMLDocument getDocument() {
        return this.doc;
    }

    public HashMap<String, CellMLComponent> getComponents() {
        return this.components;
    }

    public CellMLComponent getComponent(String name) {
        return this.components.get(name);
    }

    public void addComponent(CellMLComponent component) throws BivesDocumentConsistencyException, BivesLogicalException {
        if (this.components.get(component.getName()) != null) {
            throw new BivesDocumentConsistencyException("two components using the same name! (" + component.getName() + ")");
        }
        this.components.put(component.getName(), component);
    }

    public void importComponent(CellMLComponent component) throws BivesDocumentConsistencyException, BivesLogicalException {
        this.addComponent(component);
        this.importedComponents.add(component);
    }

    public void flatten() throws BivesFlattenException, BivesDocumentConsistencyException, XmlDocumentConsistencyException, BivesLogicalException {
        final DocumentNode thisNode = this.getDocumentNode();
        HashMap unitsToImport = new HashMap();
        HashMap<CellMLUserUnit, List<CellMLEntity>> unitsToImportDependeny = new HashMap<CellMLUserUnit, List<CellMLEntity>>();
        for (CellMLUserUnit unit : this.importedUnits) {
            if (unitsToImport.get(unit) == null) {
                unitsToImport.put(unit, new ArrayList());
            }
            ((List)unitsToImport.get(unit)).add(this);
            unit.getDependencies(unitsToImportDependeny);
        }
        CellMLHierarchyNetwork hierarchyToAdd = new CellMLHierarchyNetwork("bull", "shit");
        ArrayList<CellMLComponent> componentsToImport = new ArrayList<CellMLComponent>();
        ArrayList<CellMLComponent> componentsToImportDependency = new ArrayList<CellMLComponent>();
        for (CellMLComponent component : this.importedComponents) {
            componentsToImport.add(component);
            component.getDependencies(unitsToImportDependeny);
            CellMLHierarchyNetwork otherNetwork = component.getModel().getHierarchy().getEncapsulationHierarchyNetwork();
            Iterator<Object> componentNode = otherNetwork.getNode(component);
            ArrayList<Object> todo = new ArrayList<Object>();
            todo.add(componentNode);
            while (!todo.isEmpty()) {
                CellMLHierarchyNode current = (CellMLHierarchyNode)todo.remove(0);
                if (current == null) continue;
                for (CellMLHierarchyNode child : current.getChildren()) {
                    CellMLComponent kid = child.getComponent();
                    hierarchyToAdd.connectHierarchically(current.getComponent(), kid);
                    componentsToImportDependency.add(kid);
                    kid.getDependencies(unitsToImportDependeny);
                    todo.add(child);
                }
            }
        }
        final class RewriteMetaId {
            RewriteMetaId() {
            }

            public void rewrite(CellMLEntity u) throws BivesLogicalException {
                String thisMetaId = u.getMetaId();
                if (thisMetaId != null) {
                    if (CellMLModel.this.metaIdMapper.get(thisMetaId) != null) {
                        String name = thisMetaId + "_imported";
                        String tmpStr = "";
                        AlphabetIterator ai = AlphabetIterator.getUpperCaseIterator();
                        while (CellMLModel.this.metaIdMapper.get(name + tmpStr) != null) {
                            tmpStr = "_" + ai.next();
                        }
                        String newId = name + tmpStr;
                        u.setMetaId(newId);
                        for (RDFDescription descr : u.getRdfDescriptions()) {
                            descr.setAbout(newId);
                        }
                    }
                    List<RDF> modelRdf = CellMLModel.this.getRdfBlocks();
                    DocumentNode rdfNode = null;
                    if (modelRdf.size() > 0) {
                        rdfNode = modelRdf.get(0).getNode();
                    } else {
                        Element rdf = new Element("RDF", "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                        rdfNode = new DocumentNode(rdf, thisNode, thisNode.getDocument(), thisNode.getWeighter(), thisNode.getChildrenWithTag(rdf.getName()).size() + 1, thisNode.getLevel() + 1);
                        thisNode.addChild(rdfNode);
                    }
                    for (RDFDescription descr : u.getRdfDescriptions()) {
                        rdfNode.addChild(descr.getNode().extract());
                    }
                }
            }
        }
        RewriteMetaId metaRw = new RewriteMetaId();
        ArrayList<CellMLUserUnit> unitToWrite = new ArrayList<CellMLUserUnit>();
        HashMap<String, CellMLUserUnit> importedUnit = new HashMap<String, CellMLUserUnit>();
        for (CellMLUserUnit unit : unitsToImport.keySet()) {
            LOGGER.info((Object[])new Object[]{"directly importing unit: ", unit.getName(), " => ", unit.markup(), " => ", unit.getMetaId(), " => ", unit});
            importedUnit.put(unit.getName(), unit);
            unitToWrite.add(unit);
        }
        for (CellMLUserUnit unit : unitsToImportDependeny.keySet()) {
            Iterator<Object> done = (CellMLUserUnit)importedUnit.get(unit.getName());
            CellMLUserUnit org = (CellMLUserUnit)this.unitDict.getUnit(unit.getName(), null);
            if (done != null || org != null) {
                if ((org == null || unit.getModel().getDocument().getBaseUri().equals(org.getModel().getDocument().getBaseUri())) && (done == null || unit.getModel().getDocument().getBaseUri().equals(((CellMLEntity)((Object)done)).getModel().getDocument().getBaseUri()))) continue;
                LOGGER.info((Object[])new Object[]{"maybe renaming unit: ", unit.getName(), " => ", unit.markup()});
                String name = unit.getName() + "_imported";
                String tmpStr = "";
                AlphabetIterator alphabetIterator = AlphabetIterator.getUpperCaseIterator();
                boolean renameOnly = false;
                while (true) {
                    if (this.unitDict.getUnit(name + tmpStr, null) == null) {
                        if (importedUnit.get(name + tmpStr) == null) break;
                        CellMLUserUnit u = (CellMLUserUnit)importedUnit.get(name + tmpStr);
                        if (u.getModel().getDocument().getBaseUri().equals(unit.getModel().getDocument().getBaseUri())) {
                            renameOnly = true;
                            break;
                        }
                    } else if (this.unitDict.getUnit(name + tmpStr, null).getModel().getDocument().getBaseUri().equals(unit.getModel().getDocument().getBaseUri())) {
                        renameOnly = true;
                        break;
                    }
                    tmpStr = "_" + alphabetIterator.next();
                }
                LOGGER.info((Object[])new Object[]{"renaming unit to: ", name, tmpStr});
                List depending = (List)unitsToImportDependeny.get(unit);
                for (CellMLEntity entity : depending) {
                    if (entity instanceof CellMLVariable) {
                        CellMLVariable var = (CellMLVariable)entity;
                        var.renameUnit(unit.getName(), name + tmpStr);
                        continue;
                    }
                    if (entity instanceof CellMLUserUnit) {
                        CellMLUserUnit u = (CellMLUserUnit)entity;
                        u.renameUnit(unit.getName(), name + tmpStr);
                        continue;
                    }
                    throw new BivesFlattenException("renaming of unit in depending entities failed");
                }
                unit.setName(name + tmpStr);
                LOGGER.info((Object[])new Object[]{"renaming unit only: ", renameOnly});
                if (!renameOnly) {
                    unitToWrite.add(unit);
                }
                importedUnit.put(unit.getName(), unit);
                continue;
            }
            LOGGER.info((Object[])new Object[]{"importing unit: ", unit.getName(), " => ", unit.markup(), " => ", unit.getMetaId(), " => ", unit});
            unitToWrite.add(unit);
            importedUnit.put(unit.getName(), unit);
        }
        for (CellMLUserUnit u : unitToWrite) {
            metaRw.rewrite(u);
            u.setModel(this);
            thisNode.addChild(u.getDocumentNode().extract());
        }
        ArrayList<CellMLComponent> componentToWrite = new ArrayList<CellMLComponent>();
        HashMap<String, CellMLComponent> importedComponents = new HashMap<String, CellMLComponent>();
        for (CellMLComponent component : componentsToImport) {
            LOGGER.info((Object[])new Object[]{"directly importing component: ", component.getName(), " => ", component.getMetaId()});
            importedComponents.put(component.getName(), component);
            componentToWrite.add(component);
        }
        for (CellMLComponent component : componentsToImportDependency) {
            CellMLComponent done = (CellMLComponent)importedComponents.get(component.getName());
            CellMLComponent org = this.components.get(component.getName());
            if (done != null || org != null) {
                LOGGER.info((Object[])new Object[]{"mmh component: ", component.getName(), " => ", component.getMetaId()});
                String string = component.getName() + "_imported";
                String tmpStr = "";
                AlphabetIterator ai = AlphabetIterator.getUpperCaseIterator();
                while (importedComponents.get(string + tmpStr) != null || this.components.get(string + tmpStr) != null) {
                    tmpStr = "_" + ai.next();
                }
                LOGGER.info((Object[])new Object[]{"renaming to: ", string, tmpStr});
                component.setName(string + tmpStr);
                importedComponents.put(component.getName(), component);
                componentToWrite.add(component);
                continue;
            }
            LOGGER.info((Object[])new Object[]{"importing component: ", component.getName(), " => ", component.getMetaId()});
            importedComponents.put(component.getName(), component);
            componentToWrite.add(component);
        }
        for (CellMLComponent u : componentToWrite) {
            metaRw.rewrite(u);
            for (CellMLVariable var : u.getVariables().values()) {
                metaRw.rewrite(var);
            }
            u.setModel(this);
            thisNode.addChild(u.getDocumentNode().extract());
        }
        for (CellMLHierarchyNode node : hierarchyToAdd.getNodes()) {
            List<CellMLHierarchyNode> kids = node.getChildren();
            if (kids.size() <= 0) continue;
            boolean add = false;
            Element element = new Element("group", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri());
            element.addContent((Content)new Element("relationship_ref", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri()).setAttribute("relationship", "encapsulation"));
            Element parent = new Element("component_ref", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri()).setAttribute("component", node.getComponent().getName());
            element.addContent((Content)parent);
            for (CellMLHierarchyNode cellMLHierarchyNode : kids) {
                if (this.hierarchy.getEncapsulationRelationship(node.getComponent(), cellMLHierarchyNode.getComponent()) == 2) continue;
                Element child = new Element("component_ref", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri()).setAttribute("component", cellMLHierarchyNode.getComponent().getName());
                parent.addContent((Content)child);
                add = true;
            }
            if (!add) continue;
            thisNode.addChild(new DocumentNode(element, thisNode, thisNode.getDocument(), thisNode.getWeighter(), thisNode.getChildrenWithTag(element.getName()).size() + 1, thisNode.getLevel() + 1));
        }
        ArrayList<CellMLComponent> componentsToImportAll = new ArrayList<CellMLComponent>();
        componentsToImportAll.addAll(componentsToImport);
        componentsToImportAll.addAll(componentsToImportDependency);
        for (int i = 0; i < componentsToImportAll.size(); ++i) {
            CellMLComponent componentI = (CellMLComponent)componentsToImportAll.get(i);
            for (int j = i + 1; j < componentsToImportAll.size(); ++j) {
                CellMLComponent cellMLComponent = (CellMLComponent)componentsToImportAll.get(j);
                boolean exists = false;
                for (CellMLConnection.ConnectedComponents connectedComponents : this.connectedComponents) {
                    if ((connectedComponents.component_1 != componentI || connectedComponents.component_2 != cellMLComponent) && (connectedComponents.component_1 != cellMLComponent || connectedComponents.component_2 != componentI)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                class VarConnection {
                    public CellMLVariable varI;
                    public CellMLVariable varJ;

                    public VarConnection(CellMLVariable varI, CellMLVariable varJ) {
                        this.varI = varI;
                        this.varJ = varJ;
                    }
                }
                ArrayList<VarConnection> mappings = new ArrayList<VarConnection>();
                for (CellMLVariable var : componentI.getVariables().values()) {
                    List<CellMLVariable> connections = var.getPrivateInterfaceConnections();
                    for (CellMLVariable con : connections) {
                        if (con.getComponent() != cellMLComponent) continue;
                        mappings.add(new VarConnection(var, con));
                    }
                    connections = var.getPublicInterfaceConnections();
                    for (CellMLVariable con : connections) {
                        if (con.getComponent() != cellMLComponent) continue;
                        mappings.add(new VarConnection(var, con));
                    }
                }
                LOGGER.info((Object[])new Object[]{"found ", mappings.size(), " connections between ", componentI.getName(), " and ", cellMLComponent.getName()});
                if (mappings.size() <= 0) continue;
                Element element = new Element("connection", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri());
                element.addContent((Content)new Element("map_components", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri()).setAttribute("component_1", componentI.getName()).setAttribute("component_2", cellMLComponent.getName()));
                for (VarConnection con : mappings) {
                    element.addContent((Content)new Element("map_variables", thisNode.getNameSpacePrefix(), thisNode.getNameSpaceUri()).setAttribute("variable_1", con.varI.getName()).setAttribute("variable_2", con.varJ.getName()));
                }
                thisNode.addChild(new DocumentNode(element, thisNode, thisNode.getDocument(), thisNode.getWeighter(), thisNode.getChildrenWithTag(element.getName()).size() + 1, thisNode.getLevel() + 1));
            }
        }
        List kids = thisNode.getChildrenWithTag("import");
        ArrayList<DocumentNode> kidsToRemove = new ArrayList<DocumentNode>();
        for (TreeNode treeNode : kids) {
            if (treeNode.getType() != 1) continue;
            kidsToRemove.add((DocumentNode)treeNode);
        }
        for (DocumentNode documentNode : kidsToRemove) {
            documentNode.getParent().rmChild(documentNode);
        }
        this.containsImports = false;
    }

    public CellMLHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void mapNode(DocumentNode node, CellMLEntity entity) {
        this.nodeMapper.put((TreeNode)node, entity);
    }

    public CellMLEntity getFromNode(TreeNode node) {
        return this.nodeMapper.get(node);
    }

    public CellMLEntity getEntityByMetaId(String metaId) {
        return this.metaIdMapper.get(metaId);
    }

    public void registerMetaId(String metaId, CellMLEntity cellMLEntity) throws BivesLogicalException {
        if (this.metaIdMapper.get(metaId) != null) {
            throw new BivesLogicalException("meta id already registered: " + metaId);
        }
        this.metaIdMapper.put(metaId, cellMLEntity);
    }

    public void registerRdfBlock(RDF rdf) {
        this.rdfBlocks.add(rdf);
    }

    public List<RDFDescription> getDescriptions(CellMLEntity entity) {
        String metaId = entity.getMetaId();
        if (metaId == null) {
            return null;
        }
        return this.rdfMapper.get(metaId);
    }

    public void unregisterMetaId(String metaId) {
        this.metaIdMapper.remove(metaId);
    }
}

