/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;

public class CellMLVariable
extends CellMLEntity
implements DiffReporter {
    public static final int INTERFACE_NONE = 0;
    public static final int INTERFACE_IN = -1;
    public static final int INTERFACE_OUT = 1;
    private CellMLComponent component;
    private String name;
    private CellMLUnit unit;
    private Double d_initial_value;
    private CellMLVariable v_initial_value;
    private int public_interface;
    private List<CellMLVariable> public_interface_connection;
    private int private_interface;
    private List<CellMLVariable> private_interface_connection;

    public CellMLVariable(CellMLModel model, CellMLComponent component, DocumentNode node) throws BivesCellMLParseException, BivesLogicalException {
        super(node, model);
        this.component = component;
        this.name = node.getAttributeValue("name");
        if (this.name == null || this.name.length() < 1) {
            throw new BivesCellMLParseException("variable doesn't have a name. (component: " + component.getName() + ")");
        }
        this.unit = component.getUnit(node.getAttributeValue("units"));
        if (this.unit == null) {
            throw new BivesCellMLParseException("variable " + this.name + " doesn't have a valid unit. (component: " + component.getName() + ", searching for: " + node.getAttributeValue("units") + ")");
        }
        this.public_interface = this.parseInterface(node.getAttributeValue("public_interface"));
        this.private_interface = this.parseInterface(node.getAttributeValue("private_interface"));
        if (this.public_interface == this.private_interface && this.public_interface == -1) {
            throw new BivesLogicalException("variable " + this.name + " defines public and private interface to be 'in'. (component: " + component.getName() + ")");
        }
        this.private_interface_connection = new ArrayList<CellMLVariable>();
        this.public_interface_connection = new ArrayList<CellMLVariable>();
        String attr = node.getAttributeValue("initial_value");
        if (attr != null) {
            if (this.public_interface == -1 || this.private_interface == -1) {
                throw new BivesLogicalException("initial_value attribute must not be defined on a <variable> element with a public_interface or private_interface attribute with a value of 'in' (variable: " + this.name + ", component: " + component.getName() + ")");
            }
            try {
                this.d_initial_value = Double.parseDouble(attr);
            }
            catch (NumberFormatException ex) {
                try {
                    this.v_initial_value = component.getVariable(attr);
                }
                catch (BivesDocumentConsistencyException e) {
                    throw new BivesCellMLParseException("cannot understand an initial concentration of '" + attr + "' in variable " + this.name + " (component: " + component.getName() + ")");
                }
            }
        }
    }

    public CellMLComponent getComponent() {
        return this.component;
    }

    public int getPublicInterface() {
        return this.public_interface;
    }

    public int getPrivateInterface() {
        return this.private_interface;
    }

    public String getPublicInterfaceStr() {
        return this.parseInterface(this.public_interface);
    }

    public String getPrivateInterfaceStr() {
        return this.parseInterface(this.private_interface);
    }

    public void addPublicInterfaceConnection(CellMLVariable var) throws BivesLogicalException {
        if (this.public_interface == -1 && this.public_interface_connection.size() > 0) {
            throw new BivesLogicalException("variable " + this.name + " defines public interface to be 'in' but wants to add more than one connection. (component: " + this.component.getName() + ")");
        }
        this.public_interface_connection.add(var);
    }

    public void addPrivateInterfaceConnection(CellMLVariable var) throws BivesLogicalException {
        if (this.private_interface == -1 && this.private_interface_connection.size() > 0) {
            throw new BivesLogicalException("variable " + this.name + " defines private interface to be 'in' but wants to add more than one connection. (component: " + this.component.getName() + ")");
        }
        this.private_interface_connection.add(var);
    }

    public List<CellMLVariable> getPublicInterfaceConnections() {
        return this.public_interface_connection;
    }

    public List<CellMLVariable> getPrivateInterfaceConnections() {
        return this.private_interface_connection;
    }

    public CellMLVariable getRootVariable() {
        if (this.private_interface == -1 && this.private_interface_connection.size() == 1) {
            return this.private_interface_connection.get(0).getRootVariable();
        }
        if (this.public_interface == -1 && this.public_interface_connection.size() == 1) {
            return this.public_interface_connection.get(0).getRootVariable();
        }
        return this;
    }

    public CellMLVariable getInitialValueVariable() {
        return this.v_initial_value;
    }

    public Double getInitialValue() {
        return this.d_initial_value;
    }

    public void unconnect() {
        this.public_interface_connection = new ArrayList<CellMLVariable>();
        this.private_interface_connection = new ArrayList<CellMLVariable>();
    }

    private String parseInterface(int attr) {
        if (attr == -1) {
            return "in";
        }
        if (attr == 1) {
            return "out";
        }
        return "none";
    }

    private int parseInterface(String attr) {
        if (attr == null) {
            return 0;
        }
        if (attr.equals("in")) {
            return -1;
        }
        if (attr.equals("out")) {
            return 1;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void getDependencies(Map<CellMLUserUnit, List<CellMLEntity>> list) {
        if (!this.unit.isStandardUnits()) {
            CellMLUserUnit unit = (CellMLUserUnit)this.unit;
            if (list.get(unit) == null) {
                list.put(unit, new ArrayList());
            }
            list.get(unit).add(this);
            unit.getDependencies(list);
        }
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        CellMLVariable a = (CellMLVariable)docA;
        CellMLVariable b = (CellMLVariable)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.name;
        String idB = b.name;
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement("Variable: " + idA) : new MarkupElement("Variable: " + MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.getDocumentNode(), (DocumentNode)b.getDocumentNode(), (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement("Variable: " + MarkupDocument.insert((String)this.name));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement("Variable: " + MarkupDocument.delete((String)this.name));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }

    public void renameUnit(String original, String newName) throws BivesLogicalException {
        Attribute attr = this.getDocumentNode().getAttribute("units");
        if (attr == null || !attr.getValue().equals(original)) {
            throw new BivesLogicalException("cannot rename unit from " + original + " to " + newName + " (we don't know this unit)");
        }
        attr.setValue(newName);
    }
}

