/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.algorithm;

import de.unirostock.sems.bives.algorithm.Connector;
import de.unirostock.sems.bives.algorithm.general.XyDiffConnector;
import de.unirostock.sems.bives.cellml.algorithm.CellMLConnectorPreprocessor;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.List;

public class CellMLConnector
extends Connector {
    private Connector preprocessor;
    private CellMLDocument cellmlDocA;
    private CellMLDocument cellmlDocB;

    public CellMLConnector(CellMLDocument cellmlDocA, CellMLDocument cellmlDocB, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(cellmlDocA.getTreeDocument(), cellmlDocB.getTreeDocument(), allowDifferentIds, careAboutNames, stricterNames);
        this.cellmlDocA = cellmlDocA;
        this.cellmlDocB = cellmlDocB;
    }

    public CellMLConnector(CellMLDocument cellmlDocA, CellMLDocument cellmlDocB) {
        super(cellmlDocA.getTreeDocument(), cellmlDocB.getTreeDocument());
        this.cellmlDocA = cellmlDocA;
        this.cellmlDocB = cellmlDocB;
    }

    public CellMLConnector(Connector preprocessor, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(preprocessor.getDocA(), preprocessor.getDocB(), allowDifferentIds, careAboutNames, stricterNames);
        this.preprocessor = preprocessor;
    }

    public CellMLConnector(Connector preprocessor) {
        super(preprocessor.getDocA(), preprocessor.getDocB());
        this.preprocessor = preprocessor;
    }

    protected void init() throws BivesConnectionException {
        if (this.preprocessor == null) {
            XyDiffConnector id = new XyDiffConnector((Connector)new CellMLConnectorPreprocessor(this.cellmlDocA, this.cellmlDocB, this.allowDifferentIds, this.careAboutNames, this.stricterNames), this.allowDifferentIds, this.careAboutNames, this.stricterNames);
            id.findConnections();
            this.conMgmt = id.getConnections();
        } else {
            this.preprocessor.findConnections();
            this.conMgmt = this.preprocessor.getConnections();
        }
    }

    protected void connect() {
        List lists = this.docA.getNodesByTag("variable");
        lists.addAll(this.docA.getNodesByTag("reaction"));
        for (DocumentNode tn : lists) {
            TreeNode partner;
            Connection con = this.conMgmt.getConnectionForNode((TreeNode)tn);
            if (con == null || !tn.networkDiffers(partner = con.getTreeB(), (ConnectionManager)this.conMgmt, con)) continue;
            this.conMgmt.dropConnection((TreeNode)tn);
        }
    }
}

