/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.api;

import de.unirostock.sems.bives.api.Single;
import de.unirostock.sems.bives.cellml.algorithm.CellMLGraphProducer;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorDot;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorGraphML;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorJson;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesImportException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import de.unirostock.sems.xmlutils.tools.DocumentTools;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class CellMLSingle
extends Single {
    private CellMLDocument doc;
    protected CellMLGraphProducer graphProducer;

    public CellMLSingle(File file) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(file);
        this.doc = new CellMLDocument(this.tree);
    }

    public CellMLSingle(String xml) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(xml);
        this.doc = new CellMLDocument(this.tree);
    }

    public CellMLSingle(TreeDocument td) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(td);
        this.doc = new CellMLDocument(this.tree);
    }

    public CellMLSingle(CellMLDocument doc) {
        super(doc.getTreeDocument());
        this.doc = doc;
    }

    public String getReactionsGraphML() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return new GraphTranslatorGraphML().translate(this.graphProducer.getReactionNetwork());
    }

    public Object getHierarchyGraph(GraphTranslator gt) throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return gt.translate(this.graphProducer.getHierarchy());
    }

    public String getHierarchyGraphML() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return new GraphTranslatorGraphML().translate(this.graphProducer.getHierarchy());
    }

    public Object getReactionsGraph(GraphTranslator gt) throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return gt.translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsDotGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return new GraphTranslatorDot().translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return new GraphTranslatorJson().translate(this.graphProducer.getReactionNetwork());
    }

    public String getHierarchyDotGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return new GraphTranslatorDot().translate(this.graphProducer.getHierarchy());
    }

    public String getHierarchyJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.doc);
        }
        return new GraphTranslatorJson().translate(this.graphProducer.getHierarchy());
    }

    public String flatten() throws Exception {
        this.doc.flatten();
        return XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)this.doc.getTreeDocument()));
    }
}

