/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.ds.ModelDocument;
import de.unirostock.sems.bives.ds.rdf.RDFDescription;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesFlattenException;
import de.unirostock.sems.bives.exception.BivesImportException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentConsistencyException;
import de.unirostock.sems.xmlutils.tools.DocumentTools;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;

public class CellMLDocument
extends ModelDocument {
    private CellMLModel model;
    private List<RDFDescription> rdfDescriptions;

    public CellMLDocument(TreeDocument doc) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, IOException, URISyntaxException, BivesImportException {
        super(doc);
        if (!doc.getRoot().getTagName().equals("model")) {
            throw new BivesCellMLParseException("cellml document does not define a model");
        }
        this.rdfDescriptions = new ArrayList<RDFDescription>();
        this.model = new CellMLModel(this, doc.getRoot());
    }

    public CellMLModel getModel() {
        return this.model;
    }

    public boolean containsImports() {
        return this.model.containsImports();
    }

    public void flatten() throws BivesFlattenException, BivesDocumentConsistencyException, XmlDocumentConsistencyException, BivesLogicalException {
        this.model.flatten();
    }

    public void write(File dest) throws IOException {
        String s = XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)this.doc));
        BufferedWriter bw = new BufferedWriter(new FileWriter(dest));
        bw.write(s);
        bw.close();
    }

    public void associateRdfDescription(RDFDescription descr) {
        this.rdfDescriptions.add(descr);
    }
}

