/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.algorithm;

import de.unirostock.sems.bives.algorithm.Interpreter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLReaction;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.markup.MarkupSection;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CellMLDiffInterpreter
extends Interpreter {
    private MarkupDocument markupDocument;
    private CellMLDocument cellmlDocA;
    private CellMLDocument cellmlDocB;

    public CellMLDiffInterpreter(SimpleConnectionManager conMgmt, CellMLDocument cellmlDocA, CellMLDocument cellmlDocB) {
        super(conMgmt, cellmlDocA.getTreeDocument(), cellmlDocB.getTreeDocument());
        this.cellmlDocA = cellmlDocA;
        this.cellmlDocB = cellmlDocB;
    }

    public MarkupDocument getReport() {
        if (this.markupDocument == null) {
            this.interprete();
        }
        return this.markupDocument;
    }

    public void interprete() {
        if (this.markupDocument != null) {
            return;
        }
        this.markupDocument = new MarkupDocument("CellML Differences");
        CellMLModel modelA = this.cellmlDocA.getModel();
        CellMLModel modelB = this.cellmlDocB.getModel();
        this.checkComponents(modelA, modelB);
    }

    private void checkComponents(CellMLModel modelA, CellMLModel modelB) {
        MarkupElement me;
        List<MathML> math;
        Iterator<CellMLReaction> var2;
        HashMap<String, CellMLVariable> vars;
        HashMap<String, CellMLUserUnit> componentUnits;
        MarkupSection msec;
        Connection con;
        DocumentNode dn;
        CellMLUnitDictionary unitsA = modelA.getUnits();
        CellMLUnitDictionary unitsB = modelB.getUnits();
        MarkupSection unitsSec = new MarkupSection("Global Units");
        HashMap<String, CellMLUserUnit> modelUnits = unitsA.getModelUnits();
        for (CellMLUserUnit unit2 : modelUnits.values()) {
            DocumentNode dn2 = unit2.getDocumentNode();
            Connection con2 = this.conMgmt.getConnectionForNode((TreeNode)dn2);
            if (con2 == null) {
                unitsSec.addValue(unit2.reportDelete());
                continue;
            }
            CellMLUserUnit unitB = (CellMLUserUnit)modelB.getFromNode(con2.getPartnerOf((TreeNode)dn2));
            MarkupElement element = unit2.reportModification(this.conMgmt, unit2, unitB);
            if (element == null) continue;
            unitsSec.addValue(element);
        }
        modelUnits = unitsB.getModelUnits();
        for (CellMLUserUnit unit : modelUnits.values()) {
            DocumentNode dn2 = unit.getDocumentNode();
            Connection con2 = this.conMgmt.getConnectionForNode((TreeNode)dn2);
            if (con2 != null) continue;
            unitsSec.addValue(unit.reportInsert());
        }
        if (unitsSec.getValues().size() > 0) {
            this.markupDocument.addSection(unitsSec);
        }
        HashMap<String, CellMLComponent> components = modelA.getComponents();
        for (CellMLComponent component : components.values()) {
            dn = component.getDocumentNode();
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec = new MarkupSection("Component " + MarkupDocument.delete((String)MarkupDocument.highlight((String)component.getName())));
                componentUnits = unitsA.getComponentUnits(component);
                if (componentUnits != null) {
                    for (CellMLUserUnit cellMLUserUnit : componentUnits.values()) {
                        msec.addValue(cellMLUserUnit.reportDelete());
                    }
                }
                vars = component.getVariables();
                for (Iterator<CellMLReaction> var2 : vars.values()) {
                    msec.addValue(((CellMLVariable)((Object)var2)).reportDelete());
                }
                List<CellMLReaction> list = component.getReactions();
                var2 = list.iterator();
                while (var2.hasNext()) {
                    CellMLReaction cellMLReaction = (CellMLReaction)var2.next();
                    msec.addValue(cellMLReaction.reportDelete());
                }
                math = component.getMath();
                for (MathML m : math) {
                    me = new MarkupElement("math");
                    BivesTools.genMathMarkupStats((DocumentNode)m.getDocumentNode(), null, (MarkupElement)me);
                    msec.addValue(me);
                }
                if (msec.getValues().size() <= 0) continue;
                this.markupDocument.addSection(msec);
                continue;
            }
            msec = new MarkupSection("Component " + MarkupDocument.highlight((String)component.getName()));
            CellMLComponent componentB = (CellMLComponent)modelB.getFromNode(con.getPartnerOf((TreeNode)dn));
            HashMap<String, CellMLUserUnit> componentUnitsA = unitsA.getComponentUnits(component);
            HashMap<String, CellMLUserUnit> hashMap = unitsB.getComponentUnits(componentB);
            this.checkUnits(msec, componentUnitsA, hashMap, modelA, modelB);
            HashMap<String, CellMLVariable> varsA = component.getVariables();
            HashMap<String, CellMLVariable> hashMap2 = componentB.getVariables();
            this.checkVariables(msec, varsA, hashMap2, modelA, modelB);
            List<CellMLReaction> reactionsA = component.getReactions();
            List<CellMLReaction> reactionsB = componentB.getReactions();
            this.checkReactions(msec, reactionsA, reactionsB, modelA, modelB);
            List<MathML> mathA = component.getMath();
            List<MathML> mathB = componentB.getMath();
            this.checkMath(msec, mathA, mathB, modelA, modelB);
            if (msec.getValues().size() <= 0) continue;
            this.markupDocument.addSection(msec);
        }
        components = modelB.getComponents();
        for (CellMLComponent component : components.values()) {
            dn = component.getDocumentNode();
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            msec = new MarkupSection("Component " + MarkupDocument.insert((String)MarkupDocument.highlight((String)component.getName())));
            if (con == null) {
                componentUnits = unitsB.getComponentUnits(component);
                if (componentUnits != null) {
                    for (CellMLUserUnit cellMLUserUnit : componentUnits.values()) {
                        msec.addValue(cellMLUserUnit.reportInsert());
                    }
                }
                vars = component.getVariables();
                for (Iterator<CellMLReaction> var2 : vars.values()) {
                    msec.addValue(((CellMLVariable)((Object)var2)).reportInsert());
                }
                List<CellMLReaction> list = component.getReactions();
                var2 = list.iterator();
                while (var2.hasNext()) {
                    CellMLReaction cellMLReaction = var2.next();
                    msec.addValue(cellMLReaction.reportInsert());
                }
                math = component.getMath();
                for (MathML m : math) {
                    me = new MarkupElement("math");
                    BivesTools.genMathMarkupStats(null, (DocumentNode)m.getDocumentNode(), (MarkupElement)me);
                    msec.addValue(me);
                }
            }
            if (msec.getValues().size() <= 0) continue;
            this.markupDocument.addSection(msec);
        }
    }

    private void checkMath(MarkupSection msec, List<MathML> mathA, List<MathML> mathB, CellMLModel modelA, CellMLModel modelB) {
        MarkupElement me;
        Connection con;
        boolean report = true;
        for (MathML mA : mathA) {
            con = this.conMgmt.getConnectionForNode((TreeNode)mA.getDocumentNode());
            report = true;
            if (con != null) {
                TreeNode mb = con.getPartnerOf((TreeNode)mA.getDocumentNode());
                for (MathML mlb : mathB) {
                    if (mlb.getDocumentNode() != mb) continue;
                    MarkupElement me2 = new MarkupElement("math");
                    BivesTools.genMathMarkupStats((DocumentNode)mA.getDocumentNode(), (DocumentNode)mlb.getDocumentNode(), (MarkupElement)me2);
                    if (me2.getValues().size() > 0) {
                        msec.addValue(me2);
                    }
                    report = false;
                    break;
                }
            }
            if (!report) continue;
            me = new MarkupElement("math");
            BivesTools.genMathMarkupStats((DocumentNode)mA.getDocumentNode(), null, (MarkupElement)me);
            msec.addValue(me);
        }
        for (MathML mB : mathB) {
            con = this.conMgmt.getConnectionForNode((TreeNode)mB.getDocumentNode());
            report = true;
            if (con != null) {
                TreeNode ma = con.getPartnerOf((TreeNode)mB.getDocumentNode());
                for (MathML mla : mathA) {
                    if (mla.getDocumentNode() != ma) continue;
                    report = false;
                }
            }
            if (!report) continue;
            me = new MarkupElement("math");
            BivesTools.genMathMarkupStats(null, (DocumentNode)mB.getDocumentNode(), (MarkupElement)me);
            msec.addValue(me);
        }
    }

    private void checkReactions(MarkupSection msec, List<CellMLReaction> reactionsA, List<CellMLReaction> reactionsB, CellMLModel modelA, CellMLModel modelB) {
        Connection con;
        for (CellMLReaction reactionA : reactionsA) {
            CellMLReaction reactionB;
            con = this.conMgmt.getConnectionForNode((TreeNode)reactionA.getDocumentNode());
            if (con != null && reactionsB.contains(reactionB = (CellMLReaction)modelB.getFromNode(con.getPartnerOf((TreeNode)reactionA.getDocumentNode())))) {
                MarkupElement element = reactionA.reportModification(this.conMgmt, reactionA, reactionB);
                if (element == null || element.getValues().size() <= 0) continue;
                msec.addValue(element);
                continue;
            }
            msec.addValue(reactionA.reportDelete());
        }
        for (CellMLReaction reactionB : reactionsB) {
            CellMLReaction reactionA;
            con = this.conMgmt.getConnectionForNode((TreeNode)reactionB.getDocumentNode());
            if (con != null && reactionsA.contains(reactionA = (CellMLReaction)modelA.getFromNode(con.getPartnerOf((TreeNode)reactionB.getDocumentNode())))) continue;
            msec.addValue(reactionB.reportInsert());
        }
    }

    private void checkVariables(MarkupSection msec, HashMap<String, CellMLVariable> varsA, HashMap<String, CellMLVariable> varsB, CellMLModel modelA, CellMLModel modelB) {
        Connection con;
        for (CellMLVariable varA : varsA.values()) {
            CellMLVariable varB;
            con = this.conMgmt.getConnectionForNode((TreeNode)varA.getDocumentNode());
            if (con != null && (varB = (CellMLVariable)modelB.getFromNode(con.getPartnerOf((TreeNode)varA.getDocumentNode()))) == varsB.get(varB.getName())) {
                MarkupElement element = varA.reportModification(this.conMgmt, varA, varB);
                if (element == null || element.getValues().size() <= 0) continue;
                msec.addValue(element);
                continue;
            }
            msec.addValue(varA.reportDelete());
        }
        for (CellMLVariable varB : varsB.values()) {
            CellMLVariable varA;
            con = this.conMgmt.getConnectionForNode((TreeNode)varB.getDocumentNode());
            if (con != null && (varA = (CellMLVariable)modelA.getFromNode(con.getPartnerOf((TreeNode)varB.getDocumentNode()))) == varsA.get(varA.getName())) continue;
            msec.addValue(varB.reportInsert());
        }
    }

    private void checkUnits(MarkupSection msec, HashMap<String, CellMLUserUnit> unitsA, HashMap<String, CellMLUserUnit> unitsB, CellMLModel modelA, CellMLModel modelB) {
        Connection con;
        if (unitsA != null) {
            for (CellMLUserUnit unitA : unitsA.values()) {
                CellMLUserUnit unitB;
                con = this.conMgmt.getConnectionForNode((TreeNode)unitA.getDocumentNode());
                if (con != null && unitsB != null && (unitB = (CellMLUserUnit)modelB.getFromNode(con.getPartnerOf((TreeNode)unitA.getDocumentNode()))) == unitsB.get(unitB.getName())) {
                    MarkupElement element = unitA.reportModification(this.conMgmt, unitA, unitB);
                    if (element == null || element.getValues().size() <= 0) continue;
                    msec.addValue(element);
                    continue;
                }
                msec.addValue(unitA.reportDelete());
            }
        }
        if (unitsB != null) {
            for (CellMLUserUnit unitB : unitsB.values()) {
                CellMLUserUnit unitA;
                con = this.conMgmt.getConnectionForNode((TreeNode)unitB.getDocumentNode());
                if (con != null && unitsA != null && (unitA = (CellMLUserUnit)modelA.getFromNode(con.getPartnerOf((TreeNode)unitB.getDocumentNode()))) == unitsA.get(unitA.getName())) continue;
                msec.addValue(unitB.reportInsert());
            }
        }
    }
}

