/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.algorithm;

import de.unirostock.sems.bives.algorithm.Connector;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.algorithm.general.IdConnector;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;

public class CellMLConnectorPreprocessor
extends Connector {
    private Connector preprocessor;
    private CellMLDocument cellmlDocA;
    private CellMLDocument cellmlDocB;

    public CellMLConnectorPreprocessor(CellMLDocument cellmlDocA, CellMLDocument cellmlDocB, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(cellmlDocA.getTreeDocument(), cellmlDocB.getTreeDocument(), allowDifferentIds, careAboutNames, stricterNames);
        this.cellmlDocA = cellmlDocA;
        this.cellmlDocB = cellmlDocB;
    }

    public CellMLConnectorPreprocessor(CellMLDocument cellmlDocA, CellMLDocument cellmlDocB) {
        super(cellmlDocA.getTreeDocument(), cellmlDocB.getTreeDocument());
        this.cellmlDocA = cellmlDocA;
        this.cellmlDocB = cellmlDocB;
    }

    public CellMLConnectorPreprocessor(Connector preprocessor, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(preprocessor.getDocA(), preprocessor.getDocB(), allowDifferentIds, careAboutNames, stricterNames);
        this.preprocessor = preprocessor;
    }

    public CellMLConnectorPreprocessor(Connector preprocessor) {
        super(preprocessor.getDocA(), preprocessor.getDocB());
        this.preprocessor = preprocessor;
    }

    protected void init() throws BivesConnectionException {
        if (this.preprocessor == null) {
            IdConnector id = new IdConnector(this.docA, this.docB, true);
            id.findConnections();
            this.conMgmt = id.getConnections();
        } else {
            this.preprocessor.findConnections();
            this.conMgmt = this.preprocessor.getConnections();
        }
    }

    protected void connect() throws BivesConnectionException {
        CellMLModel modelA = this.cellmlDocA.getModel();
        CellMLModel modelB = this.cellmlDocB.getModel();
        CellMLUnitDictionary unitsA = modelA.getUnits();
        CellMLUnitDictionary unitsB = modelB.getUnits();
        HashMap<String, CellMLUserUnit> modelUnitsA = unitsA.getModelUnits();
        HashMap<String, CellMLUserUnit> modelUnitsB = unitsB.getModelUnits();
        for (String id : modelUnitsA.keySet()) {
            CellMLUserUnit cA;
            CellMLUserUnit cB = modelUnitsB.get(id);
            if (cB == null || this.conMgmt.getConnectionForNode((TreeNode)(cA = modelUnitsA.get(id)).getDocumentNode()) != null || this.conMgmt.getConnectionForNode((TreeNode)cB.getDocumentNode()) != null) continue;
            this.conMgmt.addConnection(new NodeConnection((TreeNode)cA.getDocumentNode(), (TreeNode)cB.getDocumentNode()));
        }
        HashMap<String, CellMLComponent> componentsA = modelA.getComponents();
        HashMap<String, CellMLComponent> componentsB = modelB.getComponents();
        for (String id : componentsA.keySet()) {
            CellMLComponent cA;
            CellMLComponent cB = componentsB.get(id);
            if (cB == null || this.conMgmt.getConnectionForNode((TreeNode)(cA = componentsA.get(id)).getDocumentNode()) != null || this.conMgmt.getConnectionForNode((TreeNode)cB.getDocumentNode()) != null) continue;
            this.conMgmt.addConnection(new NodeConnection((TreeNode)cA.getDocumentNode(), (TreeNode)cB.getDocumentNode()));
        }
    }
}

