/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.algorithm;

import de.unirostock.sems.bives.algorithm.general.DefaultDiffAnnotator;
import de.unirostock.sems.comodi.Change;
import de.unirostock.sems.comodi.ChangeFactory;
import de.unirostock.sems.comodi.branches.ComodiReason;
import de.unirostock.sems.comodi.branches.ComodiTarget;
import de.unirostock.sems.comodi.branches.ComodiXmlEntity;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class CellMLDiffAnnotator
extends DefaultDiffAnnotator {
    private Pattern variablePath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]/variable\\[\\d+\\]$");
    private Pattern componentPath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]$");
    private Pattern componentMathPath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]/math\\[\\d+\\]");
    private Pattern componentReactionNetworkPath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]/reaction\\[\\d+\\]");
    private Pattern unitsPath = Pattern.compile("^/model\\[\\d+\\]/units\\[\\d+\\]");
    private Pattern componentUnitsPath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]/units\\[\\d+\\]");
    private Pattern variableConnectionPath = Pattern.compile("^/model\\[\\d+\\]/connection\\[\\d+\\]");
    private Pattern componentHierarchyPath = Pattern.compile("^/model\\[\\d+\\]/group\\[\\d+\\]");
    private Pattern annotationPath = Pattern.compile("^/model\\[\\d+\\]/(.+/)*RDF\\[\\d+\\]");
    private Pattern textualDescriptionPath = Pattern.compile("^/model\\[\\d+\\]/(.+/)*documentation\\[\\d+\\]");
    private Pattern contributorPath = Pattern.compile("^/model\\[\\d+\\]/(.*/)*RDF\\[\\d+\\]/(.*/)*Description\\[\\d+\\]/(.*/)*contributor\\[\\d+\\]");
    private Pattern creatorPath = Pattern.compile("^/model\\[\\d+\\]/(.*/)*RDF\\[\\d+\\]/(.*/)*Description\\[\\d+\\]/(.*/)*creator\\[\\d+\\]");
    public static final Pattern creationDatePath = Pattern.compile("^/model\\[\\d+\\]/(.*/)*RDF\\[\\d+\\]/(.*/)*created\\[\\d+\\]");
    public static final Pattern modificationDatePath = Pattern.compile("^/model\\[\\d+\\]/(.*/)*RDF\\[\\d+\\]/(.*/)*modified\\[\\d+\\]");
    private Pattern textualDescriptionAttributionPath = Pattern.compile("^/model\\[\\d+\\]/(.+/)*documentation\\[\\d+\\]/(.+/)*article\\[\\d+\\]/");
    private Pattern textualDescriptionPersonPath = Pattern.compile("^/model\\[\\d+\\]/(.+/)*documentation\\[\\d+\\]/(.+/)*article\\[\\d+\\]/(.+/)*author\\[\\d+\\]");
    private Pattern annotationDescriptionPath = Pattern.compile("^/model\\[\\d+\\]/(.*/)*RDF\\[\\d+\\]/(.*/)*Description\\[\\d+\\]");
    private Pattern componentReactionNetworkVarRefPath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]/reaction\\[\\d+\\]/variable_ref\\[\\d+\\]");
    private Pattern componentReactionNetworkVarRefRolePath = Pattern.compile("^/model\\[\\d+\\]/component\\[\\d+\\]/reaction\\[\\d+\\]/variable_ref\\[\\d+\\]/role\\[\\d+\\]");

    public Change annotateDeletion(TreeNode node, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateDeletion(node, diffNode, changeFac);
        this.annotateTarget(change, node, null, diffNode, false);
        return change;
    }

    public Change annotateInsertion(TreeNode node, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateInsertion(node, diffNode, changeFac);
        this.annotateTarget(change, null, node, diffNode, false);
        return change;
    }

    public Change annotateMove(TreeNode nodeA, TreeNode nodeB, Element diffNode, ChangeFactory changeFac, boolean permutation) {
        Change change = super.annotateMove(nodeA, nodeB, diffNode, changeFac, permutation);
        this.annotateTarget(change, nodeA, nodeB, diffNode, permutation);
        return change;
    }

    public Change annotateUpdateAttribute(TreeNode nodeA, TreeNode nodeB, String attributeName, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateUpdateAttribute(nodeA, nodeB, attributeName, diffNode, changeFac);
        this.annotateTarget(change, nodeA, nodeB, diffNode, false);
        return change;
    }

    public Change annotateUpdateText(TextNode nodeA, TextNode nodeB, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateUpdateText(nodeA, nodeB, diffNode, changeFac);
        this.annotateTarget(change, (TreeNode)nodeA, (TreeNode)nodeB, diffNode, false);
        return change;
    }

    public void annotatePatch(String rootId, ChangeFactory changeFac) {
        super.annotatePatch(rootId, changeFac);
    }

    private Change annotateTarget(Change change, TreeNode nodeA, TreeNode nodeB, Element diffNode, boolean permutation) {
        String attr;
        String xPath;
        TreeNode defNode = nodeA == null ? nodeB : nodeA;
        String string = xPath = diffNode.getAttributeValue("newPath") == null ? diffNode.getAttributeValue("oldPath") : diffNode.getAttributeValue("newPath");
        if (defNode.getTagName().equals("model") && nodeA != null && nodeB != null && !((DocumentNode)nodeA).getNameSpaceUri().equals(((DocumentNode)nodeB).getNameSpaceUri())) {
            change.hasReason(ComodiReason.getChangedSpecification());
        }
        if (defNode.getParent() == null && diffNode.getName().equals("attribute") && diffNode.getAttributeValue("name").equals("name") && defNode.getTagName().equals("model")) {
            change.appliesTo(ComodiXmlEntity.getModelName());
        } else if (defNode.getParent() == null && diffNode.getName().equals("attribute") && diffNode.getAttributeValue("name").equals("id") && defNode.getTagName().equals("model")) {
            change.appliesTo(ComodiXmlEntity.getModelId());
        }
        boolean isAnnotation = this.annotationPath.matcher(xPath).find();
        if (!isAnnotation && this.variablePath.matcher(xPath).find() && defNode.getTagName().equals("variable")) {
            if (diffNode.getName().equals("attribute")) {
                attr = diffNode.getAttributeValue("name");
                if (attr.equals("id") || attr.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr.equals("initial_value") || attr.equals("units")) {
                    change.affects(ComodiTarget.getVariableSetup());
                }
            } else if (diffNode.getName().equals("node") && !diffNode.getParentElement().getName().equals("move")) {
                change.affects(ComodiTarget.getComponentDefinition());
            } else if (diffNode.getName().equals("node") && diffNode.getParentElement().getName().equals("move")) {
                if (!permutation) {
                    change.affects(ComodiTarget.getComponentDefinition());
                }
            } else {
                change.affects(ComodiTarget.getVariableSetup());
            }
        }
        if (!isAnnotation && this.componentPath.matcher(xPath).find() && defNode.getTagName().equals("component")) {
            if (diffNode.getName().equals("attribute")) {
                attr = diffNode.getAttributeValue("name");
                if (attr.equals("id") || attr.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                }
            } else {
                change.affects(ComodiTarget.getComponentDefinition());
            }
        }
        if (this.componentMathPath.matcher(xPath).find()) {
            change.affects(ComodiTarget.getMathematicalModelDefinition());
            if (defNode.getTagName().equals("math") && defNode.getParent().getTagName().equals("component")) {
                if (diffNode.getName().equals("node") && !diffNode.getParentElement().getName().equals("move")) {
                    change.affects(ComodiTarget.getComponentDefinition());
                } else if (diffNode.getName().equals("node") && diffNode.getParentElement().getName().equals("move") && !permutation) {
                    change.affects(ComodiTarget.getComponentDefinition());
                }
            }
        }
        if (!isAnnotation && this.componentReactionNetworkPath.matcher(xPath).find()) {
            change.affects(ComodiTarget.getReactionNetworkDefinition());
            if (defNode.getTagName().equals("reaction") && defNode.getParent().getTagName().equals("component")) {
                if (diffNode.getName().equals("node") && !diffNode.getParentElement().getName().equals("move")) {
                    change.affects(ComodiTarget.getComponentDefinition());
                } else if (diffNode.getName().equals("node") && diffNode.getParentElement().getName().equals("move")) {
                    if (!permutation) {
                        change.affects(ComodiTarget.getComponentDefinition());
                    }
                } else if (diffNode.getName().equals("attribute") && diffNode.getAttributeValue("name").equals("reversible")) {
                    change.affects(ComodiTarget.getReversibilityDefinition());
                }
            }
            if (this.componentReactionNetworkVarRefPath.matcher(xPath).find()) {
                change.affects(ComodiTarget.getParticipantDefinition());
                if (this.componentReactionNetworkVarRefRolePath.matcher(xPath).find()) {
                    if (diffNode.getName().equals("attribute") && diffNode.getAttributeValue("name").equals("role")) {
                        change.affects(ComodiTarget.getReactionNetworkDefinition());
                    } else {
                        change.affects(ComodiTarget.getReactionDefinition());
                    }
                }
            }
        }
        if (!isAnnotation && this.unitsPath.matcher(xPath).find()) {
            if (diffNode.getName().equals("attribute") && ((attr = diffNode.getAttributeValue("name")).equals("id") || attr.equals("name"))) {
                change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
            }
            if (!permutation || !defNode.getParent().getTagName().equals("model")) {
                change.affects(ComodiTarget.getUnitDefinition());
            }
        }
        if (!isAnnotation && this.componentUnitsPath.matcher(xPath).find()) {
            if (diffNode.getName().equals("attribute") && ((attr = diffNode.getAttributeValue("name")).equals("id") || attr.equals("name"))) {
                change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
            }
            if (!permutation) {
                change.affects(ComodiTarget.getUnitDefinition());
            }
            if (defNode.getTagName().equals("units") && defNode.getParent().getTagName().equals("component")) {
                if (diffNode.getName().equals("node") && !diffNode.getParentElement().getName().equals("move")) {
                    change.affects(ComodiTarget.getComponentDefinition());
                } else if (diffNode.getName().equals("node") && diffNode.getParentElement().getName().equals("move")) {
                    if (!permutation) {
                        change.affects(ComodiTarget.getComponentDefinition());
                    }
                } else if (diffNode.getName().equals("attribute") && diffNode.getAttributeValue("name").equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                }
            }
        }
        if (this.variableConnectionPath.matcher(xPath).find() && !permutation) {
            change.affects(ComodiTarget.getVariableConnectionDefinition());
        }
        if (this.componentHierarchyPath.matcher(xPath).find() && !permutation) {
            change.affects(ComodiTarget.getHierarchyDefinition());
        }
        if (this.annotationPath.matcher(xPath).find()) {
            if (this.creatorPath.matcher(xPath).find()) {
                change.affects(ComodiTarget.getCreator());
            } else if (this.contributorPath.matcher(xPath).find()) {
                change.affects(ComodiTarget.getContributor());
            } else if (creationDatePath.matcher(xPath).find()) {
                change.affects(ComodiTarget.getCreationDate());
            } else if (modificationDatePath.matcher(xPath).find()) {
                change.affects(ComodiTarget.getModificationDate());
            } else if (this.annotationDescriptionPath.matcher(xPath).find() && diffNode.getName().equals("attribute")) {
                attr = diffNode.getAttributeValue("name");
                if (attr.equals("about") && nodeA != null && nodeB != null) {
                    String oldValue = diffNode.getAttributeValue("oldValue");
                    String newValue = diffNode.getAttributeValue("newValue");
                    if (oldValue != null && newValue != null && (oldValue.startsWith("http") || newValue.startsWith("http") || oldValue.startsWith("urn") || newValue.startsWith("urn"))) {
                        change.affects(ComodiTarget.getOntologyReference());
                        if (oldValue.startsWith("urn:") && !newValue.startsWith("urn:") || !oldValue.startsWith("urn:") && newValue.startsWith("urn:")) {
                            change.affects(ComodiTarget.getIdentifierEncoding());
                        }
                        if (oldValue.startsWith("http:") && !newValue.startsWith("http:") || !oldValue.startsWith("http:") && newValue.startsWith("http:")) {
                            change.affects(ComodiTarget.getIdentifierEncoding());
                        }
                        if (oldValue.contains("identifiers.org") && !newValue.contains("identifiers.org") || !oldValue.contains("identifiers.org") && newValue.contains("identifiers.org")) {
                            change.affects(ComodiTarget.getIdentifierEncoding());
                        }
                    }
                } else {
                    change.affects(ComodiTarget.getModelAnnotation());
                }
            } else {
                change.affects(ComodiTarget.getModelAnnotation());
            }
        }
        if (this.textualDescriptionPath.matcher(xPath).find()) {
            if (this.textualDescriptionAttributionPath.matcher(xPath).find()) {
                if (this.textualDescriptionPersonPath.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getPerson());
                }
                change.affects(ComodiTarget.getAttribution());
            }
            change.affects(ComodiTarget.getTextualDescription());
        }
        return change;
    }
}

