/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.algorithm;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.GraphProducer;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNetwork;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNode;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLReaction;
import de.unirostock.sems.bives.cellml.parser.CellMLReactionSubstance;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkComponent;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkVariable;
import de.unirostock.sems.bives.ds.ontology.SBOTerm;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.exception.BivesUnsupportedException;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import java.util.List;

public class CellMLGraphProducer
extends GraphProducer {
    private CellMLDocument cellmlDocA;
    private CellMLDocument cellmlDocB;
    private SimpleConnectionManager conMgmt;
    private ReactionNetworkCompartment wholeCompartment;

    public CellMLGraphProducer(SimpleConnectionManager conMgmt, CellMLDocument cellmlDocA, CellMLDocument cellmlDocB) {
        super(false);
        this.cellmlDocA = cellmlDocA;
        this.cellmlDocB = cellmlDocB;
        this.conMgmt = conMgmt;
    }

    public CellMLGraphProducer(CellMLDocument cellmlDoc) {
        super(true);
        this.cellmlDocA = cellmlDoc;
    }

    protected void produceReactionNetwork() {
        if (this.wholeCompartment == null) {
            this.wholeCompartment = new ReactionNetworkCompartment(this.rn, "document", "document", null, null);
            this.wholeCompartment.setSingleDocument();
        }
        try {
            this.processRnA();
            if (this.single) {
                this.rn.setSingleDocument();
            } else {
                this.processRnB();
            }
        }
        catch (BivesUnsupportedException e) {
            LOGGER.error((Exception)((Object)e), (Object[])new Object[]{"something bad happened"});
        }
        if (this.rn.getSubstances().size() < 1) {
            this.rn = null;
        }
    }

    protected void produceHierarchyGraph() {
        this.processHnA();
        if (this.single) {
            this.hn.setSingleDocument();
        } else {
            this.processHnB();
        }
        if (this.hn.getComponents().size() < 1) {
            this.hn = null;
        }
    }

    protected void processHnA() {
        LOGGER.info((Object[])new Object[]{"processHnA"});
        HashMap<CellMLComponent, HierarchyNetworkComponent> componentMapper = new HashMap<CellMLComponent, HierarchyNetworkComponent>();
        HashMap<CellMLVariable, HierarchyNetworkVariable> variableMapper = new HashMap<CellMLVariable, HierarchyNetworkVariable>();
        HashMap<String, CellMLComponent> components = this.cellmlDocA.getModel().getComponents();
        for (CellMLComponent component : components.values()) {
            HierarchyNetworkComponent nc = new HierarchyNetworkComponent(this.hn, component.getName(), null, component.getDocumentNode(), null);
            HashMap<String, CellMLVariable> vars = component.getVariables();
            for (CellMLVariable var : vars.values()) {
                HierarchyNetworkVariable hnVar = new HierarchyNetworkVariable(this.hn, var.getName(), null, var.getDocumentNode(), null, nc, null);
                nc.addVariable(hnVar);
                this.hn.setVariable((TreeNode)var.getDocumentNode(), hnVar);
                variableMapper.put(var, hnVar);
            }
            this.hn.setComponent((TreeNode)component.getDocumentNode(), nc);
            componentMapper.put(component, nc);
        }
        CellMLHierarchyNetwork enc = this.cellmlDocA.getModel().getHierarchy().getHierarchyNetwork("encapsulation", "");
        for (CellMLComponent component : components.values()) {
            CellMLHierarchyNode parent;
            CellMLHierarchyNode compNode = enc.getNode(component);
            if (compNode != null && (parent = compNode.getParent()) != null) {
                ((HierarchyNetworkComponent)componentMapper.get(component)).setParentA((HierarchyNetworkComponent)componentMapper.get(parent.getComponent()));
            }
            HashMap<String, CellMLVariable> vars = component.getVariables();
            for (CellMLVariable var : vars.values()) {
                List<CellMLVariable> cons;
                HierarchyNetworkVariable hnv = (HierarchyNetworkVariable)variableMapper.get(var);
                if (var.getPublicInterface() == -1) {
                    cons = var.getPublicInterfaceConnections();
                    for (CellMLVariable con : cons) {
                        hnv.addConnectionA((HierarchyNetworkVariable)variableMapper.get(con));
                    }
                }
                if (var.getPrivateInterface() != -1) continue;
                cons = var.getPrivateInterfaceConnections();
                for (CellMLVariable con : cons) {
                    hnv.addConnectionA((HierarchyNetworkVariable)variableMapper.get(con));
                }
            }
        }
    }

    protected void processHnB() {
        HashMap<String, CellMLVariable> vars;
        LOGGER.info((Object[])new Object[]{"processHnB"});
        HashMap<CellMLComponent, HierarchyNetworkComponent> componentMapper = new HashMap<CellMLComponent, HierarchyNetworkComponent>();
        HashMap<CellMLVariable, HierarchyNetworkVariable> variableMapper = new HashMap<CellMLVariable, HierarchyNetworkVariable>();
        HashMap<String, CellMLComponent> components = this.cellmlDocB.getModel().getComponents();
        for (CellMLComponent component : components.values()) {
            Connection con = this.conMgmt.getConnectionForNode((TreeNode)component.getDocumentNode());
            HierarchyNetworkComponent nc = null;
            if (con == null) {
                nc = new HierarchyNetworkComponent(this.hn, null, component.getName(), null, component.getDocumentNode());
            } else {
                nc = this.hn.getComponent(con.getPartnerOf((TreeNode)component.getDocumentNode()));
                nc.setDocB(component.getDocumentNode());
                nc.setLabelB(component.getName());
            }
            this.hn.setComponent((TreeNode)component.getDocumentNode(), nc);
            componentMapper.put(component, nc);
            vars = component.getVariables();
            for (CellMLVariable var : vars.values()) {
                DocumentNode varNode = var.getDocumentNode();
                HierarchyNetworkVariable hnVar = null;
                Connection c = this.conMgmt.getConnectionForNode((TreeNode)varNode);
                if (c == null || this.hn.getVariable(c.getPartnerOf((TreeNode)varNode)) == null) {
                    hnVar = new HierarchyNetworkVariable(this.hn, null, var.getName(), null, varNode, null, nc);
                } else {
                    hnVar = this.hn.getVariable(c.getPartnerOf((TreeNode)varNode));
                    hnVar.setDocB(varNode);
                    hnVar.setLabelB(var.getName());
                    hnVar.setComponentB(nc);
                }
                nc.addVariable(hnVar);
                this.hn.setVariable((TreeNode)varNode, hnVar);
                variableMapper.put(var, hnVar);
            }
            this.hn.setComponent((TreeNode)component.getDocumentNode(), nc);
            componentMapper.put(component, nc);
        }
        CellMLHierarchyNetwork enc = this.cellmlDocB.getModel().getHierarchy().getHierarchyNetwork("encapsulation", "");
        for (CellMLComponent component : components.values()) {
            CellMLHierarchyNode parent;
            CellMLHierarchyNode compNode = enc.getNode(component);
            if (compNode != null && (parent = compNode.getParent()) != null) {
                ((HierarchyNetworkComponent)componentMapper.get(component)).setParentB((HierarchyNetworkComponent)componentMapper.get(parent.getComponent()));
            }
            vars = component.getVariables();
            for (CellMLVariable var : vars.values()) {
                List<CellMLVariable> cons;
                HierarchyNetworkVariable hnv = (HierarchyNetworkVariable)variableMapper.get(var);
                if (var.getPublicInterface() == -1) {
                    cons = var.getPublicInterfaceConnections();
                    for (CellMLVariable con : cons) {
                        hnv.addConnectionB((HierarchyNetworkVariable)variableMapper.get(con));
                    }
                }
                if (var.getPrivateInterface() != -1) continue;
                cons = var.getPrivateInterfaceConnections();
                for (CellMLVariable con : cons) {
                    hnv.addConnectionB((HierarchyNetworkVariable)variableMapper.get(con));
                }
            }
        }
    }

    protected void processRnA() throws BivesUnsupportedException {
        LOGGER.info((Object[])new Object[]{"init compartment"});
        CellMLModel modelA = this.cellmlDocA.getModel();
        this.wholeCompartment.setDocA(modelA.getDocumentNode());
        this.rn.setCompartment((TreeNode)modelA.getDocumentNode(), this.wholeCompartment);
        LOGGER.info((Object[])new Object[]{"looping through components in A"});
        HashMap<String, CellMLComponent> components = modelA.getComponents();
        for (CellMLComponent component : components.values()) {
            List<CellMLReaction> reactions = component.getReactions();
            for (CellMLReaction reaction : reactions) {
                ReactionNetworkReaction rnReaction = new ReactionNetworkReaction(this.rn, reaction.getComponent().getName(), null, reaction.getDocumentNode(), null, this.wholeCompartment, null, reaction.isReversible());
                this.rn.setReaction((TreeNode)reaction.getDocumentNode(), rnReaction);
                List<CellMLReactionSubstance> substances = reaction.getSubstances();
                for (CellMLReactionSubstance substance : substances) {
                    boolean addSubstance = false;
                    CellMLVariable var = substance.getVariable();
                    CellMLVariable rootvar = var.getRootVariable();
                    List<CellMLReactionSubstance.Role> roles = substance.getRoles();
                    ReactionNetworkSubstance subst = this.rn.getSubstance((TreeNode)rootvar.getDocumentNode());
                    if (subst == null) {
                        subst = new ReactionNetworkSubstance(this.rn, rootvar.getName(), null, rootvar.getDocumentNode(), null, this.wholeCompartment, null);
                        addSubstance = true;
                    }
                    block11: for (CellMLReactionSubstance.Role role : roles) {
                        switch (role.role) {
                            case 1: {
                                rnReaction.addInputA(subst, null);
                                break;
                            }
                            case 2: {
                                rnReaction.addOutputA(subst, null);
                                break;
                            }
                            case 7: {
                                rnReaction.addModA(subst, null);
                                break;
                            }
                            case 3: 
                            case 5: {
                                rnReaction.addModA(subst, SBOTerm.createStimulator());
                                break;
                            }
                            case 4: {
                                rnReaction.addModA(subst, SBOTerm.createInhibitor());
                                break;
                            }
                            case 6: {
                                continue block11;
                            }
                        }
                        if (!addSubstance) continue;
                        this.rn.setSubstance((TreeNode)rootvar.getDocumentNode(), subst);
                        addSubstance = false;
                    }
                }
            }
        }
    }

    protected void processRnB() throws BivesUnsupportedException {
        CellMLModel modelB = this.cellmlDocB.getModel();
        this.wholeCompartment.setDocB(modelB.getDocumentNode());
        LOGGER.info((Object[])new Object[]{"looping through components in B"});
        HashMap<String, CellMLComponent> components = modelB.getComponents();
        for (CellMLComponent component : components.values()) {
            List<CellMLReaction> reactions = component.getReactions();
            for (CellMLReaction reaction : reactions) {
                DocumentNode rNode = reaction.getDocumentNode();
                Connection con = this.conMgmt.getConnectionForNode((TreeNode)rNode);
                ReactionNetworkReaction rnReaction = null;
                if (con == null) {
                    rnReaction = new ReactionNetworkReaction(this.rn, null, reaction.getComponent().getName(), null, reaction.getDocumentNode(), null, this.wholeCompartment, reaction.isReversible());
                    this.rn.setReaction((TreeNode)rNode, rnReaction);
                } else {
                    rnReaction = this.rn.getReaction(con.getPartnerOf((TreeNode)rNode));
                    this.rn.setReaction((TreeNode)rNode, rnReaction);
                    rnReaction.setDocB(rNode);
                    rnReaction.setCompartmentB(this.wholeCompartment);
                }
                List<CellMLReactionSubstance> substances = reaction.getSubstances();
                for (CellMLReactionSubstance substance : substances) {
                    CellMLVariable var = substance.getVariable();
                    CellMLVariable rootvar = var.getRootVariable();
                    List<CellMLReactionSubstance.Role> roles = substance.getRoles();
                    DocumentNode varRootDoc = rootvar.getDocumentNode();
                    ReactionNetworkSubstance subst = null;
                    Connection c = this.conMgmt.getConnectionForNode((TreeNode)varRootDoc);
                    if (c == null || this.rn.getSubstance(c.getPartnerOf((TreeNode)varRootDoc)) == null) {
                        subst = new ReactionNetworkSubstance(this.rn, null, rootvar.getName(), null, rootvar.getDocumentNode(), null, this.wholeCompartment);
                    } else {
                        subst = this.rn.getSubstance(c.getPartnerOf((TreeNode)varRootDoc));
                        subst.setDocB(varRootDoc);
                        subst.setLabelB(rootvar.getName());
                        subst.setCompartmentB(this.wholeCompartment);
                    }
                    block11: for (CellMLReactionSubstance.Role role : roles) {
                        switch (role.role) {
                            case 1: {
                                rnReaction.addInputB(subst, null);
                                break;
                            }
                            case 2: {
                                rnReaction.addOutputB(subst, null);
                                break;
                            }
                            case 7: {
                                rnReaction.addModB(subst, null);
                                break;
                            }
                            case 3: 
                            case 5: {
                                rnReaction.addModB(subst, SBOTerm.createStimulator());
                                break;
                            }
                            case 4: {
                                rnReaction.addModB(subst, SBOTerm.createInhibitor());
                                break;
                            }
                            case 6: {
                                continue block11;
                            }
                        }
                        this.rn.setSubstance((TreeNode)rootvar.getDocumentNode(), subst);
                    }
                }
            }
        }
    }
}

