/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.ds.rdf.RDF;
import de.unirostock.sems.bives.ds.rdf.RDFDescription;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Namespace;

public abstract class CellMLEntity {
    protected CellMLModel model;
    private List<RDF> rdfBlocks;
    private DocumentNode node;
    private List<RDFDescription> rdfDescriptions;

    public CellMLEntity(DocumentNode node, CellMLModel model) throws BivesLogicalException {
        this.model = model;
        this.node = node;
        this.rdfBlocks = new ArrayList<RDF>();
        this.rdfDescriptions = new ArrayList<RDFDescription>();
        if (model != null) {
            model.mapNode(node, this);
            String metaId = this.getMetaId();
            if (metaId != null) {
                model.registerMetaId(metaId, this);
            }
        }
        if (node != null) {
            List kids = node.getChildrenWithTag("RDF");
            for (TreeNode kid : kids) {
                if (kid.getType() != 1) continue;
                RDF rdf = new RDF((DocumentNode)kid);
                this.rdfBlocks.add(rdf);
                if (model == null) continue;
                model.registerRdfBlock(rdf);
            }
        }
    }

    public boolean flagMetaModifcations(MarkupElement me) {
        for (RDF rdf : this.rdfBlocks) {
            if (rdf.getNode().getModification() == 0) continue;
            me.flagInvisibleModification();
            return true;
        }
        return false;
    }

    public DocumentNode getDocumentNode() {
        return this.node;
    }

    public List<RDF> getRdfBlocks() {
        return this.rdfBlocks;
    }

    public CellMLModel getModel() {
        return this.model;
    }

    public void setModel(CellMLModel model) throws BivesLogicalException {
        model.mapNode(this.node, this);
        String metaId = this.getMetaId();
        if (metaId != null) {
            model.registerMetaId(metaId, this);
        }
    }

    public boolean setMetaId(String metaId) throws BivesLogicalException {
        if (metaId == null || metaId.length() < 1) {
            return false;
        }
        if (this.getMetaId() != null) {
            this.model.unregisterMetaId(this.getMetaId());
        }
        if (this.model.getEntityByMetaId(metaId) != null) {
            return false;
        }
        this.node.setAttribute(new Attribute("id", metaId, Namespace.getNamespace((String)"cmeta", (String)"http://www.cellml.org/metadata/1.0#")));
        this.model.registerMetaId(metaId, this);
        return true;
    }

    public String getMetaId() {
        if (this.node != null) {
            return this.node.getAttributeValue("id", "cellml.org/metadata");
        }
        return null;
    }

    public void associateRdfDescription(RDFDescription descr) {
        this.rdfDescriptions.add(descr);
    }

    public List<RDFDescription> getRdfDescriptions() {
        return this.rdfDescriptions;
    }
}

