/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.FileRetriever;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesImportException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.JDOMException;

public class CellMLImporter {
    private String href;
    private DocumentNode node;
    private CellMLModel model;

    public CellMLImporter(DocumentNode node, CellMLModel model) throws BivesCellMLParseException {
        this.model = model;
        this.node = node;
        this.href = node.getAttributeValue("href", "xlink");
        if (this.href == null) {
            throw new BivesCellMLParseException("href attribute in import is empty");
        }
    }

    public void parse() throws BivesImportException {
        try {
            this.pparse();
        }
        catch (Exception e) {
            throw new BivesImportException(this.href, e);
        }
    }

    private void pparse() throws IOException, XmlDocumentParseException, JDOMException, URISyntaxException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException {
        URI baseUri = this.model.getDocument().getBaseUri();
        LOGGER.info((Object[])new Object[]{"parsing import from ", this.href, " (base uri is: ", baseUri, ")"});
        File tmp = File.createTempFile("cellmlimporter", "cellml");
        tmp.deleteOnExit();
        URI fileUri = FileRetriever.getUri((String)this.href, (URI)baseUri);
        FileRetriever.getFile((URI)fileUri, (File)tmp);
        TreeDocument tdoc = new TreeDocument(XmlTools.readDocument((File)tmp), null, fileUri);
        CellMLDocument toImport = new CellMLDocument(tdoc);
        CellMLModel modelToImport = toImport.getModel();
        ArrayList<CellMLEntity> doubles = new ArrayList<CellMLEntity>();
        CellMLUnitDictionary units = modelToImport.getUnits();
        List kids = this.node.getChildrenWithTag("units");
        for (TreeNode kid : kids) {
            DocumentNode ukid = (DocumentNode)kid;
            String ref = ukid.getAttributeValue("units_ref");
            String name = ukid.getAttributeValue("name");
            if (ref == null || name == null || ref.length() < 1 || name.length() < 1) {
                throw new BivesCellMLParseException("unit import should define a name _and_ a units_ref! (name: " + name + ", units_ref: " + ref + ")");
            }
            CellMLUnit u = units.getUnit(ref, null);
            if (u == null) {
                throw new BivesDocumentConsistencyException("cannot import unit " + ref + " from " + this.href + " (base uri is: " + baseUri + ")");
            }
            if (u instanceof CellMLUserUnit) {
                CellMLUserUnit uu = (CellMLUserUnit)u;
                if (doubles.contains(uu)) {
                    throw new BivesCellMLParseException("double import of same unit. not supported yet.");
                }
                doubles.add(uu);
                uu.setName(name);
                this.model.importUnit(uu);
                LOGGER.info((Object[])new Object[]{"imported unit ", name, " from ", ref, "@", this.href});
                continue;
            }
            throw new BivesDocumentConsistencyException("unit import of base unit detected... (" + u.getName() + ")");
        }
        HashMap<String, CellMLComponent> tmpConMapper = new HashMap<String, CellMLComponent>();
        kids = this.node.getChildrenWithTag("component");
        for (TreeNode kid : kids) {
            DocumentNode ckid = (DocumentNode)kid;
            String ref = ckid.getAttributeValue("component_ref");
            String name = ckid.getAttributeValue("name");
            if (ref == null || name == null || ref.length() < 1 || name.length() < 1) {
                throw new BivesCellMLParseException("component import should define a name _and_ a component_ref! (name: " + name + ", component_ref: " + ref + ")");
            }
            CellMLComponent c = modelToImport.getComponent(ref);
            if (c == null) {
                throw new BivesDocumentConsistencyException("cannot import component " + ref + " from " + this.href + " (base uri is: " + baseUri + ")");
            }
            if (doubles.contains(c)) {
                throw new BivesCellMLParseException("double import of same component. not supported yet.");
            }
            doubles.add(c);
            c.setName(name);
            tmpConMapper.put(c.getName(), c);
            this.model.importComponent(c);
            LOGGER.info((Object[])new Object[]{"imported component ", name, " from ", ref, "@", this.href});
        }
        LOGGER.info((Object[])new Object[]{"checking connections"});
        for (CellMLComponent component : tmpConMapper.values()) {
            for (CellMLVariable var : component.getVariables().values()) {
                List<CellMLVariable> cons = var.getPublicInterfaceConnections();
                for (int i = cons.size() - 1; i >= 0; --i) {
                    if (tmpConMapper.get(cons.get(i).getComponent()) != null) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object[])new Object[]{"removing connection " + var.getComponent().getName() + " -- " + cons.get(i).getComponent().getName()});
                    }
                    cons.remove(i);
                }
            }
        }
    }
}

