/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class CellMLReactionSubstance
extends CellMLEntity {
    public static final int ROLE_REACTANT = 1;
    public static final int ROLE_PRODUCT = 2;
    public static final int ROLE_CATALYST = 3;
    public static final int ROLE_INHIBITOR = 4;
    public static final int ROLE_ACTIVATOR = 5;
    public static final int ROLE_RATE = 6;
    public static final int ROLE_MODIFIER = 7;
    public static final int DIRECTION_FORWARD = 0;
    public static final int DIRECTION_REVERSE = 1;
    public static final int DIRECTION_BOTH = 2;
    private CellMLVariable variable;
    private List<Role> roles;
    private CellMLComponent component;

    public CellMLReactionSubstance(CellMLModel model, CellMLComponent component, DocumentNode node) throws BivesDocumentConsistencyException, BivesCellMLParseException, BivesLogicalException {
        super(node, model);
        this.component = component;
        String var = node.getAttributeValue("variable");
        if (var == null) {
            throw new BivesCellMLParseException("variable ref in reaction of component " + component.getName() + " doesn't define a variable. (" + var + ", " + node.getXPath() + ")");
        }
        this.variable = component.getVariable(var);
        if (this.variable == null) {
            throw new BivesCellMLParseException("variable ref in reaction of component " + component.getName() + " doesn't define a valid variable. (" + var + ", " + node.getXPath() + ")");
        }
        this.roles = new ArrayList<Role>();
        List kids = node.getChildrenWithTag("role");
        for (TreeNode kid : kids) {
            this.roles.add(new Role(model, (DocumentNode)kid));
        }
    }

    public CellMLVariable getVariable() {
        return this.variable;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public static final String resolveDirection(int direction) throws BivesCellMLParseException {
        if (direction == 0) {
            return "forward";
        }
        if (direction == 1) {
            return "reverse";
        }
        if (direction == 2) {
            return "both";
        }
        throw new BivesCellMLParseException("unknown direction: " + direction);
    }

    public static final int resolveDirection(String direction) throws BivesCellMLParseException {
        if (direction.equals("forward")) {
            return 0;
        }
        if (direction.equals("reverse")) {
            return 1;
        }
        if (direction.equals("both")) {
            return 2;
        }
        throw new BivesCellMLParseException("unknown direction: " + direction);
    }

    public static final String resolveRole(int role) throws BivesCellMLParseException {
        if (role == 1) {
            return "reactant";
        }
        if (role == 2) {
            return "product";
        }
        if (role == 3) {
            return "catalyst";
        }
        if (role == 5) {
            return "activator";
        }
        if (role == 4) {
            return "inhibitor";
        }
        if (role == 7) {
            return "modifier";
        }
        if (role == 6) {
            return "rate";
        }
        throw new BivesCellMLParseException("unknown role: " + role);
    }

    public static final int resolveRole(String role) throws BivesCellMLParseException {
        if (role.equals("reactant")) {
            return 1;
        }
        if (role.equals("product")) {
            return 2;
        }
        if (role.equals("catalyst")) {
            return 3;
        }
        if (role.equals("activator")) {
            return 5;
        }
        if (role.equals("inhibitor")) {
            return 4;
        }
        if (role.equals("modifier")) {
            return 7;
        }
        if (role.equals("rate")) {
            return 6;
        }
        throw new BivesCellMLParseException("unknown role: " + role);
    }

    public class Role
    extends CellMLEntity {
        public int role;
        public int direction;
        public CellMLVariable delta_variable;
        public Double stoichiometry;
        public List<MathML> math;

        public Role(CellMLModel model, DocumentNode node) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException {
            super(node, model);
            this.direction = 0;
            this.delta_variable = null;
            this.stoichiometry = null;
            this.math = new ArrayList<MathML>();
            this.role = CellMLReactionSubstance.resolveRole(node.getAttributeValue("role"));
            if (node.getAttributeValue("direction") != null) {
                this.direction = CellMLReactionSubstance.resolveDirection(node.getAttributeValue("direction"));
            }
            if (node.getAttributeValue("delta_variable") != null) {
                this.delta_variable = CellMLReactionSubstance.this.component.getVariable(node.getAttributeValue("delta_variable"));
            }
            if (node.getAttributeValue("stoichiometry") != null) {
                try {
                    this.stoichiometry = Double.parseDouble(node.getAttributeValue("stoichiometry"));
                }
                catch (NumberFormatException ex) {
                    throw new BivesCellMLParseException("no proper stoichiometry: " + node.getAttributeValue("stoichiometry"));
                }
            }
            List kids = node.getChildrenWithTag("math");
            for (TreeNode kid : kids) {
                this.math.add(new MathML((DocumentNode)kid));
            }
        }
    }
}

