/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchy;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import java.util.List;

public class CellMLConnection {
    public static final ConnectedComponents parseConnection(CellMLModel model, CellMLHierarchy hierarchy, DocumentNode connection, HashMap<String, CellMLComponent> limit) throws BivesCellMLParseException, BivesLogicalException, BivesDocumentConsistencyException {
        List kids = connection.getChildrenWithTag("map_components");
        if (kids.size() != 1) {
            throw new BivesCellMLParseException("connection does not have exactly one map_components.");
        }
        DocumentNode child = (DocumentNode)kids.get(0);
        String v1 = child.getAttributeValue("component_1");
        String v2 = child.getAttributeValue("component_2");
        if (limit != null && (limit.get(v1) == null || limit.get(v2) == null)) {
            return null;
        }
        if (v1 == null || v2 == null || v1.equals(v2)) {
            throw new BivesCellMLParseException("map_components does not define two components.");
        }
        CellMLComponent component_1 = model.getComponent(v1);
        CellMLComponent component_2 = model.getComponent(v2);
        if (component_1 == null) {
            throw new BivesCellMLParseException("in map_components: " + v1 + " is not a valid component.");
        }
        if (component_2 == null) {
            throw new BivesCellMLParseException("in map_components: " + v2 + " is not a valid component.");
        }
        int relation = hierarchy.getEncapsulationRelationship(component_1, component_2);
        kids = connection.getChildrenWithTag("map_variables");
        block5: for (TreeNode kid : kids) {
            DocumentNode dkid = (DocumentNode)kid;
            v1 = dkid.getAttributeValue("variable_1");
            v2 = dkid.getAttributeValue("variable_2");
            if (v1 == null || v2 == null) {
                throw new BivesCellMLParseException("map_variables does not define two variables. (components: " + component_1.getName() + "," + component_2.getName() + ")");
            }
            CellMLVariable variable_1 = component_1.getVariable(v1);
            CellMLVariable variable_2 = component_2.getVariable(v2);
            if (variable_1 == null) {
                throw new BivesCellMLParseException("in map_variables: " + v1 + " is not a valid variable. (component: " + component_1.getName() + ")");
            }
            if (variable_2 == null) {
                throw new BivesCellMLParseException("in map_variables: " + v2 + " is not a valid variable. (component: " + component_2.getName() + ")");
            }
            switch (relation) {
                case 2: {
                    if (variable_1.getPrivateInterface() == -1 && variable_2.getPublicInterface() == 1 && variable_1.getPrivateInterfaceConnections().size() == 0) {
                        variable_1.addPrivateInterfaceConnection(variable_2);
                        variable_2.addPublicInterfaceConnection(variable_1);
                        continue block5;
                    }
                    if (variable_1.getPrivateInterface() == 1 && variable_2.getPublicInterface() == -1 && variable_2.getPublicInterfaceConnections().size() == 0) {
                        variable_1.addPrivateInterfaceConnection(variable_2);
                        variable_2.addPublicInterfaceConnection(variable_1);
                        continue block5;
                    }
                    throw new BivesLogicalException("cannot connect variables due to logical restrictions. (par) (components: " + component_1.getName() + "," + component_2.getName() + ", variables: " + variable_1.getName() + "," + variable_2.getName() + ")");
                }
                case 3: {
                    if (variable_2.getPrivateInterface() == -1 && variable_1.getPublicInterface() == 1 && variable_2.getPrivateInterfaceConnections().size() == 0) {
                        variable_2.addPrivateInterfaceConnection(variable_1);
                        variable_1.addPublicInterfaceConnection(variable_2);
                        continue block5;
                    }
                    if (variable_2.getPrivateInterface() == 1 && variable_1.getPublicInterface() == -1 && variable_1.getPublicInterfaceConnections().size() == 0) {
                        variable_2.addPrivateInterfaceConnection(variable_1);
                        variable_1.addPublicInterfaceConnection(variable_2);
                        continue block5;
                    }
                    throw new BivesLogicalException("cannot connect variables due to logical restrictions. (enc) (components: " + component_1.getName() + "," + component_2.getName() + ", variables: " + variable_1.getName() + "," + variable_2.getName() + ")");
                }
                case 1: {
                    if (variable_1.getPublicInterface() == -1 && variable_2.getPublicInterface() == 1 && variable_1.getPublicInterfaceConnections().size() == 0) {
                        variable_1.addPublicInterfaceConnection(variable_2);
                        variable_2.addPublicInterfaceConnection(variable_1);
                        continue block5;
                    }
                    if (variable_1.getPublicInterface() == 1 && variable_2.getPublicInterface() == -1 && variable_2.getPublicInterfaceConnections().size() == 0) {
                        variable_1.addPublicInterfaceConnection(variable_2);
                        variable_2.addPublicInterfaceConnection(variable_1);
                        continue block5;
                    }
                    throw new BivesLogicalException("cannot connect variables due to logical restrictions. (sib) (components: " + component_1.getName() + "," + component_2.getName() + ", variables: " + variable_1.getName() + "," + variable_2.getName() + ")");
                }
            }
            throw new BivesLogicalException("components are in hidden relationship and must not be connected. (components: " + component_1.getName() + "," + component_2.getName() + ")");
        }
        return new ConnectedComponents(component_1, component_2);
    }

    public static class ConnectedComponents {
        public CellMLComponent component_1;
        public CellMLComponent component_2;

        public ConnectedComponents(CellMLComponent component_1, CellMLComponent component_2) {
            this.component_1 = component_1;
            this.component_2 = component_2;
        }
    }
}

