/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNetwork;
import de.unirostock.sems.bives.cellml.parser.CellMLHierarchyNode;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class CellMLHierarchy {
    public static final int RELATION_HIDDEN = 0;
    public static final int RELATION_SIBLING = 1;
    public static final int RELATION_PARENT = 2;
    public static final int RELATION_ENCAPSULATED = 3;
    private HashMap<String, CellMLHierarchyNetwork> networks;
    private CellMLModel model;

    public CellMLHierarchy(CellMLModel model) {
        this.model = model;
        this.networks = new HashMap();
        this.networks.put("encapsulation:", new CellMLHierarchyNetwork("encapsulation", ""));
    }

    public CellMLHierarchyNetwork getEncapsulationHierarchyNetwork() {
        return this.networks.get("encapsulation:");
    }

    public CellMLHierarchyNetwork getHierarchyNetwork(String relationship, String name) {
        return this.networks.get(relationship + ":" + name);
    }

    public void parseGroup(DocumentNode node) throws BivesCellMLParseException, BivesLogicalException {
        ArrayList<CellMLHierarchyNetwork> curNetworks = new ArrayList<CellMLHierarchyNetwork>();
        List kids = node.getChildrenWithTag("relationship_ref");
        for (TreeNode kid : kids) {
            if (kid.getType() != 1) continue;
            DocumentNode dkid = (DocumentNode)kid;
            String rs = dkid.getAttributeValue("relationship");
            if (rs == null) {
                LOGGER.warn((Object[])new Object[]{"skipping relationship_ref definition: no valid relation ship defined."});
                continue;
            }
            String name = dkid.getAttributeValue("name");
            if (name == null) {
                name = "";
            }
            if (rs.equals("encapsulation") && name.length() > 0) {
                throw new BivesLogicalException("A name attribute must not be defined on a <relationship_ref> element with a relationship attribute value of \"encapsulation\"!");
            }
            CellMLHierarchyNetwork cur = this.networks.get(rs + ":" + name);
            if (cur == null) {
                cur = new CellMLHierarchyNetwork(rs, name);
                this.networks.put(rs + ":" + name, cur);
            }
            curNetworks.add(cur);
        }
        if (curNetworks.size() < 0) {
            LOGGER.warn((Object[])new Object[]{"skipping group definition: no recognizable relationships defined."});
            return;
        }
        Stack<CellMLComponent> parents = new Stack<CellMLComponent>();
        this.recursiveParseGroups(node, parents, curNetworks);
    }

    private void recursiveParseGroups(DocumentNode cur, Stack<CellMLComponent> parents, List<CellMLHierarchyNetwork> curNetworks) throws BivesCellMLParseException, BivesLogicalException {
        List kids = cur.getChildrenWithTag("component_ref");
        if (kids.size() == 0 && parents.size() == 0) {
            throw new BivesCellMLParseException("group doesn't contain component_refs");
        }
        for (TreeNode kid : kids) {
            if (kid.getType() != 1) continue;
            DocumentNode next = (DocumentNode)kid;
            String componentName = next.getAttributeValue("component");
            if (componentName == null) {
                throw new BivesCellMLParseException("no component defined in component_ref of grouping.");
            }
            CellMLComponent child = this.model.getComponent(componentName);
            if (child == null) {
                throw new BivesLogicalException("cannot find component with name: " + componentName + ")");
            }
            if (parents.size() > 0) {
                CellMLComponent parent = parents.peek();
                for (CellMLHierarchyNetwork network : curNetworks) {
                    network.connectHierarchically(parent, child);
                }
            }
            parents.add(child);
            this.recursiveParseGroups(next, parents, curNetworks);
        }
        if (parents.size() > 0) {
            parents.pop();
        }
    }

    public int getEncapsulationRelationship(CellMLComponent component_1, CellMLComponent component_2) throws BivesLogicalException {
        CellMLHierarchyNetwork network = this.networks.get("encapsulation:");
        if (network == null) {
            return 1;
        }
        CellMLHierarchyNode node_1 = network.getNode(component_1);
        CellMLHierarchyNode node_2 = network.getNode(component_2);
        if (node_1 == null) {
            if (node_2 == null || node_2.getParent() == null) {
                return 1;
            }
            return 0;
        }
        if (node_2 == null) {
            if (node_1.getParent() == null) {
                return 1;
            }
            return 0;
        }
        if (node_1.getParent() == node_2.getParent()) {
            return 1;
        }
        if (node_1 == node_2.getParent()) {
            return 2;
        }
        if (node_1.getParent() == node_2) {
            return 3;
        }
        return 0;
    }
}

