/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLReactionSubstance;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CellMLReaction
extends CellMLEntity
implements DiffReporter {
    private boolean reversible;
    private List<CellMLReactionSubstance> variable_refs;
    private CellMLComponent component;

    public CellMLReaction(CellMLModel model, CellMLComponent component, DocumentNode node) throws BivesDocumentConsistencyException, BivesCellMLParseException, BivesLogicalException {
        super(node, model);
        this.component = component;
        this.reversible = node.getAttributeValue("reversible") == null || !node.getAttributeValue("reversible").equals("no");
        this.variable_refs = new ArrayList<CellMLReactionSubstance>();
        List kids = node.getChildrenWithTag("variable_ref");
        for (TreeNode kid : kids) {
            this.variable_refs.add(new CellMLReactionSubstance(model, component, (DocumentNode)kid));
        }
    }

    public List<CellMLReactionSubstance> getSubstances() {
        return this.variable_refs;
    }

    public CellMLComponent getComponent() {
        return this.component;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        String name;
        CellMLReaction a = (CellMLReaction)docA;
        CellMLReaction b = (CellMLReaction)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        MarkupElement me = new MarkupElement("Reaction");
        BivesTools.genAttributeMarkupStats((DocumentNode)a.getDocumentNode(), (DocumentNode)b.getDocumentNode(), (MarkupElement)me);
        HashMap<String, Integer> inputs = new HashMap<String, Integer>();
        HashMap<String, Integer> outputs = new HashMap<String, Integer>();
        HashMap<String, Integer> modifiersStim = new HashMap<String, Integer>();
        HashMap<String, Integer> modifiersInh = new HashMap<String, Integer>();
        HashMap<String, Integer> modifiers = new HashMap<String, Integer>();
        List<CellMLReactionSubstance> varsA = a.getSubstances();
        List<CellMLReactionSubstance> varsB = b.getSubstances();
        for (CellMLReactionSubstance sub : varsA) {
            for (CellMLReactionSubstance.Role role : sub.getRoles()) {
                name = GeneralTools.prettyDouble((Double)role.stoichiometry, (Integer)1, (String)"", (String)" ");
                name = name + sub.getVariable().getName();
                switch (role.role) {
                    case 1: {
                        inputs.put(name, -1);
                        break;
                    }
                    case 2: {
                        outputs.put(name, -1);
                        break;
                    }
                    case 7: {
                        modifiers.put(name, -1);
                        break;
                    }
                    case 3: 
                    case 5: {
                        modifiersStim.put(name, -1);
                        break;
                    }
                    case 4: {
                        modifiersInh.put(name, -1);
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
        }
        for (CellMLReactionSubstance sub : varsB) {
            for (CellMLReactionSubstance.Role role : sub.getRoles()) {
                name = GeneralTools.prettyDouble((Double)role.stoichiometry, (Integer)1, (String)"", (String)" ");
                name = name + sub.getVariable().getName();
                switch (role.role) {
                    case 1: {
                        if (inputs.get(name) == null) {
                            inputs.put(name, 1);
                            break;
                        }
                        inputs.put(name, 0);
                        break;
                    }
                    case 2: {
                        if (outputs.get(name) == null) {
                            outputs.put(name, 1);
                            break;
                        }
                        outputs.put(name, 0);
                        break;
                    }
                    case 7: {
                        if (modifiers.get(name) == null) {
                            modifiers.put(name, 1);
                            break;
                        }
                        modifiers.put(name, 0);
                        break;
                    }
                    case 3: 
                    case 5: {
                        if (modifiersStim.get(name) == null) {
                            modifiersStim.put(name, 1);
                            break;
                        }
                        modifiersStim.put(name, 0);
                        break;
                    }
                    case 4: {
                        if (modifiersInh.get(name) == null) {
                            modifiersInh.put(name, 1);
                            break;
                        }
                        modifiersInh.put(name, 0);
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
        }
        StringBuilder ret = new StringBuilder();
        StringBuilder sub = this.expandSubstances(new StringBuilder(), "", inputs, " + ");
        if (sub.length() > 0) {
            ret.append((CharSequence)sub).append(" ").append(MarkupDocument.rightArrow()).append(" ");
        } else {
            ret.append("&Oslash; ").append(MarkupDocument.rightArrow()).append(" ");
        }
        sub = this.expandSubstances(new StringBuilder(), "", outputs, " + ");
        if (sub.length() > 0) {
            ret.append((CharSequence)sub);
        } else {
            ret.append("&Oslash;");
        }
        me.addValue(ret.toString());
        sub = this.expandSubstances(new StringBuilder(), " (unknown)", modifiers, "; ");
        sub = this.expandSubstances(sub, " (stimulator)", modifiersStim, "; ");
        sub = this.expandSubstances(sub, " (inhibitor)", modifiersInh, "; ");
        if (sub.length() > 0) {
            me.addValue("Modifiers: " + sub.toString());
        }
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    private StringBuilder expandSubstances(StringBuilder sub, String supp, HashMap<String, Integer> map, String collapse) {
        block4: for (String subst : map.keySet()) {
            if (sub.length() > 0) {
                sub.append(collapse);
            }
            switch (map.get(subst)) {
                case -1: {
                    sub.append(MarkupDocument.delete((String)(subst + supp)));
                    continue block4;
                }
                case 1: {
                    sub.append(MarkupDocument.insert((String)(subst + supp)));
                    continue block4;
                }
            }
            sub.append(subst).append(supp);
        }
        return sub;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement("Reactioon: " + MarkupDocument.insert((String)"reaction"));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement("Reactioon: " + MarkupDocument.delete((String)"reaction"));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }
}

