/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import java.util.HashMap;

public class CellMLUnitDictionary {
    public static final String[] STANDARD_UNITS = new String[]{"ampere", "farad", "katal", "lux", "pascal", "tesla", "becquerel", "gram", "kelvin", "meter", "radian", "volt", "candela", "gray", "kilogram", "metre", "second", "watt", "celsius", "henry", "liter", "mole", "siemens", "weber", "coulomb", "hertz", "litre", "newton", "sievert", "dimensionless", "joule", "lumen", "ohm", "steradian"};
    private CellMLModel model;
    private HashMap<String, CellMLUnit> standardUnits;
    private HashMap<String, CellMLUserUnit> modelUnits;
    private HashMap<CellMLComponent, HashMap<String, CellMLUserUnit>> componentUnits;

    public CellMLUnitDictionary(CellMLModel model) throws BivesLogicalException {
        this.model = model;
        this.standardUnits = new HashMap();
        this.modelUnits = new HashMap();
        this.componentUnits = new HashMap();
        this.init();
    }

    public CellMLUnit getUnit(String name, CellMLComponent c) {
        CellMLUnit u;
        HashMap<String, CellMLUserUnit> cu = this.componentUnits.get(c);
        if (cu != null && (u = cu.get(name)) != null) {
            return u;
        }
        u = this.modelUnits.get(name);
        if (u != null) {
            return u;
        }
        u = this.standardUnits.get(name);
        if (u != null) {
            return u;
        }
        return null;
    }

    public HashMap<String, CellMLUserUnit> getComponentUnits(CellMLComponent component) {
        return this.componentUnits.get(component);
    }

    public HashMap<String, CellMLUserUnit> getModelUnits() {
        return this.modelUnits;
    }

    public void addUnit(CellMLComponent c, CellMLUserUnit u, boolean imported) throws BivesDocumentConsistencyException {
        if (this.standardUnits.get(u.getName()) != null) {
            throw new BivesDocumentConsistencyException("not allowed to overwrite unit: " + u.getName());
        }
        if (c == null) {
            if (this.modelUnits.get(u.getName()) != null) {
                if (imported) {
                    this.checkDoubleImportOfUnit(this.modelUnits.get(u.getName()), u);
                } else {
                    throw new BivesDocumentConsistencyException("unit name is not unique: " + u.getName());
                }
            }
            this.modelUnits.put(u.getName(), u);
        } else {
            HashMap<String, CellMLUserUnit> cu = this.componentUnits.get(c);
            if (cu == null) {
                cu = new HashMap();
                this.componentUnits.put(c, cu);
            }
            if (cu.get(u.getName()) != null) {
                if (imported) {
                    this.checkDoubleImportOfUnit(cu.get(u.getName()), u);
                } else {
                    throw new BivesDocumentConsistencyException("unit name is not unique: " + u.getName());
                }
            }
            cu.put(u.getName(), u);
        }
    }

    private void checkDoubleImportOfUnit(CellMLUserUnit a, CellMLUserUnit b) throws BivesDocumentConsistencyException {
        if (!a.getModel().getDocument().getBaseUri().equals(b.getModel().getDocument().getBaseUri())) {
            throw new BivesDocumentConsistencyException("unit name is not unique: " + a.getName());
        }
    }

    private void init() throws BivesLogicalException {
        for (String c : STANDARD_UNITS) {
            this.standardUnits.put(c, CellMLUnit.createStandardUnit(c));
        }
    }
}

