/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.bives.markup.Markup;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;

public class CellMLUserUnit
extends CellMLUnit
implements DiffReporter,
Markup {
    private boolean base_units;
    private CellMLUnitDictionary dict;
    private CellMLComponent component;
    private List<BaseQuantity> baseQuantities;

    public CellMLUserUnit(CellMLModel model, CellMLUnitDictionary dict, CellMLComponent component, DocumentNode node) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException {
        super(model, node.getAttributeValue("name"), node);
        this.dict = dict;
        this.component = component;
        String base = node.getAttributeValue("name");
        if (base != null && base.equals("yes")) {
            this.base_units = true;
            return;
        }
        LOGGER.debug((Object[])new Object[]{"reading unit: ", this.getName()});
        this.baseQuantities = new ArrayList<BaseQuantity>();
        List kids = node.getChildrenWithTag("unit");
        for (TreeNode kid : kids) {
            try {
                this.baseQuantities.add(new BaseQuantity((DocumentNode)kid));
            }
            catch (NumberFormatException ex) {
                throw new BivesCellMLParseException("unknown number format: " + ex.getMessage());
            }
        }
    }

    public static final int scale(String s) throws BivesCellMLParseException {
        if (s.equals("yotta")) {
            return 24;
        }
        if (s.equals("zetta")) {
            return 21;
        }
        if (s.equals("exa")) {
            return 18;
        }
        if (s.equals("peta")) {
            return 15;
        }
        if (s.equals("tera")) {
            return 12;
        }
        if (s.equals("giga")) {
            return 9;
        }
        if (s.equals("mega")) {
            return 6;
        }
        if (s.equals("kilo")) {
            return 3;
        }
        if (s.equals("hecto")) {
            return 2;
        }
        if (s.equals("deka")) {
            return 1;
        }
        if (s.equals("deci")) {
            return -1;
        }
        if (s.equals("centi")) {
            return -2;
        }
        if (s.equals("milli")) {
            return -3;
        }
        if (s.equals("micro")) {
            return -6;
        }
        if (s.equals("nano")) {
            return -9;
        }
        if (s.equals("pico")) {
            return -12;
        }
        if (s.equals("femto")) {
            return -15;
        }
        if (s.equals("atto")) {
            return -18;
        }
        if (s.equals("zepto")) {
            return -21;
        }
        if (s.equals("yocto")) {
            return -24;
        }
        throw new BivesCellMLParseException("unknown base quatntity prefix: " + s);
    }

    public String markup() {
        if (this.base_units || this.baseQuantities == null) {
            return "base units";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.baseQuantities.size(); ++i) {
            ret.append(this.baseQuantities.get(i).markup());
            if (i >= this.baseQuantities.size() - 1) continue;
            ret.append(" ").append(MarkupDocument.multiply()).append(" ");
        }
        return ret.toString();
    }

    public void getDependencies(Map<CellMLUserUnit, List<CellMLEntity>> list) {
        if (this.base_units || this.baseQuantities == null) {
            return;
        }
        for (BaseQuantity bq : this.baseQuantities) {
            if (bq.unit.isStandardUnits()) continue;
            CellMLUserUnit unit = (CellMLUserUnit)bq.unit;
            if (list.get(unit) == null) {
                list.put(unit, new ArrayList());
            }
            list.get(unit).add(this);
        }
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        String newDef;
        CellMLUserUnit a = (CellMLUserUnit)docA;
        CellMLUserUnit b = (CellMLUserUnit)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getName();
        String idB = b.getName();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement("Units: " + idA) : new MarkupElement("Units: " + MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        String oldDef = a.markup();
        if (oldDef.equals(newDef = b.markup())) {
            me.addValue("defined by: " + oldDef);
        } else {
            me.addValue(MarkupDocument.delete((String)("old definition: " + oldDef)));
            me.addValue(MarkupDocument.insert((String)("new definition: " + newDef)));
        }
        BivesTools.genAttributeMarkupStats((DocumentNode)a.getDocumentNode(), (DocumentNode)b.getDocumentNode(), (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement("Units: " + MarkupDocument.insert((String)this.getName()));
        me.addValue(MarkupDocument.insert((String)("inserted: " + this.markup())));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement("Units: " + MarkupDocument.delete((String)this.getName()));
        me.addValue(MarkupDocument.delete((String)("deleted: " + this.markup())));
        return me;
    }

    public void renameUnit(String original, String newName) throws BivesLogicalException {
        boolean renamed = false;
        for (BaseQuantity bq : this.baseQuantities) {
            if (bq.unit.isStandardUnits() || !bq.unit.getName().equals(original)) continue;
            bq.renameUnit(original, newName);
            renamed = true;
        }
        if (!renamed) {
            throw new BivesLogicalException("cannot rename unit from " + original + " to " + newName + " (we don't know this unit)");
        }
    }

    public class BaseQuantity
    implements Markup {
        public CellMLUnit unit;
        public double multiplier;
        public double offset;
        public int prefix;
        public double exponent;
        public DocumentNode node;

        public BaseQuantity(CellMLUnit unit) {
            this.unit = unit;
            this.multiplier = 1.0;
            this.offset = 0.0;
            this.prefix = 0;
            this.exponent = 1.0;
        }

        public BaseQuantity(DocumentNode node) throws BivesCellMLParseException, BivesDocumentConsistencyException {
            String sc;
            LOGGER.debug((Object[])new Object[]{"reading base quantity from: ", node.getXPath(), " -> ", node.getAttributeValue("units")});
            this.node = node;
            this.unit = CellMLUserUnit.this.dict.getUnit(node.getAttributeValue("units"), CellMLUserUnit.this.component);
            if (this.unit == null) {
                throw new BivesDocumentConsistencyException("no such base unit: " + node.getAttributeValue("units"));
            }
            this.multiplier = 1.0;
            this.offset = 0.0;
            this.prefix = 0;
            this.exponent = 1.0;
            if (node.getAttributeValue("multiplier") != null) {
                this.multiplier = Double.parseDouble(node.getAttributeValue("multiplier"));
            }
            if ((sc = node.getAttributeValue("prefix")) != null) {
                try {
                    this.prefix = Integer.parseInt(sc);
                }
                catch (NumberFormatException e) {
                    this.prefix = CellMLUserUnit.scale(node.getAttributeValue("prefix"));
                }
            }
            if (node.getAttributeValue("offset") != null) {
                this.offset = Double.parseDouble(node.getAttributeValue("offset"));
            }
            if (node.getAttributeValue("exponent") != null) {
                this.exponent = Double.parseDouble(node.getAttributeValue("exponent"));
            }
        }

        public String markup() {
            StringBuilder ret = new StringBuilder().append("(").append(GeneralTools.prettyDouble((Double)this.multiplier, (Integer)1, (String)"", (String)MarkupDocument.multiply()));
            if (this.prefix != 0) {
                ret.append("10^").append(this.prefix).append(MarkupDocument.multiply());
            }
            ret.append("[").append(this.unit.toString()).append("]").append(GeneralTools.prettyDouble((Double)this.exponent, (Integer)1, (String)"^", (String)"")).append(GeneralTools.prettyDouble((Double)this.offset, (Integer)0, (String)"+", (String)""));
            return ret.append(")").toString();
        }

        public void renameUnit(String original, String newName) throws BivesLogicalException {
            Attribute attr = this.node.getAttribute("units");
            if (attr == null || !attr.getValue().equals(original) && !attr.getValue().equals(newName)) {
                throw new BivesLogicalException("cannot rename unit from " + original + " to " + newName + " (we don't know this unit, we are " + attr.getValue() + ")");
            }
            attr.setValue(newName);
        }
    }
}

