/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.api;

import de.unirostock.sems.bives.algorithm.DiffAnnotator;
import de.unirostock.sems.bives.api.Diff;
import de.unirostock.sems.bives.cellml.algorithm.CellMLConnector;
import de.unirostock.sems.bives.cellml.algorithm.CellMLDiffAnnotator;
import de.unirostock.sems.bives.cellml.algorithm.CellMLDiffInterpreter;
import de.unirostock.sems.bives.cellml.algorithm.CellMLGraphProducer;
import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorDot;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorGraphML;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorJson;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorSbgnJson;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesImportException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.bives.markup.Typesetting;
import de.unirostock.sems.bives.markup.TypesettingHTML;
import de.unirostock.sems.bives.markup.TypesettingMarkDown;
import de.unirostock.sems.bives.markup.TypesettingReStructuredText;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.jdom2.JDOMException;

public class CellMLDiff
extends Diff {
    private CellMLDocument doc1;
    private CellMLDocument doc2;
    protected CellMLGraphProducer graphProducer;
    protected CellMLDiffInterpreter interpreter;

    public CellMLDiff(File a, File b, DiffAnnotator diffAnnotator) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(a, b, diffAnnotator);
        this.doc1 = new CellMLDocument(this.treeA);
        this.doc2 = new CellMLDocument(this.treeB);
    }

    public CellMLDiff(String a, String b, DiffAnnotator diffAnnotator) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(a, b, diffAnnotator);
        this.doc1 = new CellMLDocument(this.treeA);
        this.doc2 = new CellMLDocument(this.treeB);
    }

    public CellMLDiff(TreeDocument a, TreeDocument b, DiffAnnotator diffAnnotator) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, IOException, URISyntaxException {
        super(a, b, diffAnnotator);
        this.doc1 = new CellMLDocument(this.treeA);
        this.doc2 = new CellMLDocument(this.treeB);
    }

    public CellMLDiff(CellMLDocument a, CellMLDocument b, DiffAnnotator diffAnnotator) {
        super(a.getTreeDocument(), b.getTreeDocument(), diffAnnotator);
        this.doc1 = a;
        this.doc2 = b;
    }

    public CellMLDiff(File a, File b) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(a, b, (DiffAnnotator)new CellMLDiffAnnotator());
        this.doc1 = new CellMLDocument(this.treeA);
        this.doc2 = new CellMLDocument(this.treeB);
    }

    public CellMLDiff(String a, String b) throws XmlDocumentParseException, IOException, JDOMException, BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, URISyntaxException {
        super(a, b, (DiffAnnotator)new CellMLDiffAnnotator());
        this.doc1 = new CellMLDocument(this.treeA);
        this.doc2 = new CellMLDocument(this.treeB);
    }

    public CellMLDiff(TreeDocument a, TreeDocument b) throws BivesCellMLParseException, BivesDocumentConsistencyException, BivesLogicalException, BivesImportException, IOException, URISyntaxException {
        super(a, b, (DiffAnnotator)new CellMLDiffAnnotator());
        this.doc1 = new CellMLDocument(this.treeA);
        this.doc2 = new CellMLDocument(this.treeB);
    }

    public CellMLDiff(CellMLDocument a, CellMLDocument b) {
        super(a.getTreeDocument(), b.getTreeDocument(), (DiffAnnotator)new CellMLDiffAnnotator());
        this.doc1 = a;
        this.doc2 = b;
    }

    public boolean mapTrees(boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) throws BivesConnectionException {
        CellMLConnector con = new CellMLConnector(this.doc1, this.doc2, allowDifferentIds, careAboutNames, stricterNames);
        con.findConnections();
        this.connections = con.getConnections();
        this.treeA.getRoot().resetModifications();
        this.treeA.getRoot().evaluate((ConnectionManager)this.connections);
        this.treeB.getRoot().resetModifications();
        this.treeB.getRoot().evaluate((ConnectionManager)this.connections);
        return true;
    }

    public String getReactionsGraphML() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorGraphML().translate(this.graphProducer.getReactionNetwork());
    }

    public Object getHierarchyGraph(GraphTranslator gt) throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return gt.translate(this.graphProducer.getHierarchy());
    }

    public String getHierarchyGraphML() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorGraphML().translate(this.graphProducer.getHierarchy());
    }

    public String getMarkDownReport() {
        if (this.interpreter == null) {
            this.interpreter = new CellMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return new TypesettingMarkDown().typeset(this.interpreter.getReport());
    }

    public String getReStructuredTextReport() {
        if (this.interpreter == null) {
            this.interpreter = new CellMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return new TypesettingReStructuredText().typeset(this.interpreter.getReport());
    }

    public String getHTMLReport() {
        if (this.interpreter == null) {
            this.interpreter = new CellMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return new TypesettingHTML().typeset(this.interpreter.getReport());
    }

    public Object getReactionsGraph(GraphTranslator gt) throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return gt.translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsDotGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorDot().translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorJson().translate(this.graphProducer.getReactionNetwork());
    }

    public String getHierarchyDotGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorDot().translate(this.graphProducer.getHierarchy());
    }

    public String getHierarchyJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorJson().translate(this.graphProducer.getHierarchy());
    }

    public String getReport(Typesetting ts) {
        if (this.interpreter == null) {
            this.interpreter = new CellMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return ts.typeset(this.interpreter.getReport());
    }

    public String getReactionsSbgnJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new CellMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorSbgnJson().translate(this.graphProducer.getReactionNetwork());
    }
}

