/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.cellml.parser;

import de.unirostock.sems.bives.cellml.exception.BivesCellMLParseException;
import de.unirostock.sems.bives.cellml.parser.CellMLEntity;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLReaction;
import de.unirostock.sems.bives.cellml.parser.CellMLUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.cellml.parser.CellMLUserUnit;
import de.unirostock.sems.bives.cellml.parser.CellMLVariable;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesLogicalException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CellMLComponent
extends CellMLEntity {
    private String name;
    private CellMLUnitDictionary units;
    private HashMap<String, CellMLVariable> variables;
    private List<CellMLReaction> reactions;
    private List<MathML> math;

    public CellMLComponent(CellMLModel model, DocumentNode node) throws BivesCellMLParseException, BivesLogicalException, BivesDocumentConsistencyException {
        super(node, model);
        TreeNode kid2;
        int i;
        this.units = model.getUnits();
        this.math = new ArrayList<MathML>();
        this.variables = new HashMap();
        this.reactions = new ArrayList<CellMLReaction>();
        this.name = node.getAttributeValue("name");
        if (this.name == null || this.name.length() < 1) {
            throw new BivesCellMLParseException("component doesn't have a name.");
        }
        List kids = node.getChildrenWithTag("units");
        ArrayList<String> problems = new ArrayList<String>();
        boolean nextRound = true;
        while (nextRound && kids.size() > 0) {
            nextRound = false;
            problems.clear();
            for (i = kids.size() - 1; i >= 0; --i) {
                kid2 = (TreeNode)kids.get(i);
                if (kid2.getType() != 1) continue;
                try {
                    this.units.addUnit(this, new CellMLUserUnit(model, this.units, this, (DocumentNode)kid2), false);
                }
                catch (BivesDocumentConsistencyException ex) {
                    problems.add(ex.getMessage());
                    continue;
                }
                kids.remove(i);
                nextRound = true;
            }
        }
        if (kids.size() != 0) {
            throw new BivesDocumentConsistencyException("inconsistencies for " + kids.size() + " units in component " + this.name + ", problems: " + problems);
        }
        nextRound = true;
        kids = node.getChildrenWithTag("variable");
        while (nextRound && kids.size() > 0) {
            nextRound = false;
            problems.clear();
            for (i = kids.size() - 1; i >= 0; --i) {
                kid2 = (TreeNode)kids.get(i);
                if (kid2.getType() != 1) continue;
                try {
                    CellMLVariable var = new CellMLVariable(model, this, (DocumentNode)kid2);
                    if (this.variables.get(var.getName()) != null) {
                        throw new BivesDocumentConsistencyException("variable name is not unique: " + var.getName());
                    }
                    this.variables.put(var.getName(), var);
                }
                catch (BivesDocumentConsistencyException ex) {
                    problems.add(ex.getMessage());
                    continue;
                }
                kids.remove(i);
                nextRound = true;
            }
        }
        if (kids.size() != 0) {
            throw new BivesDocumentConsistencyException("inconsistencies for " + kids.size() + " variables in component " + this.name + ", problems: " + problems);
        }
        kids = node.getChildrenWithTag("reaction");
        for (TreeNode kid2 : kids) {
            this.reactions.add(new CellMLReaction(model, this, (DocumentNode)kid2));
        }
        kids = node.getChildrenWithTag("math");
        for (TreeNode kid2 : kids) {
            this.math.add(new MathML((DocumentNode)kid2));
        }
    }

    public CellMLVariable getVariable(String name) throws BivesDocumentConsistencyException {
        CellMLVariable var = this.variables.get(name);
        if (var == null) {
            throw new BivesDocumentConsistencyException("unknown variable: " + name + " in component " + this.name);
        }
        return var;
    }

    public CellMLUnit getUnit(String name) {
        return this.units.getUnit(name, this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.getDocumentNode().setAttribute("name", name);
    }

    public void unconnect() {
        for (CellMLVariable var : this.variables.values()) {
            var.unconnect();
        }
    }

    public void getDependencies(Map<CellMLUserUnit, List<CellMLEntity>> list) {
        for (CellMLVariable var : this.variables.values()) {
            var.getDependencies(list);
        }
    }

    public List<CellMLReaction> getReactions() {
        return this.reactions;
    }

    public HashMap<String, CellMLVariable> getVariables() {
        return this.variables;
    }

    public List<MathML> getMath() {
        return this.math;
    }
}

