/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;

public abstract class Connector {
    protected boolean allowDifferentIds = true;
    protected boolean careAboutNames = true;
    protected boolean stricterNames = false;
    protected SimpleConnectionManager conMgmt;
    protected TreeDocument docA;
    protected TreeDocument docB;

    public Connector(TreeDocument docA, TreeDocument docB, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        this.docA = docA;
        this.docB = docB;
        this.conMgmt = new SimpleConnectionManager(docA, docB);
        this.careAboutNames = careAboutNames;
        this.stricterNames = stricterNames;
        this.allowDifferentIds = allowDifferentIds;
    }

    public Connector(TreeDocument docA, TreeDocument docB) {
        this.docA = docA;
        this.docB = docB;
        this.conMgmt = new SimpleConnectionManager(docA, docB);
        this.careAboutNames = true;
        this.stricterNames = false;
        this.allowDifferentIds = true;
    }

    public TreeDocument getDocA() {
        return this.docA;
    }

    public TreeDocument getDocB() {
        return this.docB;
    }

    protected abstract void init() throws BivesConnectionException;

    protected abstract void connect() throws BivesConnectionException;

    public final void findConnections() throws BivesConnectionException {
        this.init();
        this.connect();
        this.docA.getRoot().resetModifications();
        this.docA.getRoot().evaluate((ConnectionManager)this.conMgmt);
        this.docB.getRoot().resetModifications();
        this.docB.getRoot().evaluate((ConnectionManager)this.conMgmt);
    }

    public final SimpleConnectionManager getConnections() {
        return this.conMgmt;
    }

    protected boolean nodeAssign(TreeNode a, TreeNode b) throws BivesConnectionException {
        LOGGER.debug((Object[])new Object[]{"Matching old: ", a.getXPath(), " with new: ", b.getXPath()});
        if (this.conMgmt.getConnectionForNode(a) != null || this.conMgmt.getConnectionForNode(b) != null) {
            LOGGER.debug((Object[])new Object[]{"already assigned"});
            return true;
        }
        if (a.getType() != b.getType()) {
            return false;
        }
        if (a.getType() == 1 && ((DocumentNode)b).getTagName().equals(((DocumentNode)a).getTagName()) || a.getType() == 2) {
            this.conMgmt.addConnection(new NodeConnection(a, b));
            return true;
        }
        return false;
    }
}

