/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.api;

import de.unirostock.sems.bives.algorithm.DiffAnnotator;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.algorithm.general.PatchProducer;
import de.unirostock.sems.bives.ds.Patch;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.markup.Typesetting;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.File;
import java.io.IOException;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public abstract class Diff {
    public static final boolean ALLOW_DIFFERENT_IDS = true;
    public static final boolean CARE_ABOUT_NAMES = true;
    public static final boolean STRICTER_NAMES = false;
    protected TreeDocument treeA;
    protected TreeDocument treeB;
    protected SimpleConnectionManager connections;
    private PatchProducer patchProducer;
    private Patch patch;
    private String xmlPatch;
    private String xmlPatchInclAnnotations;
    private DiffAnnotator diffAnnotator;

    public Diff(File fileA, File fileB) throws XmlDocumentParseException, IOException, JDOMException {
        this.treeA = new TreeDocument(XmlTools.readDocument((File)fileA), fileA.toURI());
        this.treeB = new TreeDocument(XmlTools.readDocument((File)fileB), fileB.toURI());
    }

    public Diff(String docA, String docB) throws XmlDocumentParseException, IOException, JDOMException {
        this.treeA = new TreeDocument(XmlTools.readDocument((String)docA), null);
        this.treeB = new TreeDocument(XmlTools.readDocument((String)docB), null);
    }

    public Diff(TreeDocument treeA, TreeDocument treeB) {
        this.treeA = treeA;
        this.treeB = treeB;
    }

    public Diff(File fileA, File fileB, DiffAnnotator diffAnnotator) throws XmlDocumentParseException, IOException, JDOMException {
        this.treeA = new TreeDocument(XmlTools.readDocument((File)fileA), fileA.toURI());
        this.treeB = new TreeDocument(XmlTools.readDocument((File)fileB), fileB.toURI());
        this.diffAnnotator = diffAnnotator;
    }

    public Diff(String docA, String docB, DiffAnnotator diffAnnotator) throws XmlDocumentParseException, IOException, JDOMException {
        this.treeA = new TreeDocument(XmlTools.readDocument((String)docA), null);
        this.treeB = new TreeDocument(XmlTools.readDocument((String)docB), null);
        this.diffAnnotator = diffAnnotator;
    }

    public Diff(TreeDocument treeA, TreeDocument treeB, DiffAnnotator diffAnnotator) {
        this.treeA = treeA;
        this.treeB = treeB;
        this.diffAnnotator = diffAnnotator;
    }

    public String getDiff() {
        return this.getDiff(false);
    }

    public String getDiff(boolean inclAnnotations) {
        if (this.patch == null) {
            this.producePatch();
        }
        if (inclAnnotations && this.xmlPatchInclAnnotations == null) {
            this.xmlPatchInclAnnotations = XmlTools.prettyPrintDocument((Document)this.patch.getDocument(true));
        }
        if (!inclAnnotations && this.xmlPatch == null) {
            this.xmlPatch = XmlTools.prettyPrintDocument((Document)this.patch.getDocument(false));
        }
        return inclAnnotations ? this.xmlPatchInclAnnotations : this.xmlPatch;
    }

    public Patch getPatch() {
        if (this.patch == null) {
            this.producePatch();
        }
        return this.patch;
    }

    private void producePatch() {
        if (this.patchProducer == null) {
            this.patchProducer = new PatchProducer();
            this.patchProducer.init(this.connections, this.treeA, this.treeB, this.diffAnnotator);
            this.xmlPatch = null;
            this.xmlPatchInclAnnotations = this.patchProducer.produce(true);
            this.patch = this.patchProducer.getPatch();
        }
    }

    public abstract boolean mapTrees(boolean var1, boolean var2, boolean var3) throws Exception;

    public boolean mapTrees() throws Exception {
        return this.mapTrees(true, true, false);
    }

    @Deprecated
    public Object getCRNGraph(GraphTranslator gt) throws Exception {
        return this.getReactionsGraph(gt);
    }

    public abstract Object getReactionsGraph(GraphTranslator var1) throws Exception;

    public abstract Object getHierarchyGraph(GraphTranslator var1) throws Exception;

    @Deprecated
    public String getCRNGraphML() throws Exception {
        return this.getReactionsGraphML();
    }

    public abstract String getReactionsGraphML() throws Exception;

    public abstract String getHierarchyGraphML() throws Exception;

    @Deprecated
    public String getCRNDotGraph() throws Exception {
        return this.getReactionsDotGraph();
    }

    public abstract String getReactionsDotGraph() throws Exception;

    public abstract String getHierarchyDotGraph() throws Exception;

    @Deprecated
    public String getCRNJsonGraph() throws Exception {
        return this.getReactionsJsonGraph();
    }

    public abstract String getReactionsJsonGraph() throws Exception;

    public abstract String getHierarchyJsonGraph() throws Exception;

    public abstract String getReactionsSbgnJsonGraph() throws Exception;

    public abstract String getReport(Typesetting var1) throws Exception;

    public abstract String getHTMLReport() throws Exception;

    public abstract String getMarkDownReport() throws Exception;

    public abstract String getReStructuredTextReport() throws Exception;
}

