/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.graph;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.hn.HierarchyNetwork;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkComponent;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkVariable;
import de.unirostock.sems.bives.ds.rn.ReactionNetwork;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstanceRef;
import de.unirostock.sems.bives.markup.Typesetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class GraphTranslatorDot
extends GraphTranslator {
    private String dotStr = "";

    private static String getDotPostamble() {
        return "\tlabel=\"Diff Graph created by BiVeS\";" + Typesetting.NL_TXT + "}";
    }

    private static String getDotPreamble() {
        return "##Command to produce the pic: `neato -Tpng thisfile > thisfile.png`" + Typesetting.NL_TXT + Typesetting.NL_TXT + "digraph BiVeSexport {" + Typesetting.NL_TXT + "\tgraph [overlap=false];" + Typesetting.NL_TXT + "\tedge [len=1.3];" + Typesetting.NL_TXT + "\tnode [fontsize=11];" + Typesetting.NL_TXT;
    }

    private static String addNode(String id, String name, int version, boolean species) {
        String ret = id + "[label=\"" + name + "\"";
        switch (version) {
            case 1: {
                ret = ret + ",color=blue";
                break;
            }
            case 2: {
                ret = ret + ",color=yellow";
                break;
            }
            case -1: {
                ret = ret + ",color=red";
            }
        }
        ret = species ? ret + ",shape=circle" : ret + ",shape=diamond";
        ret = ret + "];" + Typesetting.NL_TXT;
        return "\t" + ret;
    }

    private static String addEdge(String from, String to, int version, String modification) {
        String ret = from + "->" + to;
        String sub = null;
        switch (version) {
            case 1: {
                sub = "color=blue";
                break;
            }
            case 2: {
                sub = "color=yellow";
                break;
            }
            case -1: {
                sub = "color=red";
            }
        }
        String sub2 = null;
        if (modification != null) {
            if (modification.equals("inhibitor")) {
                sub2 = "style=dashed,arrowType=tee";
            } else if (modification.equals("stimulator")) {
                sub2 = "style=dashed,arrowType=normal";
            } else if (modification.equals("unknown")) {
                sub2 = "style=dashed,arrowType=odot";
            }
        }
        if (sub != null && sub2 != null) {
            ret = ret + "[" + sub + "," + sub2 + "]";
        } else if (sub != null) {
            ret = ret + "[" + sub + "]";
        } else if (sub2 != null) {
            ret = ret + "[" + sub2 + "]";
        }
        ret = ret + ";" + Typesetting.NL_TXT;
        return "\t" + ret;
    }

    private String createCompartment(ReactionNetworkCompartment compartment, List<String> nodeList) {
        String ret = "\tsubgraph cluster" + compartment.getId() + " {" + Typesetting.NL_TXT;
        ret = ret + "\t\tlabel = \"" + compartment.getLabel() + "\";" + Typesetting.NL_TXT;
        ret = ret + "\t\tcolor=lightgrey;" + Typesetting.NL_TXT;
        for (String n : nodeList) {
            ret = ret + "\t" + n;
        }
        ret = ret + "\t}" + Typesetting.NL_TXT;
        return ret;
    }

    @Override
    public String translate(ReactionNetwork rn) {
        ReactionNetworkCompartment compartment;
        if (rn == null) {
            return null;
        }
        this.dotStr = GraphTranslatorDot.getDotPreamble();
        ArrayList<String> edges = new ArrayList<String>();
        HashMap compartments = new HashMap();
        for (ReactionNetworkCompartment c : rn.getCompartments()) {
            compartments.put(c, new ArrayList());
        }
        for (ReactionNetworkSubstance s : rn.getSubstances()) {
            compartment = s.getCompartment();
            if (compartment != null) {
                ((List)compartments.get(compartment)).add(GraphTranslatorDot.addNode(s.getId(), s.getLabel(), s.getModification(), true));
                continue;
            }
            this.dotStr = this.dotStr + GraphTranslatorDot.addNode(s.getId(), s.getLabel(), s.getModification(), true);
        }
        for (ReactionNetworkReaction r : rn.getReactions()) {
            compartment = r.getCompartment();
            if (compartment != null) {
                ((List)compartments.get(compartment)).add(GraphTranslatorDot.addNode(r.getId(), r.getLabel(), r.getModification(), false));
            } else {
                this.dotStr = this.dotStr + GraphTranslatorDot.addNode(r.getId(), r.getLabel(), r.getModification(), false);
            }
            for (ReactionNetworkSubstanceRef s : r.getInputs()) {
                edges.add(GraphTranslatorDot.addEdge(s.getSubstance().getId(), r.getId(), s.getModification(), "none"));
            }
            for (ReactionNetworkSubstanceRef s : r.getOutputs()) {
                edges.add(GraphTranslatorDot.addEdge(r.getId(), s.getSubstance().getId(), s.getModification(), "none"));
            }
            for (ReactionNetworkSubstanceRef s : r.getModifiers()) {
                edges.add(GraphTranslatorDot.addEdge(s.getSubstance().getId(), r.getId(), s.getModification(), s.getModTerm()));
            }
        }
        for (ReactionNetworkCompartment compartment2 : compartments.keySet()) {
            this.dotStr = this.dotStr + this.createCompartment(compartment2, (List)compartments.get(compartment2));
        }
        for (String e : edges) {
            this.dotStr = this.dotStr + e;
        }
        this.dotStr = this.dotStr + GraphTranslatorDot.getDotPostamble();
        return this.dotStr;
    }

    @Override
    public String translate(HierarchyNetwork hn) {
        if (hn == null) {
            return null;
        }
        this.dotStr = GraphTranslatorDot.getDotPreamble();
        Collection<HierarchyNetworkComponent> components = hn.getComponents();
        for (HierarchyNetworkComponent c : components) {
            this.dotStr = this.dotStr + "\tsubgraph cluster" + c.getId() + " {" + Typesetting.NL_TXT;
            this.dotStr = this.dotStr + "\t\tlabel = \"" + c.getLabel() + "\";" + Typesetting.NL_TXT;
            this.dotStr = this.dotStr + "\t\tcolor=lightgrey;" + Typesetting.NL_TXT;
            List<HierarchyNetworkVariable> vars = c.getVariables();
            for (HierarchyNetworkVariable var : vars) {
                this.dotStr = this.dotStr + "\t" + GraphTranslatorDot.addNode(var.getId(), var.getLabel(), var.getModification(), true);
            }
            this.dotStr = this.dotStr + "\t}" + Typesetting.NL_TXT;
        }
        for (HierarchyNetworkComponent comp : components) {
            HierarchyNetworkComponent parA = comp.getParentA();
            HierarchyNetworkComponent parB = comp.getParentB();
            if (parA != null || parB != null) {
                if (parA == parB) {
                    this.dotStr = this.dotStr + GraphTranslatorDot.addEdge("cluster" + parA.getId(), "cluster" + comp.getId(), 0, "none");
                } else {
                    if (parA != null) {
                        this.dotStr = this.dotStr + GraphTranslatorDot.addEdge("cluster" + parA.getId(), "cluster" + comp.getId(), -1, "none");
                    }
                    if (parB != null) {
                        this.dotStr = this.dotStr + GraphTranslatorDot.addEdge("cluster" + parA.getId(), "cluster" + comp.getId(), 1, "none");
                    }
                }
            }
            List<HierarchyNetworkVariable> vars = comp.getVariables();
            for (HierarchyNetworkVariable var : vars) {
                HashMap<HierarchyNetworkVariable, HierarchyNetworkVariable.VarConnection> cons = var.getConnections();
                for (HierarchyNetworkVariable con : cons.keySet()) {
                    LOGGER.info((Object[])new Object[]{"connecting var: ", var.getId(), " -> ", con.getId()});
                    this.dotStr = this.dotStr + GraphTranslatorDot.addEdge(con.getId(), var.getId(), cons.get(con).getModification(), "none");
                }
            }
        }
        this.dotStr = this.dotStr + GraphTranslatorDot.getDotPostamble();
        return this.dotStr;
    }
}

