/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.hn;

import de.unirostock.sems.bives.ds.hn.HierarchyNetwork;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkEntity;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkVariable;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.ArrayList;
import java.util.List;

public class HierarchyNetworkComponent
extends HierarchyNetworkEntity {
    private HierarchyNetworkComponent parentA;
    private HierarchyNetworkComponent parentB;
    private List<HierarchyNetworkComponent> kidsA = new ArrayList<HierarchyNetworkComponent>();
    private List<HierarchyNetworkComponent> kidsB = new ArrayList<HierarchyNetworkComponent>();
    private List<HierarchyNetworkVariable> vars = new ArrayList<HierarchyNetworkVariable>();

    public HierarchyNetworkComponent(HierarchyNetwork hn, String labelA, String labelB, DocumentNode docA, DocumentNode docB) {
        super("c" + hn.getNextComponentID(), labelA, labelB, docA, docB);
    }

    public List<HierarchyNetworkVariable> getVariables() {
        return this.vars;
    }

    public void addVariable(HierarchyNetworkVariable var) {
        if (this.vars.contains(var)) {
            return;
        }
        this.vars.add(var);
    }

    public void addChildA(HierarchyNetworkComponent component) {
        this.kidsA.add(component);
        component.parentA = this;
    }

    public void addChildB(HierarchyNetworkComponent component) {
        this.kidsB.add(component);
        component.parentB = this;
    }

    public void setParentA(HierarchyNetworkComponent component) {
        this.parentA = component;
    }

    public void setParentB(HierarchyNetworkComponent component) {
        this.parentB = component;
    }

    public HierarchyNetworkComponent getParentA() {
        return this.parentA;
    }

    public HierarchyNetworkComponent getParentB() {
        return this.parentB;
    }

    @Override
    public int getModification() {
        int i = super.getModification();
        if (i != 0) {
            return i;
        }
        if (this.parentA != this.parentB) {
            return 2;
        }
        return 0;
    }
}

