/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.api.RegularDiff;
import de.unirostock.sems.bives.ds.Patch;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.tools.DocumentTools;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import org.jdom2.Document;
import org.jdom2.Element;

public class Xhtml {
    private DocumentNode node = null;

    public DocumentNode getDocumentNode() {
        return this.node;
    }

    public void setXhtml(DocumentNode node) {
        this.node = node;
    }

    public String toString() {
        if (this.node == null) {
            return "";
        }
        return DocumentTools.printPrettySubDoc((DocumentNode)this.node);
    }

    public void reportModification(SimpleConnectionManager conMgmt, Xhtml a, Xhtml b, MarkupElement me) {
        String valB;
        if (a.node.getModification() == 0 && b.node.getModification() == 0) {
            return;
        }
        if (a.node.getModification() == 128 && b.node.getModification() == 128) {
            return;
        }
        String valA = a.toString();
        if (valA.equals(valB = b.toString())) {
            return;
        }
        try {
            TreeDocument tdA = new TreeDocument(XmlTools.readDocument((String)valA), null);
            TreeDocument tdB = new TreeDocument(XmlTools.readDocument((String)valB), null);
            RegularDiff differ = new RegularDiff(tdA, tdB);
            differ.mapTrees();
            Patch p = differ.getPatch();
            Element deletes = p.getDeletes();
            for (Object el : deletes.getChildren()) {
                if (el.getName().equals("node")) {
                    BivesTools.markDeleted((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                    continue;
                }
                if (el.getName().equals("attribute")) {
                    BivesTools.markUpdated((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                    continue;
                }
                BivesTools.markDeleted(((TextNode)tdA.getNodeByPath(el.getAttributeValue("oldPath"))).getParent());
            }
            Element inserts = p.getInserts();
            for (Object el : inserts.getChildren()) {
                if (el.getName().equals("node")) {
                    BivesTools.markInserted((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                    continue;
                }
                if (el.getName().equals("attribute")) {
                    BivesTools.markUpdated((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                    continue;
                }
                BivesTools.markInserted(((TextNode)tdB.getNodeByPath(el.getAttributeValue("newPath"))).getParent());
            }
            Element moves = p.getMoves();
            for (Element el : moves.getChildren()) {
                if (el.getName().equals("node")) {
                    BivesTools.markMoved((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                    BivesTools.markMoved((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                    continue;
                }
                BivesTools.markMoved(((TextNode)tdA.getNodeByPath(el.getAttributeValue("oldPath"))).getParent());
                BivesTools.markMoved(((TextNode)tdB.getNodeByPath(el.getAttributeValue("newPath"))).getParent());
            }
            Element updates = p.getUpdates();
            for (Element el : updates.getChildren()) {
                if (el.getName().equals("attribute")) {
                    BivesTools.markUpdated((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                    BivesTools.markUpdated((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                    continue;
                }
                BivesTools.markUpdated((TextNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                BivesTools.markUpdated((TextNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
            }
            me.addValue("modified notes: <pre>" + XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)tdA)) + "</pre> to <pre>" + XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)tdB)) + "</pre>");
            return;
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"was not able to rerun bives for the text nodes"});
            me.addValue(MarkupDocument.supplemental(MarkupDocument.delete("previous notes: <pre>" + valA + "</pre>") + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert("new notes: <pre>" + valB + "</pre>")));
            return;
        }
    }

    public void reportInsert(MarkupElement me) {
        me.addValue(MarkupDocument.supplemental(MarkupDocument.insert("inserted notes: <pre>" + this.toString() + "</pre>")));
    }

    public void reportDelete(MarkupElement me) {
        me.addValue(MarkupDocument.supplemental(MarkupDocument.delete("deleted notes: <pre>" + this.toString() + "</pre>")));
    }
}

