/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.graph;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.hn.HierarchyNetwork;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkComponent;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkVariable;
import de.unirostock.sems.bives.ds.rn.ReactionNetwork;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstanceRef;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class GraphTranslatorGraphML
extends GraphTranslator {
    private Element graphRoot;
    private Document graphDocument;
    private int graphid;

    @Override
    public String translate(HierarchyNetwork hn) {
        List<HierarchyNetworkVariable> vars;
        if (hn == null) {
            return null;
        }
        Element graphML = new Element("graphml");
        this.graphRoot = this.addGraphMLPreamble(graphML);
        this.graphDocument = new Document(graphML);
        this.graphid = 1;
        Collection<HierarchyNetworkComponent> components = hn.getComponents();
        for (HierarchyNetworkComponent comp : components) {
            LOGGER.info((Object[])new Object[]{"creating comp: ", comp.getId()});
            Element node = this.createGraphMLNode(this.graphRoot, comp.getId(), null, comp.getLabel(), comp.getModification() + "");
            Element subtree = this.createGraphRoot(true);
            node.addContent((Content)subtree);
            vars = comp.getVariables();
            for (HierarchyNetworkVariable var : vars) {
                LOGGER.info((Object[])new Object[]{"creating var: ", var.getId()});
                this.createGraphMLNode(subtree, var.getId(), null, var.getLabel(), var.getModification() + "");
            }
        }
        for (HierarchyNetworkComponent comp : components) {
            HierarchyNetworkComponent parA = comp.getParentA();
            HierarchyNetworkComponent parB = comp.getParentB();
            if (parA != null || parB != null) {
                if (parA == parB) {
                    this.createEdge(this.graphRoot, parA.getId(), comp.getId(), null, null);
                } else {
                    if (parA != null) {
                        this.createEdge(this.graphRoot, parA.getId(), comp.getId(), "-1", null);
                    }
                    if (parB != null) {
                        this.createEdge(this.graphRoot, parB.getId(), comp.getId(), "1", null);
                    }
                }
            }
            vars = comp.getVariables();
            for (HierarchyNetworkVariable var : vars) {
                HashMap<HierarchyNetworkVariable, HierarchyNetworkVariable.VarConnection> cons = var.getConnections();
                for (HierarchyNetworkVariable con : cons.keySet()) {
                    LOGGER.info((Object[])new Object[]{"connecting var: ", var.getId(), " -> ", con.getId()});
                    this.createEdge(this.graphRoot, con.getId(), var.getId(), "" + cons.get(con).getModification(), null);
                }
            }
        }
        return XmlTools.prettyPrintDocument((Document)this.graphDocument);
    }

    @Override
    public String translate(ReactionNetwork rn) {
        ReactionNetworkCompartment compartment;
        if (rn == null) {
            return null;
        }
        Element graphML = new Element("graphml");
        this.graphRoot = this.addGraphMLPreamble(graphML);
        this.graphDocument = new Document(graphML);
        HashMap<ReactionNetworkCompartment, Element> compartments = new HashMap<ReactionNetworkCompartment, Element>();
        this.graphid = 1;
        for (ReactionNetworkCompartment c : rn.getCompartments()) {
            Element node = this.createGraphMLNode(this.graphRoot, c.getId(), null, c.getLabel(), c.getModification() + "");
            Element compartment2 = this.createGraphRoot(true);
            node.addContent((Content)compartment2);
            compartments.put(c, compartment2);
        }
        for (ReactionNetworkSubstance s : rn.getSubstances()) {
            compartment = s.getCompartment();
            if (compartment != null) {
                this.createGraphMLNode((Element)compartments.get(compartment), s.getId(), "species", s.getLabel(), s.getModification() + "");
                continue;
            }
            this.createGraphMLNode(this.graphRoot, s.getId(), "species", s.getLabel(), s.getModification() + "");
        }
        for (ReactionNetworkReaction r : rn.getReactions()) {
            compartment = r.getCompartment();
            if (compartment != null) {
                this.createGraphMLNode((Element)compartments.get(compartment), r.getId(), "reaction", r.getLabel(), r.getModification() + "");
            } else {
                this.createGraphMLNode(this.graphRoot, r.getId(), "reaction", r.getLabel(), r.getModification() + "");
            }
            for (ReactionNetworkSubstanceRef s : r.getInputs()) {
                this.createEdge(this.graphRoot, s.getSubstance().getId(), r.getId(), s.getModification() + "", "none");
            }
            for (ReactionNetworkSubstanceRef s : r.getOutputs()) {
                this.createEdge(this.graphRoot, r.getId(), s.getSubstance().getId(), s.getModification() + "", "none");
            }
            for (ReactionNetworkSubstanceRef s : r.getModifiers()) {
                this.createEdge(this.graphRoot, s.getSubstance().getId(), r.getId(), s.getModification() + "", s.getModTerm());
            }
        }
        return XmlTools.prettyPrintDocument((Document)this.graphDocument);
    }

    public Document getGraphmlDocument() {
        return this.graphDocument;
    }

    private Element addGraphMLPreamble(Element graphML) {
        Element keyEl = new Element("key");
        keyEl.setAttribute("id", "name");
        keyEl.setAttribute("for", "node");
        keyEl.setAttribute("attr.name", "name");
        keyEl.setAttribute("attr.type", "string");
        graphML.addContent((Content)keyEl);
        keyEl = new Element("key");
        keyEl.setAttribute("id", "ns");
        keyEl.setAttribute("for", "node");
        keyEl.setAttribute("attr.name", "node set");
        keyEl.setAttribute("attr.type", "string");
        Element defEl = new Element("default");
        defEl.setText("species");
        keyEl.addContent((Content)defEl);
        graphML.addContent((Content)keyEl);
        keyEl = new Element("key");
        keyEl.setAttribute("id", "vers");
        keyEl.setAttribute("for", "all");
        keyEl.setAttribute("attr.name", "version");
        keyEl.setAttribute("attr.type", "int");
        defEl = new Element("default");
        defEl.setText("0");
        keyEl.addContent((Content)defEl);
        graphML.addContent((Content)keyEl);
        keyEl = new Element("key");
        keyEl.setAttribute("id", "mod");
        keyEl.setAttribute("for", "edge");
        keyEl.setAttribute("attr.name", "modifier");
        keyEl.setAttribute("attr.type", "string");
        defEl = new Element("default");
        defEl.setText("none");
        keyEl.addContent((Content)defEl);
        graphML.addContent((Content)keyEl);
        keyEl = this.createGraphRoot(true);
        graphML.addContent((Content)keyEl);
        return keyEl;
    }

    private Element createGraphRoot(boolean directed) {
        Element keyEl = new Element("graph");
        keyEl.setAttribute("id", "G" + this.graphid++);
        if (directed) {
            keyEl.setAttribute("edgedefault", "directed");
        } else {
            keyEl.setAttribute("edgedefault", "undirected");
        }
        return keyEl;
    }

    private Element createGraphMLNode(Element parent, String id, String ns, String name, String version) {
        LOGGER.debug((Object[])new Object[]{"create gml node: ", id, " mod: ", version});
        Element element = new Element("node");
        element.setAttribute("id", id);
        if (ns != null) {
            Element nsElement = new Element("data");
            nsElement.setAttribute("key", "ns");
            nsElement.setText(ns);
            element.addContent((Content)nsElement);
        }
        if (version != null) {
            Element srcElement = new Element("data");
            srcElement.setAttribute("key", "vers");
            srcElement.setText(version);
            element.addContent((Content)srcElement);
        }
        Element nameElement = new Element("data");
        nameElement.setAttribute("key", "name");
        nameElement.setText(name);
        element.addContent((Content)nameElement);
        if (parent != null) {
            parent.addContent((Content)element);
        }
        return element;
    }

    private void createEdge(Element parent, String source, String target, String version, String modifier) {
        LOGGER.debug((Object[])new Object[]{"create gml edge: ", source, " -> ", target, " mod: ", version});
        Element element = new Element("edge");
        element.setAttribute("source", source);
        element.setAttribute("target", target);
        if (modifier != null) {
            Element nsElement = new Element("data");
            nsElement.setAttribute("key", "mod");
            nsElement.setText(modifier);
            element.addContent((Content)nsElement);
        }
        if (version != null) {
            Element srcElement = new Element("data");
            srcElement.setAttribute("key", "vers");
            srcElement.setText(version);
            element.addContent((Content)srcElement);
        }
        parent.addContent((Content)element);
    }
}

