/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.hn;

import de.unirostock.sems.bives.ds.hn.HierarchyNetworkComponent;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkVariable;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class HierarchyNetwork {
    private int componentID = 0;
    private int variableID = 0;
    private HashMap<TreeNode, HierarchyNetworkComponent> hnC = new HashMap();
    private HashMap<TreeNode, HierarchyNetworkVariable> hnV = new HashMap();

    public Collection<HierarchyNetworkComponent> getComponents() {
        HashSet<HierarchyNetworkComponent> s = new HashSet<HierarchyNetworkComponent>();
        s.addAll(this.hnC.values());
        return s;
    }

    public Collection<HierarchyNetworkVariable> getVariables() {
        HashSet<HierarchyNetworkVariable> s = new HashSet<HierarchyNetworkVariable>();
        s.addAll(this.hnV.values());
        return s;
    }

    public int getNextComponentID() {
        return ++this.componentID;
    }

    public int getNextVariableID() {
        return ++this.variableID;
    }

    public void setComponent(TreeNode node, HierarchyNetworkComponent comp) {
        this.hnC.put(node, comp);
    }

    public void setVariable(TreeNode node, HierarchyNetworkVariable var) {
        this.hnV.put(node, var);
    }

    public HierarchyNetworkComponent getComponent(TreeNode node) {
        return this.hnC.get(node);
    }

    public HierarchyNetworkVariable getVariable(TreeNode node) {
        return this.hnV.get(node);
    }

    public void setSingleDocument() {
        for (HierarchyNetworkComponent c : this.hnC.values()) {
            c.setSingleDocument();
        }
        for (HierarchyNetworkVariable v : this.hnV.values()) {
            v.setSingleDocument();
        }
    }
}

