/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.ontology;

public class SBOTerm {
    public static final String MOD_STIMULATOR = "stimulator";
    public static final String MOD_UNKNOWN = "unknown";
    public static final String MOD_INHIBITOR = "inhibitor";
    public static final String MOD_NONE = "none";
    private String SBOTerm;

    public SBOTerm(String SBOTerm2) {
        this.SBOTerm = SBOTerm2;
    }

    public String getSBOTerm() {
        return this.SBOTerm;
    }

    public static SBOTerm createStimulator() {
        return new SBOTerm("SBO:0000459");
    }

    public static SBOTerm createInhibitor() {
        return new SBOTerm("SBO:0000020");
    }

    public static String resolveModifier(String mod) {
        try {
            switch (Integer.parseInt(mod.substring(4))) {
                case 13: 
                case 21: 
                case 459: 
                case 460: 
                case 461: 
                case 462: 
                case 533: 
                case 534: 
                case 535: {
                    return MOD_STIMULATOR;
                }
                case 20: 
                case 206: 
                case 207: 
                case 536: 
                case 537: 
                case 597: {
                    return MOD_INHIBITOR;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return MOD_UNKNOWN;
    }

    public String resolveModifier() {
        if (this.SBOTerm == null || !this.SBOTerm.startsWith("SBO:")) {
            return MOD_UNKNOWN;
        }
        return de.unirostock.sems.bives.ds.ontology.SBOTerm.resolveModifier(this.SBOTerm);
    }

    public static boolean sameModifier(SBOTerm modTermA, SBOTerm modTermB) {
        if (modTermA != null || modTermB != null) {
            if (modTermA == null || modTermB == null) {
                return false;
            }
            if (!modTermA.resolveModifier().equals(modTermB.resolveModifier())) {
                return false;
            }
        }
        return true;
    }
}

