/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.rn;

import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ReactionNetwork {
    private int reactionID = 0;
    private int substanceID = 0;
    private int compartmentID = 0;
    private HashMap<TreeNode, ReactionNetworkReaction> rnR = new HashMap();
    private HashMap<TreeNode, ReactionNetworkSubstance> rnS = new HashMap();
    private HashMap<TreeNode, ReactionNetworkCompartment> rnC = new HashMap();

    public Collection<ReactionNetworkSubstance> getSubstances() {
        HashSet<ReactionNetworkSubstance> s = new HashSet<ReactionNetworkSubstance>();
        s.addAll(this.rnS.values());
        return s;
    }

    public Collection<ReactionNetworkReaction> getReactions() {
        HashSet<ReactionNetworkReaction> s = new HashSet<ReactionNetworkReaction>();
        s.addAll(this.rnR.values());
        return s;
    }

    public Collection<ReactionNetworkCompartment> getCompartments() {
        HashSet<ReactionNetworkCompartment> s = new HashSet<ReactionNetworkCompartment>();
        s.addAll(this.rnC.values());
        return s;
    }

    public int getNextSubstanceID() {
        return ++this.substanceID;
    }

    public int getNextCompartmentID() {
        return ++this.compartmentID;
    }

    public int getNextReactionID() {
        return ++this.reactionID;
    }

    public void setReaction(TreeNode node, ReactionNetworkReaction react) {
        this.rnR.put(node, react);
    }

    public void setSubstance(TreeNode node, ReactionNetworkSubstance subst) {
        this.rnS.put(node, subst);
    }

    public void setCompartment(TreeNode node, ReactionNetworkCompartment compartment) {
        this.rnC.put(node, compartment);
    }

    public ReactionNetworkSubstance getSubstance(TreeNode node) {
        return this.rnS.get(node);
    }

    public ReactionNetworkReaction getReaction(TreeNode node) {
        return this.rnR.get(node);
    }

    public ReactionNetworkCompartment getCompartment(TreeNode node) {
        return this.rnC.get(node);
    }

    public void setSingleDocument() {
        for (ReactionNetworkReaction r : this.rnR.values()) {
            r.setSingleDocument();
        }
        for (ReactionNetworkSubstance s : this.rnS.values()) {
            s.setSingleDocument();
        }
        for (ReactionNetworkCompartment c : this.rnC.values()) {
            c.setSingleDocument();
        }
    }

    public static String modToString(int modification) {
        switch (modification) {
            case 1: {
                return "inserted";
            }
            case -1: {
                return "deleted";
            }
            case 2: {
                return "modified";
            }
        }
        return "unmodified";
    }
}

