/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm;

import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;

public class NodeConnection
implements Connection {
    private TreeNode a;
    private TreeNode b;
    private double weight;
    private List<Map.Entry<Property, RDFNode>> annotations;

    public NodeConnection(TreeNode a, TreeNode b) {
        this.a = a;
        this.b = b;
        this.weight = 1.0;
        this.annotations = new ArrayList<Map.Entry<Property, RDFNode>>();
    }

    public NodeConnection(NodeConnection toCopy) {
        this.a = toCopy.a;
        this.b = toCopy.b;
        this.weight = toCopy.weight;
        this.annotations = new ArrayList<Map.Entry<Property, RDFNode>>();
    }

    public NodeConnection(TreeNode a, TreeNode b, double weight) {
        this.a = a;
        this.b = b;
        this.weight = weight;
        this.annotations = new ArrayList<Map.Entry<Property, RDFNode>>();
    }

    public List<Map.Entry<Property, RDFNode>> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Property predicate, RDFNode object) {
        this.annotations.add(new AbstractMap.SimpleEntry<Property, RDFNode>(predicate, object));
    }

    public TreeNode getTreeA() {
        return this.a;
    }

    public TreeNode getTreeB() {
        return this.b;
    }

    public void setWeight(double u) {
        this.weight = u;
    }

    public void addWeight(double u) {
        this.weight += u;
    }

    public void scaleWeight(double u) {
        this.weight *= u;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        return "[" + this.a.getXPath() + " => " + this.b.getXPath() + " (" + this.weight + ")]";
    }

    public TreeNode getPartnerOf(TreeNode node) {
        if (this.a == node) {
            return this.b;
        }
        if (this.b == node) {
            return this.a;
        }
        return null;
    }
}

