/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm.general;

import de.unirostock.sems.bives.algorithm.DiffAnnotator;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.comodi.Change;
import de.unirostock.sems.comodi.ChangeFactory;
import de.unirostock.sems.comodi.branches.ComodiXmlEntity;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.jdom2.Element;

public class DefaultDiffAnnotator
extends DiffAnnotator {
    @Override
    public Change annotateDeletion(TreeNode node, Element diffNode, ChangeFactory changeFac) {
        Change change = changeFac.createDeletion(ChangeFactory.getSubjectId((Element)diffNode));
        if (diffNode.getAttribute("triggeredBy") != null) {
            change.wasTriggeredBy(diffNode.getAttributeValue("triggeredBy"));
        }
        if (diffNode.getName().equals("attribute")) {
            change.appliesTo(ComodiXmlEntity.getAttribute());
        } else if (diffNode.getName().equals("node")) {
            change.appliesTo(ComodiXmlEntity.getNode());
        } else if (diffNode.getName().equals("text")) {
            change.appliesTo(ComodiXmlEntity.getText());
        }
        return change;
    }

    @Override
    public Change annotateInsertion(TreeNode node, Element diffNode, ChangeFactory changeFac) {
        Change change = changeFac.createInsertion(ChangeFactory.getSubjectId((Element)diffNode));
        if (diffNode.getAttribute("triggeredBy") != null) {
            change.wasTriggeredBy(diffNode.getAttributeValue("triggeredBy"));
        }
        if (diffNode.getName().equals("attribute")) {
            change.appliesTo(ComodiXmlEntity.getAttribute());
        } else if (diffNode.getName().equals("node")) {
            change.appliesTo(ComodiXmlEntity.getNode());
        } else if (diffNode.getName().equals("text")) {
            change.appliesTo(ComodiXmlEntity.getText());
        }
        return change;
    }

    @Override
    public Change annotateMove(TreeNode nodeA, TreeNode nodeB, Element diffNode, ChangeFactory changeFac, boolean permutation) {
        Change change;
        Change change2 = change = permutation ? changeFac.createPermutationOfEntities(ChangeFactory.getSubjectId((Element)diffNode)) : changeFac.createMove(ChangeFactory.getSubjectId((Element)diffNode));
        if (diffNode.getAttribute("triggeredBy") != null) {
            change.wasTriggeredBy(diffNode.getAttributeValue("triggeredBy"));
        }
        if (diffNode.getName().equals("node")) {
            change.appliesTo(ComodiXmlEntity.getNode());
        } else if (diffNode.getName().equals("text")) {
            change.appliesTo(ComodiXmlEntity.getText());
        } else if (diffNode.getName().equals("attribute")) {
            change.appliesTo(ComodiXmlEntity.getAttribute());
        }
        return change;
    }

    @Override
    public Change annotateUpdateAttribute(TreeNode nodeA, TreeNode nodeB, String attributeName, Element diffNode, ChangeFactory changeFac) {
        Change change = changeFac.createUpdate(ChangeFactory.getSubjectId((Element)diffNode)).appliesTo(ComodiXmlEntity.getAttribute());
        if (diffNode.getAttribute("triggeredBy") != null) {
            change.wasTriggeredBy(diffNode.getAttributeValue("triggeredBy"));
        }
        return change;
    }

    @Override
    public Change annotateUpdateText(TextNode nodeA, TextNode nodeB, Element diffNode, ChangeFactory changeFac) {
        Change change = changeFac.createUpdate(ChangeFactory.getSubjectId((Element)diffNode)).appliesTo(ComodiXmlEntity.getText());
        if (diffNode.getAttribute("triggeredBy") != null) {
            change.wasTriggeredBy(diffNode.getAttributeValue("triggeredBy"));
        }
        return change;
    }

    @Override
    public void annotatePatch(String rootId, ChangeFactory changeFac) {
        Model model = changeFac.getAnnotaions();
        String baseUri = changeFac.getBaseUri().toString() + "#";
        Resource subject = model.createResource(baseUri + rootId);
        Resource bives = model.createResource(baseUri + "bives");
        model.add(model.createStatement(bives, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type"), (RDFNode)model.createResource("http://www.w3.org/ns/prov#SoftwareAgent")));
        model.add(model.createLiteralStatement(bives, model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), (Object)"BiVeS"));
        model.add(model.createLiteralStatement(bives, model.createProperty("http://purl.org/pav/", "version"), (Object)BivesTools.getBivesVersion()));
        Resource activity = model.createResource(baseUri + "createPatch");
        model.add(model.createStatement(activity, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type"), (RDFNode)model.createResource("http://www.w3.org/ns/prov#Activity")));
        model.add(model.createStatement(activity, model.createProperty("http://www.w3.org/ns/prov#wasAssociatedWith"), (RDFNode)bives));
        model.add(model.createStatement(activity, model.createProperty("http://www.w3.org/ns/prov#generated"), (RDFNode)subject));
        model.add(model.createStatement(subject, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type"), (RDFNode)model.createResource("http://www.w3.org/ns/prov#Entity")));
        model.add(model.createStatement(subject, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type"), (RDFNode)model.createResource("http://www.openarchives.org/ore/terms/Aggregation")));
        for (Change change : changeFac.getChanges()) {
            model.add(model.createStatement(subject, model.createProperty("http://www.openarchives.org/ore/terms/aggregates"), (RDFNode)change.getChangeAsResource()));
        }
    }
}

