/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm.general;

import de.unirostock.sems.bives.algorithm.Connector;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.Set;

public class IdConnector
extends Connector {
    private boolean requireSameLabel;

    public IdConnector(TreeDocument docA, TreeDocument docB, boolean requireSameLabel) {
        super(docA, docB, false, false, false);
        this.requireSameLabel = requireSameLabel;
    }

    @Override
    protected void connect() throws BivesConnectionException {
        if (!this.docA.uniqueIds() || !this.docB.uniqueIds()) {
            return;
        }
        Set ids = this.docA.getOccurringIds();
        for (String id : ids) {
            DocumentNode nB = this.docB.getNodeById(id);
            if (nB == null) continue;
            DocumentNode nA = this.docA.getNodeById(id);
            if (!this.requireSameLabel) {
                this.conMgmt.addConnection(new NodeConnection((TreeNode)nA, (TreeNode)nB));
                continue;
            }
            if (nB.getType() != 1 || nA.getType() != 1 || !nB.getTagName().equals(nA.getTagName())) continue;
            this.conMgmt.addConnection(new NodeConnection((TreeNode)nA, (TreeNode)nB));
        }
    }

    @Override
    protected void init() throws BivesConnectionException {
    }
}

