/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm.general;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.algorithm.Connector;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.algorithm.general.IdConnector;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.NodeDistance;
import de.unirostock.sems.xmlutils.ds.NodeDistanceComparator;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.ds.TreeNodeComparatorBySubtreeSize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;

public class XyDiffConnector
extends Connector {
    public static double MAX_ATTR_DIST = 0.8;
    private final int MIN_CANDIDATEPARENT_LEVEL = 6;
    private Connector preprocessor;

    public XyDiffConnector(TreeDocument docA, TreeDocument docB, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(docA, docB, allowDifferentIds, careAboutNames, stricterNames);
    }

    public XyDiffConnector(TreeDocument docA, TreeDocument docB) {
        super(docA, docB, true, true, false);
    }

    public XyDiffConnector(Connector preprocessor, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(preprocessor.getDocA(), preprocessor.getDocB(), allowDifferentIds, careAboutNames, stricterNames);
        this.preprocessor = preprocessor;
    }

    public XyDiffConnector(Connector preprocessor) {
        super(preprocessor.getDocA(), preprocessor.getDocB(), true, true, false);
        this.preprocessor = preprocessor;
    }

    @Override
    protected void init() throws BivesConnectionException {
        if (this.preprocessor == null) {
            IdConnector id = new IdConnector(this.docA, this.docB, true);
            id.findConnections();
            this.conMgmt = id.getConnections();
        } else {
            this.preprocessor.findConnections();
            this.conMgmt = this.preprocessor.getConnections();
        }
    }

    @Override
    protected void connect() throws BivesConnectionException {
        LOGGER.info((Object[])new Object[]{"starting XY Diff"});
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug((Object[])new Object[]{"pre xy diff run"});
            LOGGER.debug((Object[])new Object[]{this.conMgmt.toString()});
        }
        if (this.conMgmt.getConnectionOfNodes((TreeNode)this.docA.getRoot(), (TreeNode)this.docB.getRoot()) == null) {
            this.conMgmt.addConnection(new NodeConnection((TreeNode)this.docA.getRoot(), (TreeNode)this.docB.getRoot()));
        }
        LOGGER.info((Object[])new Object[]{"doing full bottom up"});
        this.fullBottomUp((TreeNode)this.docB.getRoot());
        if (debug) {
            LOGGER.debug((Object[])new Object[]{this.conMgmt.toString()});
        }
        LOGGER.info((Object[])new Object[]{"doing top down"});
        this.topdownMatch((TreeNode)this.docA.getRoot(), (TreeNode)this.docB.getRoot());
        if (debug) {
            LOGGER.debug((Object[])new Object[]{this.conMgmt.toString()});
        }
        LOGGER.info((Object[])new Object[]{"doing optimizations"});
        this.optimize(this.docA.getRoot());
        if (debug) {
            LOGGER.debug((Object[])new Object[]{"post xy diff run"});
            LOGGER.debug((Object[])new Object[]{this.conMgmt.toString()});
            LOGGER.debug((Object[])new Object[]{"unmatched in A:"});
            List<TreeNode> unmatched = this.conMgmt.getUnmatched((TreeNode)this.docA.getRoot(), new ArrayList<TreeNode>());
            for (TreeNode u : unmatched) {
                LOGGER.debug((Object[])new Object[]{u.getXPath()});
            }
            LOGGER.debug((Object[])new Object[]{"unmatched in B:"});
            unmatched = this.conMgmt.getUnmatched((TreeNode)this.docB.getRoot(), new ArrayList<TreeNode>());
            for (TreeNode u : unmatched) {
                LOGGER.debug((Object[])new Object[]{u.getXPath()});
            }
        }
        LOGGER.info((Object[])new Object[]{"finished XY Diff"});
    }

    private TreeNode fullBottomUp(TreeNode nodeB) throws BivesConnectionException {
        TreeNode match;
        HashMap<DocumentNode, Double> weightByCandidate = new HashMap<DocumentNode, Double>();
        if (nodeB.getType() == 1) {
            List children = ((DocumentNode)nodeB).getChildren();
            for (TreeNode child : children) {
                DocumentNode v0childParent;
                TreeNode childMatch = this.fullBottomUp(child);
                if (childMatch == null || (v0childParent = this.conMgmt.getConnectionForNode(childMatch).getTreeA().getParent()) == null) continue;
                if (weightByCandidate.get(v0childParent) == null) {
                    weightByCandidate.put(v0childParent, child.getWeight());
                    continue;
                }
                weightByCandidate.put(v0childParent, (Double)weightByCandidate.get(v0childParent) + child.getWeight());
            }
        }
        if (this.conMgmt.getConnectionForNode(nodeB) != null) {
            match = this.conMgmt.getConnectionForNode(nodeB).getTreeA();
            LOGGER.debug((Object[])new Object[]{"v1 node ", nodeB.getXPath(), " already has a match, returning ", match.getXPath()});
            return match;
        }
        if (weightByCandidate.size() < 1) {
            match = null;
            if (this.conMgmt.getConnectionForNode(nodeB) != null) {
                match = this.conMgmt.getConnectionForNode(nodeB).getTreeA();
                LOGGER.debug((Object[])new Object[]{"v1 node ", nodeB.getXPath(), " has no matched children, returning ", match.getXPath()});
            } else {
                LOGGER.debug((Object[])new Object[]{"v1 node ", nodeB.getXPath(), " has no matched children, returning ", match});
            }
            return match;
        }
        LOGGER.debug((Object[])new Object[]{"v0 parents of v0 nodes matching v1 children of v1 node ", nodeB.getXPath(), " are:"});
        double max = -1.0;
        TreeNode bestMatch = null;
        for (TreeNode node : weightByCandidate.keySet()) {
            LOGGER.debug((Object[])new Object[]{"v0 node ", node.getXPath(), " with total weight among children of ", weightByCandidate.get(node)});
            if (!((Double)weightByCandidate.get(node) > max)) continue;
            bestMatch = node;
            max = (Double)weightByCandidate.get(node);
        }
        if (bestMatch == null) {
            return null;
        }
        LOGGER.debug((Object[])new Object[]{"best parent is v0 node ", bestMatch.getXPath(), " with total weight among children of ", max});
        if (this.nodeAssign(bestMatch, nodeB)) {
            return bestMatch;
        }
        return null;
    }

    private void topdownMatch(TreeNode rootA, TreeNode rootB) throws BivesConnectionException {
        PriorityQueue<TreeNode> toMatch = new PriorityQueue<TreeNode>(100, (Comparator<TreeNode>)new TreeNodeComparatorBySubtreeSize(true));
        toMatch.add(rootB);
        while (toMatch.size() > 0) {
            TreeNode nodeID = (TreeNode)toMatch.poll();
            String v1hash = nodeID.getSubTreeHash();
            LOGGER.debug((Object[])new Object[]{"Trying new node ", nodeID.getXPath(), ", hash=", v1hash});
            CandidateResult matchInA = null;
            TreeNode nodeInB = nodeID;
            String nodeInBHash = nodeID.getSubTreeHash();
            if (this.conMgmt.getConnectionForNode(nodeID) != null) {
                LOGGER.debug((Object[])new Object[]{"skipping Full Subtree check because subtree node is already assigned."});
            } else if (nodeID == rootB) {
                this.conMgmt.addConnection(new NodeConnection(rootA, rootB));
            } else {
                matchInA = this.getBestCandidate(nodeInB, nodeInBHash);
            }
            if (matchInA != null) {
                if (matchInA.level > 1) {
                    CandidateResult betterB = this.getBestCandidateOw(matchInA.candidate, matchInA.candidate.getSubTreeHash(), matchInA.level);
                    if (betterB != null) {
                        if (betterB.level > 1) {
                            LOGGER.debug((Object[])new Object[]{"    level>1 so forcing parents matching in the hierarchie"});
                            this.forceParentsAssign(matchInA.candidate, betterB.candidate, betterB.level);
                        }
                        this.recursiveAssign(matchInA.candidate, betterB.candidate);
                        toMatch.add(nodeInB);
                        continue;
                    }
                    LOGGER.debug((Object[])new Object[]{"    level>1 so forcing parents matching in the hierarchie"});
                    this.forceParentsAssign(matchInA.candidate, nodeInB, matchInA.level);
                }
                this.recursiveAssign(matchInA.candidate, nodeInB);
                continue;
            }
            LOGGER.debug((Object[])new Object[]{"Subtree rooted at ", nodeID.getXPath(), " not fully matched, programming children"});
            if (nodeID.getType() != 1) continue;
            List children = ((DocumentNode)nodeID).getChildren();
            for (TreeNode child : children) {
                toMatch.add(child);
            }
        }
    }

    private void optimize(DocumentNode nodeA) throws BivesConnectionException {
        Connection c = this.conMgmt.getConnectionForNode((TreeNode)nodeA);
        if (c != null) {
            TreeNode tnb = c.getPartnerOf((TreeNode)nodeA);
            if (tnb.getType() != 1) {
                return;
            }
            DocumentNode nodeB = (DocumentNode)tnb;
            HashMap kidsMapA = new HashMap();
            List kidsA = nodeA.getChildren();
            for (TreeNode node : kidsA) {
                if (this.conMgmt.getConnectionForNode(node) != null) continue;
                String tag = node.getTagName();
                if (kidsMapA.get(tag) == null) {
                    kidsMapA.put(tag, new ArrayList());
                }
                ((ArrayList)kidsMapA.get(tag)).add(node);
            }
            HashMap kidsMapB = new HashMap();
            List kidsB = nodeB.getChildren();
            for (TreeNode node : kidsB) {
                if (this.conMgmt.getConnectionForNode(node) != null) continue;
                String tag = node.getTagName();
                if (kidsMapB.get(tag) == null) {
                    kidsMapB.put(tag, new ArrayList());
                }
                ((List)kidsMapB.get(tag)).add(node);
            }
            for (String tag : kidsMapA.keySet()) {
                this.optimize((List)kidsMapA.get(tag), (List)kidsMapB.get(tag));
            }
        }
        List children = nodeA.getChildren();
        for (TreeNode child : children) {
            if (child.getType() != 1) continue;
            this.optimize((DocumentNode)child);
        }
    }

    private void optimize(List<TreeNode> nodesA, List<TreeNode> nodesB) throws BivesConnectionException {
        boolean textNodes;
        if (nodesA == null || nodesB == null || nodesA.size() == 0 || nodesB.size() == 0) {
            return;
        }
        boolean bl = textNodes = nodesA.get(0).getType() == 2;
        if (nodesA.size() == 1 && nodesB.size() == 1) {
            TextNode tnodeB;
            TextNode tnodeA;
            TreeNode nodeA = nodesA.get(0);
            TreeNode nodeB = nodesB.get(0);
            if (!textNodes) {
                DocumentNode dnodeA = (DocumentNode)nodeA;
                DocumentNode dnodeB = (DocumentNode)nodeB;
                if (dnodeA.getAttributeDistance(dnodeB, this.allowDifferentIds, this.careAboutNames, this.stricterNames) < MAX_ATTR_DIST) {
                    LOGGER.debug((Object[])new Object[]{"connect unambiguos nodes during optimization: ", nodeA.getXPath(), " --> ", nodeB.getXPath()});
                    this.conMgmt.addConnection(new NodeConnection(nodeA, nodeB));
                }
            } else if (textNodes && (tnodeA = (TextNode)nodeA).getTextDistance(tnodeB = (TextNode)nodeB) < 0.5) {
                LOGGER.debug((Object[])new Object[]{"connect unambiguos nodes during optimization: ", nodeA.getXPath(), " --> ", nodeB.getXPath()});
                this.conMgmt.addConnection(new NodeConnection(nodeA, nodeB));
            }
            return;
        }
        ArrayList<NodeDistance> distances = new ArrayList<NodeDistance>();
        for (TreeNode nodeA : nodesA) {
            for (TreeNode nodeB : nodesB) {
                if (nodeA.getType() == 2) {
                    TextNode tnodeA = (TextNode)nodeA;
                    TextNode tnodeB = (TextNode)nodeB;
                    distances.add(new NodeDistance(nodeA, nodeB, tnodeA.getTextDistance(tnodeB)));
                    continue;
                }
                distances.add(new NodeDistance(nodeA, nodeB, ((DocumentNode)nodeA).getAttributeDistance((DocumentNode)nodeB, this.allowDifferentIds, this.careAboutNames, this.stricterNames)));
            }
        }
        Collections.sort(distances, new NodeDistanceComparator(false));
        for (NodeDistance comp : distances) {
            if (textNodes && comp.distance > 0.5 || !textNodes && comp.distance > MAX_ATTR_DIST) break;
            TreeNode na = comp.nodeA;
            TreeNode nb = comp.nodeB;
            if (this.conMgmt.getConnectionForNode(na) != null || this.conMgmt.getConnectionForNode(nb) != null) continue;
            this.conMgmt.addConnection(new NodeConnection(na, nb));
        }
    }

    private CandidateResult getBestCandidate(TreeNode v1nodeID, String selfkey) throws BivesConnectionException {
        TreeNode v1nodeRelative = v1nodeID;
        double relativeWeight = v1nodeID.getWeight() / this.docB.getRoot().getWeight();
        int maxLevelPath = 6 + (int)(5.0 * Math.log(this.docB.getNumNodes()) * relativeWeight);
        LOGGER.debug((Object[])new Object[]{"maxLevel=", maxLevelPath});
        for (int candidateRelativeLevel = 1; candidateRelativeLevel <= maxLevelPath; ++candidateRelativeLevel) {
            LOGGER.debug((Object[])new Object[]{"    pass parentLevel=", candidateRelativeLevel});
            v1nodeRelative = v1nodeRelative.getParent();
            if (v1nodeRelative == null) {
                LOGGER.debug((Object[])new Object[]{"but node doesn't not have ancesters up to this level\n"});
                return null;
            }
            LOGGER.debug((Object[])new Object[]{"    pass v1nodeRelative=", v1nodeRelative.getXPath()});
            if (this.conMgmt.getConnectionForNode(v1nodeRelative) == null) {
                LOGGER.debug((Object[])new Object[]{"but v1 relative at this level has no match"});
                continue;
            }
            List theList = this.docA.getNodesByHash(selfkey);
            if (theList == null || theList.size() < 1) {
                LOGGER.debug((Object[])new Object[]{"  no candidates for hash"});
                return null;
            }
            LOGGER.debug((Object[])new Object[]{"  num candidates: ", theList.size()});
            if (theList.size() > 50) {
                LOGGER.warn((Object[])new Object[]{"it seems that there are too many candidates (", theList.size(), ") for a match of ", v1nodeID.getXPath(), " (", selfkey, ")"});
            }
            String xPath = v1nodeID.getXPath();
            ArrayList<CandidateResult> candidates = new ArrayList<CandidateResult>();
            for (TreeNode candidate : theList) {
                LOGGER.debug((Object[])new Object[]{"    trying " + candidate.getXPath()});
                if (this.conMgmt.getConnectionForNode(candidate) != null) continue;
                LOGGER.debug((Object[])new Object[]{"(", candidate.getXPath(), ")"});
                TreeNode candidateRelative = candidate;
                for (int j = 0; j < candidateRelativeLevel && (candidateRelative = candidateRelative.getParent()) != null; ++j) {
                }
                if (candidateRelative == null || this.conMgmt.getConnectionOfNodes(candidateRelative, v1nodeRelative) == null) continue;
                LOGGER.debug((Object[])new Object[]{" adding candidate because some relatives ( level= ", candidateRelativeLevel, " ) are matching"});
                if (LOGGER.isDebugEnabled()) {
                    DocumentNode tmp = (DocumentNode)v1nodeID;
                    System.out.println(" ------------------------------------------ ");
                    System.out.println(" ------------------------------------------ ");
                    System.out.println(" ------------------------------------------ ");
                    System.out.println(tmp.getParent().getId());
                    DocumentNode match = (DocumentNode)candidate;
                    System.out.println(match.getParent().getId());
                    System.out.println(candidateRelativeLevel);
                }
                candidates.add(new CandidateResult(candidate, candidateRelativeLevel, xPath));
            }
            if (candidates.size() <= 0) continue;
            Collections.sort(candidates);
            CandidateResult candidate = (CandidateResult)candidates.get(0);
            LOGGER.debug((Object[])new Object[]{" took candidate: ", candidate.candidate.getXPath()});
            LOGGER.setLevel((int)8);
            return candidate;
        }
        return null;
    }

    private CandidateResult getBestCandidateOw(TreeNode v0nodeID, String selfkey, int maxLevel) throws BivesConnectionException {
        LOGGER.debug((Object[])new Object[]{">>> starting other way around!!"});
        int candidateRelativeLevel = 1;
        TreeNode v0nodeRelative = v0nodeID;
        double relativeWeight = v0nodeID.getWeight() / this.docA.getRoot().getWeight();
        int maxLevelPath = 6 + (int)(5.0 * Math.log(this.docA.getNumNodes()) * relativeWeight);
        if (maxLevelPath > maxLevel) {
            maxLevelPath = maxLevel;
        }
        LOGGER.debug((Object[])new Object[]{"maxLevel=", maxLevelPath});
        while (candidateRelativeLevel <= maxLevelPath) {
            LOGGER.debug((Object[])new Object[]{"    pass parentLevel=", candidateRelativeLevel});
            v0nodeRelative = v0nodeRelative.getParent();
            if (v0nodeRelative == null) {
                LOGGER.debug((Object[])new Object[]{"but node doesn't not have ancesters up to this level\n"});
                return null;
            }
            LOGGER.debug((Object[])new Object[]{"    pass v0nodeRelative=", v0nodeRelative.getXPath()});
            if (this.conMgmt.getConnectionForNode(v0nodeRelative) == null) {
                LOGGER.debug((Object[])new Object[]{"but v0 relative at this level has no match"});
            } else {
                List theList = this.docB.getNodesByHash(selfkey);
                if (theList == null || theList.size() < 1) {
                    LOGGER.debug((Object[])new Object[]{"  no candidates for hash"});
                    return null;
                }
                LOGGER.debug((Object[])new Object[]{"  num candidates: ", theList.size()});
                if (theList.size() > 50) {
                    LOGGER.warn((Object[])new Object[]{"it seems that there are too many candidates (", theList.size(), ") for a match of ", v0nodeID.getXPath(), " (", selfkey, ")"});
                }
                String xPath = v0nodeID.getXPath();
                ArrayList<CandidateResult> candidates = new ArrayList<CandidateResult>();
                for (TreeNode candidate : theList) {
                    LOGGER.debug((Object[])new Object[]{"    trying " + candidate.getXPath()});
                    if (this.conMgmt.getConnectionForNode(candidate) != null) continue;
                    LOGGER.debug((Object[])new Object[]{"(", candidate.getXPath(), ")"});
                    TreeNode candidateRelative = candidate;
                    for (int j = 0; j < candidateRelativeLevel && (candidateRelative = candidateRelative.getParent()) != null; ++j) {
                    }
                    if (candidateRelative == null || this.conMgmt.getConnectionOfNodes(v0nodeRelative, candidateRelative) == null) continue;
                    LOGGER.debug((Object[])new Object[]{" adding candidate because some relatives ( level= ", candidateRelativeLevel, " ) are matching"});
                    if (LOGGER.isDebugEnabled()) {
                        DocumentNode tmp = (DocumentNode)v0nodeID;
                        System.out.println(" ------------------------------------------ ");
                        System.out.println(" ------------------------------------------ ");
                        System.out.println(" ------------------------------------------ ");
                        System.out.println(tmp.getParent().getId());
                        DocumentNode match = (DocumentNode)candidate;
                        System.out.println(match.getParent().getId());
                        System.out.println(candidateRelativeLevel);
                    }
                    candidates.add(new CandidateResult(candidate, candidateRelativeLevel, xPath));
                }
                if (candidates.size() > 0) {
                    Collections.sort(candidates);
                    CandidateResult candidate = (CandidateResult)candidates.get(0);
                    LOGGER.debug((Object[])new Object[]{" took candidate: ", candidate.candidate.getXPath()});
                    LOGGER.setLevel((int)8);
                    return candidate;
                }
            }
            ++candidateRelativeLevel;
        }
        return null;
    }

    private void recursiveAssign(TreeNode v0nodeID, TreeNode v1nodeID) throws BivesConnectionException {
        if (v0nodeID == null || v1nodeID == null) {
            LOGGER.debug((Object[])new Object[]{"recursiveAssign::bad arguments (", v0nodeID, ", ", v0nodeID, ")"});
            return;
        }
        this.nodeAssign(v0nodeID, v1nodeID);
        if (v0nodeID.getType() == 1 && v1nodeID.getType() == 1) {
            List v0children = ((DocumentNode)v0nodeID).getChildren();
            List v1children = ((DocumentNode)v1nodeID).getChildren();
            if (v0children.size() != v1children.size()) {
                LOGGER.debug((Object[])new Object[]{"recursiveAssign::diff # children: ", v0children.size(), " -vs- ", v1children.size()});
            }
            for (int i = 0; i < v0children.size(); ++i) {
                this.recursiveAssign((TreeNode)v0children.get(i), (TreeNode)v1children.get(i));
            }
        }
    }

    private void forceParentsAssign(TreeNode v0nodeID, TreeNode v1nodeID, int level) throws BivesConnectionException {
        if (v0nodeID == null || v1nodeID == null) {
            LOGGER.debug((Object[])new Object[]{"forceParentsAssign::bad arguments"});
            return;
        }
        TreeNode v0ascendant = v0nodeID;
        TreeNode v1ascendant = v1nodeID;
        for (int i = 0; i < level - 1; ++i) {
            v0ascendant = v0ascendant.getParent();
            v1ascendant = v1ascendant.getParent();
            if (v0ascendant == null || v1ascendant == null) {
                return;
            }
            if (this.conMgmt.getConnectionForNode(v0ascendant) != null) {
                LOGGER.debug((Object[])new Object[]{"forceParentsAssign stopped at level ", i, " because v0 ascendant is already assigned"});
                return;
            }
            if (this.conMgmt.getConnectionForNode(v1ascendant) != null) {
                LOGGER.debug((Object[])new Object[]{"forceParentsAssign stopped at level ", i, " because v1 ascendant is already assigned"});
                return;
            }
            if (this.nodeAssign(v0ascendant, v1ascendant)) continue;
            LOGGER.debug((Object[])new Object[]{"forceParentsAssign stopped because relatives (", v0ascendant.getXPath(), ", ", v1ascendant.getXPath(), ") do not have the same label"});
            return;
        }
    }

    class CandidateResult
    implements Comparable<CandidateResult> {
        TreeNode candidate;
        int level;
        int dist;
        String xPath;

        public CandidateResult(TreeNode candidate, int level, String xPath) {
            this.candidate = candidate;
            this.level = level;
            this.dist = -1;
            this.xPath = xPath;
        }

        public int getDist() {
            if (this.dist == -1) {
                this.dist = GeneralTools.computeLevenshteinDistance((String)this.xPath, (String)this.candidate.getXPath());
            }
            return this.dist;
        }

        @Override
        public int compareTo(CandidateResult cr) {
            if (this.level < cr.level) {
                return -1;
            }
            if (this.level > cr.level) {
                return 1;
            }
            if (this.getDist() < cr.getDist()) {
                return -1;
            }
            if (this.getDist() > cr.getDist()) {
                return 1;
            }
            return 0;
        }
    }
}

