/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.graph;

import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.hn.HierarchyNetwork;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkComponent;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkVariable;
import de.unirostock.sems.bives.ds.rn.ReactionNetwork;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstanceRef;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GraphTranslatorJson
extends GraphTranslator {
    private JSONArray nodes;
    private JSONArray edges;
    private JSONObject graph;

    private void addNode(String parent, String id, String name, int version, boolean species) {
        JSONObject node = new JSONObject();
        String classes = species ? "species" : "reaction";
        switch (version) {
            case 1: {
                classes = classes + " bives-inserted";
                break;
            }
            case 2: {
                classes = classes + " bives-modified";
                break;
            }
            case -1: {
                classes = classes + " bives-deleted";
            }
        }
        node.put((Object)"classes", (Object)classes);
        JSONObject data = new JSONObject();
        data.put((Object)"id", (Object)id);
        data.put((Object)"name", (Object)name);
        if (parent != null) {
            data.put((Object)"parent", (Object)parent);
        }
        node.put((Object)"data", (Object)data);
        this.nodes.add((Object)node);
    }

    private void addEdge(String from, String to, int version, String modification) {
        JSONObject edge = new JSONObject();
        String classes = "";
        classes = modification != null ? (modification.equals("inhibitor") ? "bives-inhibitor" : (modification.equals("stimulator") ? "bives-stimulator" : (modification.equals("unknown") ? "bives-unkwnmod" : "bives-ioedge"))) : "bives-ioedge";
        switch (version) {
            case 1: {
                classes = classes + " bives-inserted";
                break;
            }
            case 2: {
                classes = classes + " bives-modified";
                break;
            }
            case -1: {
                classes = classes + " bives-deleted";
            }
        }
        edge.put((Object)"classes", (Object)classes);
        JSONObject data = new JSONObject();
        data.put((Object)"source", (Object)from);
        data.put((Object)"target", (Object)to);
        edge.put((Object)"data", (Object)data);
        this.edges.add((Object)edge);
    }

    private void createCompartment(String id, String name, int version) {
        JSONObject node = new JSONObject();
        String classes = "compartment";
        switch (version) {
            case 1: {
                classes = classes + " bives-inserted";
                break;
            }
            case 2: {
                classes = classes + " bives-modified";
                break;
            }
            case -1: {
                classes = classes + " bives-deleted";
            }
        }
        node.put((Object)"classes", (Object)classes);
        JSONObject data = new JSONObject();
        data.put((Object)"id", (Object)id);
        data.put((Object)"name", (Object)name);
        node.put((Object)"data", (Object)data);
        this.nodes.add((Object)node);
    }

    private void startNewGraph() {
        this.graph = new JSONObject();
        this.nodes = new JSONArray();
        this.edges = new JSONArray();
        JSONObject elements = new JSONObject();
        elements.put((Object)"nodes", (Object)this.nodes);
        elements.put((Object)"edges", (Object)this.edges);
        this.graph.put((Object)"elements", (Object)elements);
    }

    public JSONObject getJsonGraph() {
        return this.graph;
    }

    @Override
    public String translate(ReactionNetwork rn) {
        ReactionNetworkCompartment compartment;
        if (rn == null) {
            return null;
        }
        this.startNewGraph();
        for (ReactionNetworkCompartment c : rn.getCompartments()) {
            this.createCompartment(c.getId(), c.getLabel(), c.getModification());
        }
        for (ReactionNetworkSubstance s : rn.getSubstances()) {
            compartment = s.getCompartment();
            if (compartment != null) {
                this.addNode(compartment.getId(), s.getId(), s.getLabel(), s.getModification(), true);
                continue;
            }
            this.addNode(null, s.getId(), s.getLabel(), s.getModification(), true);
        }
        for (ReactionNetworkReaction r : rn.getReactions()) {
            compartment = r.getCompartment();
            if (compartment != null) {
                this.addNode(compartment.getId(), r.getId(), r.getLabel(), r.getModification(), false);
            } else {
                this.addNode(null, r.getId(), r.getLabel(), r.getModification(), false);
            }
            for (ReactionNetworkSubstanceRef s : r.getInputs()) {
                this.addEdge(s.getSubstance().getId(), r.getId(), s.getModification(), "none");
            }
            for (ReactionNetworkSubstanceRef s : r.getOutputs()) {
                this.addEdge(r.getId(), s.getSubstance().getId(), s.getModification(), "none");
            }
            for (ReactionNetworkSubstanceRef s : r.getModifiers()) {
                this.addEdge(s.getSubstance().getId(), r.getId(), s.getModification(), s.getModTerm());
            }
        }
        return this.graph.toJSONString();
    }

    @Override
    public String translate(HierarchyNetwork hn) {
        if (hn == null) {
            return null;
        }
        this.startNewGraph();
        Collection<HierarchyNetworkComponent> components = hn.getComponents();
        for (HierarchyNetworkComponent c : components) {
            this.createCompartment(c.getId(), c.getLabel(), c.getModification());
            List<HierarchyNetworkVariable> vars = c.getVariables();
            for (HierarchyNetworkVariable var : vars) {
                this.addNode(c.getId(), var.getId(), var.getLabel(), var.getModification(), false);
                HashMap<HierarchyNetworkVariable, HierarchyNetworkVariable.VarConnection> cons = var.getConnections();
                for (HierarchyNetworkVariable con : cons.keySet()) {
                    this.addEdge(con.getId(), var.getId(), cons.get(con).getModification(), "none");
                }
            }
            HierarchyNetworkComponent parA = c.getParentA();
            HierarchyNetworkComponent parB = c.getParentB();
            if (parA == null && parB == null) continue;
            if (parA == parB) {
                this.addEdge(parA.getId(), c.getId(), 0, "none");
                continue;
            }
            if (parA != null) {
                this.addEdge(parA.getId(), c.getId(), -1, "none");
            }
            if (parB == null) continue;
            this.addEdge(parA.getId(), c.getId(), 1, "none");
        }
        return this.graph.toJSONString();
    }
}

