/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.graph;

import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.hn.HierarchyNetwork;
import de.unirostock.sems.bives.ds.rn.ReactionNetwork;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstanceRef;
import java.util.Collection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GraphTranslatorSbgnJson
extends GraphTranslator {
    private JSONArray nodes;
    private JSONArray edges;
    private JSONObject graph;

    private void addNode(String id, String label, String compartment, int diffClass, String sbo) {
        String diff;
        JSONObject node = new JSONObject();
        node.put((Object)"id", (Object)id);
        node.put((Object)"label", (Object)label);
        node.put((Object)"compartment", (Object)compartment);
        node.put((Object)"class", (Object)sbo);
        switch (diffClass) {
            case 0: {
                diff = "nothing";
                break;
            }
            case -1: {
                diff = "delete";
                break;
            }
            case 2: {
                diff = "update";
                break;
            }
            case 3: {
                diff = "move";
                break;
            }
            case 1: {
                diff = "insert";
                break;
            }
            default: {
                diff = "diffClass" + diffClass;
            }
        }
        node.put((Object)"bivesClass", (Object)diff);
        this.nodes.add((Object)node);
    }

    private void addCompartment(String id, String compartment, String label, int diffClass, String sbo) {
        String diff;
        JSONObject node = new JSONObject();
        node.put((Object)"id", (Object)id);
        node.put((Object)"label", (Object)label);
        node.put((Object)"compartment", (Object)compartment);
        node.put((Object)"class", (Object)sbo);
        switch (diffClass) {
            case 0: {
                diff = "nothing";
                break;
            }
            case -1: {
                diff = "delete";
                break;
            }
            case 2: {
                diff = "update";
                break;
            }
            case 3: {
                diff = "move";
                break;
            }
            case 1: {
                diff = "insert";
                break;
            }
            default: {
                diff = "";
            }
        }
        node.put((Object)"bivesClass", (Object)diff);
        this.nodes.add((Object)node);
    }

    private void addEdge(String source, String target, String sbgnClass, int diffClass) {
        String diff;
        JSONObject edge = new JSONObject();
        edge.put((Object)"source", (Object)source);
        edge.put((Object)"target", (Object)target);
        edge.put((Object)"class", (Object)sbgnClass);
        switch (diffClass) {
            case 0: {
                diff = "nothing";
                break;
            }
            case -1: {
                diff = "delete";
                break;
            }
            case 2: {
                diff = "update";
                break;
            }
            case 3: {
                diff = "move";
                break;
            }
            case 1: {
                diff = "insert";
                break;
            }
            default: {
                diff = "bivesClass" + diffClass;
            }
        }
        edge.put((Object)"bivesClass", (Object)diff);
        this.edges.add((Object)edge);
    }

    private void startNewGraph() {
        this.graph = new JSONObject();
        this.nodes = new JSONArray();
        this.edges = new JSONArray();
        this.graph.put((Object)"nodes", (Object)this.nodes);
        this.graph.put((Object)"links", (Object)this.edges);
    }

    public JSONObject getJsonGraph() {
        return this.graph;
    }

    @Override
    public String translate(ReactionNetwork rn) {
        if (rn == null) {
            return null;
        }
        this.startNewGraph();
        for (ReactionNetworkCompartment c : rn.getCompartments()) {
            this.addCompartment(c.getId(), "null", c.getLabel(), c.getModification(), "SBO:0000290");
        }
        for (ReactionNetworkSubstance s : rn.getSubstances()) {
            ReactionNetworkCompartment compartment = s.getCompartment();
            String label = "" + s.getLabel();
            if (label.equals("EmptySet") || label.equals("Empty Set") || label.equals("emptyset") || label.equals("empty set")) continue;
            if (compartment != null && !compartment.equals("null")) {
                this.addNode(s.getId(), s.getLabel(), compartment.getId(), s.getModification(), s.getSBO());
                continue;
            }
            this.addNode(s.getId(), s.getLabel(), null, s.getModification(), s.getSBO());
        }
        int sourceSink = 0;
        for (ReactionNetworkReaction r : rn.getReactions()) {
            String label;
            ReactionNetworkCompartment compartment = r.getCompartment();
            Collection<ReactionNetworkSubstanceRef> inputs = r.getInputs();
            Collection<ReactionNetworkSubstanceRef> outputs = r.getOutputs();
            Collection<ReactionNetworkSubstanceRef> modifiers = r.getModifiers();
            String processId = r.getId();
            String compartmentId = null;
            if (compartment != null) {
                compartmentId = compartment.getId();
            }
            if (r.getSBO() == null || r.getSBO().equals("")) {
                this.addNode(processId, null, compartmentId, r.getModification(), "SBO:0000205");
            } else {
                this.addNode(processId, null, compartmentId, r.getModification(), r.getSBO());
            }
            if (!inputs.isEmpty()) {
                for (ReactionNetworkSubstanceRef s : inputs) {
                    label = "" + s.getSubstance().getLabel();
                    if (!label.matches("(?i)^empty[ ,_,\\',^]?set")) {
                        this.addEdge(s.getSubstance().getId(), processId, "SBO:0000015", r.getModification());
                        continue;
                    }
                    this.addNode("EmptySet" + sourceSink, null, compartmentId, r.getModification(), "SBO:0000291");
                    this.addEdge("EmptySet" + sourceSink, processId, "SBO:0000015", r.getModification());
                    ++sourceSink;
                }
            } else {
                this.addNode("EmptySet" + sourceSink, null, compartmentId, r.getModification(), "SBO:0000291");
                this.addEdge("EmptySet" + sourceSink, processId, "SBO:0000015", r.getModification());
                ++sourceSink;
            }
            if (!outputs.isEmpty()) {
                for (ReactionNetworkSubstanceRef s : outputs) {
                    label = "" + s.getSubstance().getLabel();
                    if (!label.matches("(?i)^empty[ ,_,\\',^]?set")) {
                        this.addEdge(processId, s.getSubstance().getId(), "SBO:0000393", r.getModification());
                        continue;
                    }
                    this.addNode("EmptySet" + sourceSink, null, compartmentId, r.getModification(), "SBO:0000291");
                    this.addEdge(processId, "EmptySet" + sourceSink, "SBO:0000393", r.getModification());
                    ++sourceSink;
                }
            } else {
                this.addNode("EmptySet" + sourceSink, null, compartmentId, r.getModification(), "SBO:0000291");
                this.addEdge(processId, "EmptySet" + sourceSink, "SBO:0000393", r.getModification());
                ++sourceSink;
            }
            if (modifiers == null) continue;
            for (ReactionNetworkSubstanceRef s : modifiers) {
                this.addEdge(s.getSubstance().getId(), processId, s.getSBO(), s.getModification());
            }
        }
        return this.graph.toJSONString();
    }

    @Override
    public String translate(HierarchyNetwork hn) {
        return null;
    }
}

