/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.hn;

import de.unirostock.sems.bives.ds.hn.HierarchyNetwork;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkComponent;
import de.unirostock.sems.bives.ds.hn.HierarchyNetworkEntity;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.HashMap;

public class HierarchyNetworkVariable
extends HierarchyNetworkEntity {
    private HierarchyNetworkComponent componentA;
    private HierarchyNetworkComponent componentB;
    private HashMap<HierarchyNetworkVariable, VarConnection> connections;

    public HierarchyNetworkVariable(HierarchyNetwork hn, String labelA, String labelB, DocumentNode docA, DocumentNode docB, HierarchyNetworkComponent componentA, HierarchyNetworkComponent componentB) {
        super("v" + hn.getNextVariableID(), labelA, labelB, docA, docB);
        this.componentA = componentA;
        this.componentB = componentB;
        this.connections = new HashMap();
    }

    public HashMap<HierarchyNetworkVariable, VarConnection> getConnections() {
        return this.connections;
    }

    public void addConnectionA(HierarchyNetworkVariable var) {
        VarConnection v = this.connections.get(var);
        if (v == null) {
            this.connections.put(var, new VarConnection(true, false));
        } else {
            v.a = true;
        }
    }

    public void addConnectionB(HierarchyNetworkVariable var) {
        VarConnection v = this.connections.get(var);
        if (v == null) {
            this.connections.put(var, new VarConnection(false, true));
        } else {
            v.b = true;
        }
    }

    public void setComponentA(HierarchyNetworkComponent component) {
        this.componentA = component;
    }

    public void setComponentB(HierarchyNetworkComponent component) {
        this.componentB = component;
    }

    public HierarchyNetworkComponent getComponent() {
        if (this.componentA == this.componentB) {
            return this.componentA;
        }
        return null;
    }

    @Override
    public int getModification() {
        int i = super.getModification();
        if (i != 0) {
            return i;
        }
        if (this.componentA != this.componentB) {
            return 2;
        }
        return 0;
    }

    public class VarConnection {
        public boolean a;
        public boolean b;

        public VarConnection(boolean a, boolean b) {
            this.a = a;
            this.b = b;
        }

        public int getModification() {
            return this.a ? (this.b ? 0 : -1) : (this.b ? 1 : 0);
        }
    }
}

