/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.markup;

import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.markup.MarkupSection;
import de.unirostock.sems.bives.markup.Typesetting;
import java.util.List;

public class TypesettingMarkDown
extends Typesetting {
    @Override
    public String typeset(MarkupDocument doc) {
        String s = doc.getHeadline() + NL_TXT + "===================" + NL_TXT + NL_TXT;
        List<String> headers = doc.getHeader();
        for (String head : headers) {
            s = s + "* " + head + NL_TXT;
        }
        s = s + NL_TXT;
        List<MarkupSection> sections = doc.getSections();
        for (MarkupSection sec : sections) {
            s = s + this.typesetSection(sec);
        }
        s = MarkupDocument.replaceHighlights(s, "*", "*");
        s = MarkupDocument.replaceInserts(s, "<span class='bives-insert'>", "</span>");
        s = MarkupDocument.replaceDeletes(s, "<span class='bives-delete'>", "</span>");
        s = MarkupDocument.replaceSupplementals(s, "<span class='bives-suppl'>", "</span>");
        s = MarkupDocument.replaceAttributes(s, "<span class='bives-attr'>", "</span>");
        s = MarkupDocument.replaceAllMaths(s, "<span class='bives-math'>", "</span>");
        s = MarkupDocument.replaceRightArrow(s, "->");
        s = MarkupDocument.replaceMultiplication(s, "*");
        return s;
    }

    private String typesetSection(MarkupSection section) {
        String s = NL_TXT + section.getHeader() + NL_TXT + "-------------------" + NL_TXT + NL_TXT;
        List<MarkupElement> elements = section.getValues();
        for (MarkupElement e : elements) {
            s = s + this.typesetElement(e);
        }
        return s + NL_TXT + NL_TXT;
    }

    private String typesetElement(MarkupElement element) {
        String s = "* **" + element.getHeader() + "**" + NL_TXT;
        List<String> values = element.getValues();
        for (String v : values) {
            s = s + "    * " + v + NL_TXT;
        }
        List<MarkupElement> subElements = element.getSubElements();
        for (MarkupElement e : subElements) {
            s = s + "    * " + this.typesetSubElement(e) + NL_TXT;
        }
        if (element.hasInvisibleModifications()) {
            s = s + "(There are modifications (annotations/notes/..), which are not displayed in this report)" + NL_TXT;
        }
        return s;
    }

    private String typesetSubElement(MarkupElement element) {
        String s = "**" + element.getHeader() + "**" + NL_TXT;
        List<String> values = element.getValues();
        for (String v : values) {
            s = s + "        * " + v + "";
        }
        if (element.hasInvisibleModifications()) {
            s = s + "    (There are modifications (annotations/notes/..), which are not displayed in this report)";
        }
        return s;
    }
}

