/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm.general;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.DiffAnnotator;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.algorithm.Producer;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.Patch;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import org.jdom2.Document;

public class PatchProducer
extends Producer {
    private Patch patch;
    private boolean fullDiff;
    private DiffAnnotator diffAnnotator;

    @Override
    public void init(SimpleConnectionManager conMgmt, TreeDocument docA, TreeDocument docB) {
        super.init(conMgmt, docA, docB);
        this.fullDiff = true;
        LOGGER.info((Object[])new Object[]{"creating patch producer: "});
    }

    public void init(SimpleConnectionManager conMgmt, TreeDocument docA, TreeDocument docB, DiffAnnotator annotator) {
        super.init(conMgmt, docA, docB);
        this.diffAnnotator = annotator;
        this.fullDiff = true;
        LOGGER.info((Object[])new Object[]{"creating patch producer: "});
    }

    public Patch getPatch() {
        return this.patch;
    }

    @Override
    public String produce() {
        return this.produce(true);
    }

    public String produce(boolean inclAnnotations) {
        LOGGER.info((Object[])new Object[]{"producing patch -- incl annotations: ", inclAnnotations});
        this.patch = this.diffAnnotator == null ? new Patch(this.fullDiff) : new Patch(this.fullDiff, this.diffAnnotator);
        this.producePatchA((TreeNode)this.docA.getRoot());
        this.producePatchB((TreeNode)this.docB.getRoot());
        this.patch.annotatePatch();
        LOGGER.info((Object[])new Object[]{"patch finished, producing xml output"});
        return XmlTools.prettyPrintDocument((Document)this.patch.getDocument(inclAnnotations));
    }

    public String getAnnotations() {
        if (this.patch == null) {
            return null;
        }
        return this.patch.getAnnotationDocumentXml();
    }

    private void producePatchA(TreeNode node) {
        if (node.hasModification(256)) {
            this.patch.deleteSubtree(node, -1);
        } else {
            if (node.hasModification(1)) {
                this.patch.deleteNode(node, -1);
            } else {
                if (node.hasModification(48)) {
                    LOGGER.error((Object[])new Object[]{"detected multiple connections of a single node, but copy & glue not supported yet..."});
                    throw new UnsupportedOperationException("copy & glue not supported yet...");
                }
                this.patch.updateNode((NodeConnection)this.conMgmt.getConnectionForNode(node), this.conMgmt);
            }
            if (node.getType() == 1) {
                DocumentNode dnode = (DocumentNode)node;
                for (TreeNode n : dnode.getChildren()) {
                    this.producePatchA(n);
                }
            }
        }
    }

    private void producePatchB(TreeNode node) {
        if (node.hasModification(256)) {
            this.patch.insertSubtree(node, -1);
        } else {
            if (node.hasModification(1)) {
                this.patch.insertNode(node, -1);
            } else if ((node.getModification() & 0x30) != 0) {
                LOGGER.error((Object[])new Object[]{"detected multiple connections of a single node, but copy & glue not supported yet..."});
                throw new UnsupportedOperationException("copy & glue not supported yet...");
            }
            if (node.getType() == 1) {
                DocumentNode dnode = (DocumentNode)node;
                for (TreeNode n : dnode.getChildren()) {
                    this.producePatchB(n);
                }
            }
        }
    }
}

