/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.rn;

import de.unirostock.sems.bives.ds.GraphEntity;
import de.unirostock.sems.bives.ds.ontology.SBOTerm;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.exception.BivesUnsupportedException;

public class ReactionNetworkSubstanceRef
implements GraphEntity {
    public ReactionNetworkSubstance subst;
    private boolean refA;
    private boolean refB;
    public SBOTerm modTermA;
    public SBOTerm modTermB;
    protected boolean singleDoc;

    public ReactionNetworkSubstanceRef(ReactionNetworkSubstance subst, boolean flagA, boolean flagB, SBOTerm modTermA, SBOTerm modTermB) throws BivesUnsupportedException {
        this.subst = subst;
        this.refA = flagA;
        this.refB = flagB;
        this.modTermA = modTermA;
        this.modTermB = modTermB;
        this.singleDoc = false;
        if (this.refA && this.refB && !SBOTerm.sameModifier(modTermA, modTermB)) {
            throw new BivesUnsupportedException("modifiers differ");
        }
    }

    public void setSboA(SBOTerm modTermA) throws BivesUnsupportedException {
        this.modTermA = modTermA;
        if (this.refA && this.refB && !SBOTerm.sameModifier(modTermA, this.modTermB)) {
            throw new BivesUnsupportedException("modifiers differ");
        }
    }

    public void setSboB(SBOTerm modTermB) throws BivesUnsupportedException {
        this.modTermB = modTermB;
        if (this.refA && this.refB && !SBOTerm.sameModifier(this.modTermA, modTermB)) {
            throw new BivesUnsupportedException("modifiers differ");
        }
    }

    public ReactionNetworkSubstance getSubstance() {
        return this.subst;
    }

    public void setFlagA(boolean flagA) {
        this.refA = flagA;
    }

    public void setFlagB(boolean flagB) {
        this.refB = flagB;
    }

    public String getSBO() {
        if (this.modTermA == null && this.modTermB == null) {
            return "";
        }
        if (this.modTermA == null) {
            return this.modTermB.getSBOTerm();
        }
        return this.modTermA.getSBOTerm();
    }

    public String getModTerm() {
        if (this.modTermA == null && this.modTermB == null) {
            return "unknown";
        }
        if (this.modTermA == null) {
            return this.modTermB.resolveModifier();
        }
        return this.modTermA.resolveModifier();
    }

    public int getModification() {
        if (this.singleDoc) {
            return 0;
        }
        if (this.refA && this.refB) {
            if (this.modTermA == null && this.modTermB == null) {
                return 0;
            }
            if (this.modTermA != null && this.modTermB != null && this.modTermA.resolveModifier().equals(this.modTermB.resolveModifier())) {
                return 0;
            }
            return 2;
        }
        if (this.refA) {
            return -1;
        }
        return 1;
    }

    public void setSingleDocument() {
        this.singleDoc = true;
    }
}

