/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.markup;

import de.unirostock.sems.bives.markup.MarkupSection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MarkupDocument {
    private String headline;
    private List<MarkupSection> sections;
    private List<String> header;

    public MarkupDocument(String headline) {
        this.headline = headline;
        this.sections = new ArrayList<MarkupSection>();
        this.header = new ArrayList<String>();
    }

    public void addHeader(String header) {
        this.header.add(header);
    }

    public void addSection(MarkupSection section) {
        this.sections.add(section);
    }

    public static final String highlight(String s) {
        return "{{highlight}}" + s + "}}highlight{{";
    }

    public static final String insert(String s) {
        return "{{insert}}" + s + "}}insert{{";
    }

    public static final String delete(String s) {
        return "{{delete}}" + s + "}}delete{{";
    }

    public static final String supplemental(String s) {
        return "{{supp}}" + s + "}}supp{{";
    }

    public static final String attribute(String s) {
        return "{{attribute}}" + s + "}}attribute{{";
    }

    public static final String math(String s) {
        return "{{math}}" + s + "}}math{{";
    }

    public static final String math(String s, boolean original) {
        if (original) {
            return "{{mathD}}" + s + "}}mathD{{";
        }
        return "{{mathI}}" + s + "}}mathI{{";
    }

    public static final String rightArrow() {
        return "{{rightArrow}}";
    }

    public static final String multiply() {
        return "{{multiplication}}";
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<MarkupSection> getSections() {
        return this.sections;
    }

    public String getHeadline() {
        return this.headline;
    }

    public static final String replaceHighlights(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{highlight}}", "}}highlight{{", pre, post);
    }

    public static final String replaceInserts(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{insert}}", "}}insert{{", pre, post);
    }

    public static final String replaceDeletes(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{delete}}", "}}delete{{", pre, post);
    }

    public static final String replaceSupplementals(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{supp}}", "}}supp{{", pre, post);
    }

    public static final String replaceAttributes(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{attribute}}", "}}attribute{{", pre, post);
    }

    public static final String replaceModifiedMaths(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{mathI}}", "}}mathI{{", pre, post);
    }

    public static final String replaceOriginalMaths(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{mathD}}", "}}mathD{{", pre, post);
    }

    public static final String replaceAllMaths(String s, String pre, String post) {
        return MarkupDocument.replace(MarkupDocument.replace(MarkupDocument.replace(s, "{{mathI}}", "}}mathI{{", pre, post), "{{mathD}}", "}}mathD{{", pre, post), "{{math}}", "}}math{{", pre, post);
    }

    public static final String replaceUnchangedMaths(String s, String pre, String post) {
        return MarkupDocument.replace(s, "{{math}}", "}}math{{", pre, post);
    }

    public static final String replaceMultiplication(String s, String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        return s.replaceAll(Pattern.quote("{{multiplication}}"), replacement);
    }

    public static final String replaceRightArrow(String s, String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        return s.replaceAll(Pattern.quote("{{rightArrow}}"), replacement);
    }

    private static final String replace(String s, String pre, String post, String rpre, String rpost) {
        if (rpre == null) {
            rpre = "";
        }
        if (rpost == null) {
            rpost = "";
        }
        String ret = s.replaceAll(Pattern.quote(pre), rpre);
        ret = ret.replaceAll(Pattern.quote(post), rpost);
        return ret;
    }
}

