/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.tools;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.api.RegularDiff;
import de.unirostock.sems.bives.ds.Patch;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.tools.DocumentTools;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.Element;

public class BivesTools {
    private static String BIVES_VERSION = "unknown";

    private static String getBivesModuleVersion(String moduleFile, String moduleName) {
        String version = "";
        InputStream in = BivesTools.class.getResourceAsStream(moduleFile);
        if (in != null) {
            Properties prop = new Properties();
            try {
                prop.load(in);
                String v = (String)prop.get("version");
                if (v != null && v.length() > 0) {
                    version = "[" + moduleName + v + "] ";
                }
                in.close();
            }
            catch (IOException e) {
                LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to open version file " + moduleFile});
            }
        }
        return version;
    }

    public static String getBivesVersion() {
        return BIVES_VERSION;
    }

    public static void genMathMarkupStats(DocumentNode a, DocumentNode b, MarkupElement markupElement) {
        if (a == null && b == null) {
            return;
        }
        try {
            if (a == null) {
                markupElement.addValue("inserted math: " + MarkupDocument.math(MarkupDocument.insert(DocumentTools.transformMathML((DocumentNode)b)), false));
            } else if (b == null) {
                markupElement.addValue("deleted math: " + MarkupDocument.math(MarkupDocument.delete(DocumentTools.transformMathML((DocumentNode)a)), true));
            } else if (a.hasModification(12)) {
                String mathA = DocumentTools.transformMathML((DocumentNode)a);
                String mathB = DocumentTools.transformMathML((DocumentNode)b);
                TreeDocument tdA = new TreeDocument(XmlTools.readDocument((String)mathA), null);
                TreeDocument tdB = new TreeDocument(XmlTools.readDocument((String)mathB), null);
                RegularDiff differ = new RegularDiff(tdA, tdB);
                differ.mapTrees();
                Patch p = differ.getPatch();
                Element deletes = p.getDeletes();
                for (Object el : deletes.getChildren()) {
                    if (el.getName().equals("node")) {
                        BivesTools.markDeleted((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                        continue;
                    }
                    if (el.getName().equals("attribute")) {
                        BivesTools.markUpdated((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                        continue;
                    }
                    BivesTools.markDeleted(((TextNode)tdA.getNodeByPath(el.getAttributeValue("oldPath"))).getParent());
                }
                Element inserts = p.getInserts();
                for (Object el : inserts.getChildren()) {
                    if (el.getName().equals("node")) {
                        BivesTools.markInserted((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                        continue;
                    }
                    if (el.getName().equals("attribute")) {
                        BivesTools.markUpdated((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                        continue;
                    }
                    BivesTools.markInserted(((TextNode)tdB.getNodeByPath(el.getAttributeValue("newPath"))).getParent());
                }
                Element moves = p.getMoves();
                for (Element el : moves.getChildren()) {
                    if (el.getName().equals("node")) {
                        BivesTools.markMoved((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                        BivesTools.markMoved((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                        continue;
                    }
                    BivesTools.markMoved(((TextNode)tdA.getNodeByPath(el.getAttributeValue("oldPath"))).getParent());
                    BivesTools.markMoved(((TextNode)tdB.getNodeByPath(el.getAttributeValue("newPath"))).getParent());
                }
                Element updates = p.getUpdates();
                for (Element el : updates.getChildren()) {
                    if (el.getName().equals("attribute")) {
                        BivesTools.markUpdated((DocumentNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                        BivesTools.markUpdated((DocumentNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                        continue;
                    }
                    BivesTools.markUpdated((TextNode)tdA.getNodeByPath(el.getAttributeValue("oldPath")));
                    BivesTools.markUpdated((TextNode)tdB.getNodeByPath(el.getAttributeValue("newPath")));
                }
                markupElement.addValue("modified math: " + MarkupDocument.math(XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)tdA)), true) + " to " + MarkupDocument.math(XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)tdB)), false));
            }
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"error generating math"});
            markupElement.addValue("error generating math: " + e.getMessage());
        }
    }

    public static void markDeleted(DocumentNode dn) {
        dn.setAttribute("class", "bives-delete");
    }

    public static void markInserted(DocumentNode dn) {
        dn.setAttribute("class", "bives-insert");
    }

    public static void markMoved(DocumentNode dn) {
        if (dn.getAttribute("class") == null) {
            dn.setAttribute("class", "bives-move");
        }
    }

    public static void markUpdated(TextNode tn) {
        if (tn.getParent().getAttribute("class") == null) {
            tn.getParent().setAttribute("class", "bives-update");
        }
    }

    public static void markUpdated(DocumentNode dn) {
        if (dn.getAttribute("class") == null) {
            dn.setAttribute("class", "bives-update");
        }
    }

    public static void genAttributeMarkupStats(DocumentNode a, DocumentNode b, MarkupElement markupElement) {
        if (a == null || b == null) {
            return;
        }
        HashSet allAttr = new HashSet();
        allAttr.addAll(a.getAttributes());
        allAttr.addAll(b.getAttributes());
        for (String attr : allAttr) {
            String aA = a.getAttributeValue(attr);
            String bA = b.getAttributeValue(attr);
            if (aA == null) {
                markupElement.addValue("Attribute " + MarkupDocument.attribute(attr) + " was inserted: " + MarkupDocument.insert(bA));
                continue;
            }
            if (bA == null) {
                markupElement.addValue("Attribute " + MarkupDocument.attribute(attr) + " was deleted: " + MarkupDocument.delete(aA));
                continue;
            }
            if (aA.equals(bA)) continue;
            markupElement.addValue("Attribute " + MarkupDocument.attribute(attr) + " has changed: " + MarkupDocument.delete(aA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert(bA));
        }
    }

    static {
        BIVES_VERSION = "BiVeS compiled with: ";
        BIVES_VERSION = BIVES_VERSION + BivesTools.getBivesModuleVersion("/bives-version.properties", "BiVeS FrameWork v");
        BIVES_VERSION = BIVES_VERSION + BivesTools.getBivesModuleVersion("/bives-core-version.properties", "BiVeS Core v");
        BIVES_VERSION = BIVES_VERSION + BivesTools.getBivesModuleVersion("/bives-sbml-version.properties", "BiVeS SBML v");
        BIVES_VERSION = BIVES_VERSION + BivesTools.getBivesModuleVersion("/bives-cellml-version.properties", "BiVeS CellML v");
    }
}

