/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.algorithm;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SimpleConnectionManager
implements ConnectionManager {
    private List<NodeConnection> connections;
    private HashMap<TreeNode, Connection> conByTree1;
    private HashMap<TreeNode, Connection> conByTree2;
    private TreeDocument docA;
    private TreeDocument docB;

    public SimpleConnectionManager(TreeDocument docA, TreeDocument docB) {
        this.docA = docA;
        this.docB = docB;
        this.connections = new ArrayList<NodeConnection>();
        this.conByTree1 = new HashMap();
        this.conByTree2 = new HashMap();
    }

    public SimpleConnectionManager(SimpleConnectionManager toCopy) throws BivesConnectionException {
        this.docA = toCopy.docA;
        this.docB = toCopy.docB;
        this.connections = new ArrayList<NodeConnection>();
        this.conByTree1 = new HashMap();
        this.conByTree2 = new HashMap();
        for (NodeConnection c : toCopy.connections) {
            this.addConnection(new NodeConnection(c));
        }
    }

    public void scaleWeightOfAllConnections(double value) {
        for (Connection connection : this.connections) {
            connection.scaleWeight(value);
        }
    }

    public void addWeightToAllConnections(double value) {
        for (Connection connection : this.connections) {
            connection.addWeight(value);
        }
    }

    public void setWeightOfAllConnections(double value) {
        for (Connection connection : this.connections) {
            connection.setWeight(value);
        }
    }

    public boolean addConnection(NodeConnection c) throws BivesConnectionException {
        Connection cc = this.conByTree1.get(c.getTreeA());
        if (cc != null) {
            throw new BivesConnectionException("node " + c.getTreeA().getXPath() + " already connected. cannot add another connection");
        }
        cc = this.conByTree2.get(c.getTreeB());
        if (cc != null) {
            throw new BivesConnectionException("node " + c.getTreeB().getXPath() + " already connected. cannot add another connection");
        }
        this.conByTree1.put(c.getTreeA(), c);
        this.conByTree2.put(c.getTreeB(), c);
        this.connections.add(c);
        return true;
    }

    public SimpleConnectionManager union(SimpleConnectionManager cmgmt) {
        if (this.docA != cmgmt.docA || this.docB != cmgmt.docB) {
            LOGGER.error((Object[])new Object[]{"cannot join connection managers from different docs!"});
            return null;
        }
        SimpleConnectionManager union = new SimpleConnectionManager(this.docA, this.docB);
        for (NodeConnection c : this.connections) {
            try {
                union.addConnection(new NodeConnection(c));
            }
            catch (BivesConnectionException e) {
                LOGGER.warn((Exception)e, (Object[])new Object[]{"got an exception while joining connection managers"});
            }
        }
        for (NodeConnection c : cmgmt.connections) {
            try {
                union.addConnection(new NodeConnection(c));
            }
            catch (BivesConnectionException e) {
                LOGGER.info((Exception)e, (Object[])new Object[]{"got an exception while joining connection managers, connection probably already included from first cmgr."});
            }
        }
        return union;
    }

    public SimpleConnectionManager intersection(SimpleConnectionManager cmgmt) {
        if (this.docA != cmgmt.docA || this.docB != cmgmt.docB) {
            LOGGER.error((Object[])new Object[]{"cannot intersect connection managers from different docs!"});
            return null;
        }
        SimpleConnectionManager intersection = new SimpleConnectionManager(this.docA, this.docB);
        for (NodeConnection c : this.connections) {
            if (cmgmt.getConnectionOfNodes(c.getTreeA(), c.getTreeB()) == null) continue;
            try {
                intersection.addConnection(c);
            }
            catch (BivesConnectionException e) {
                LOGGER.error((Exception)e, (Object[])new Object[]{"got an exception while intersecting connection managers. this shouldn't happen!"});
            }
        }
        return intersection;
    }

    public SimpleConnectionManager setDiff(SimpleConnectionManager cmgmt) {
        if (this.docA != cmgmt.docA || this.docB != cmgmt.docB) {
            LOGGER.error((Object[])new Object[]{"cannot calc the set diff of connection managers from different docs!"});
            return null;
        }
        SimpleConnectionManager intersection = new SimpleConnectionManager(this.docA, this.docB);
        for (NodeConnection c : this.connections) {
            if (cmgmt.getConnectionOfNodes(c.getTreeA(), c.getTreeB()) != null) continue;
            try {
                intersection.addConnection(c);
            }
            catch (BivesConnectionException e) {
                LOGGER.error((Exception)e, (Object[])new Object[]{"got an exception while ste-diffing connection managers. this shouldn't happen!"});
            }
        }
        return intersection;
    }

    public SimpleConnectionManager symDiff(SimpleConnectionManager cmgmt) {
        return this.setDiff(cmgmt).union(cmgmt.setDiff(this));
    }

    public void dropConnection(TreeNode node) {
        Connection c = this.conByTree1.get(node);
        if (c == null) {
            c = this.conByTree2.get(node);
            if (c != null) {
                this.conByTree1.remove(c.getTreeA());
                this.conByTree2.remove(c.getTreeB());
            }
        } else {
            this.conByTree1.remove(c.getTreeA());
            this.conByTree2.remove(c.getTreeB());
        }
        if (c != null) {
            this.connections.remove(c);
        }
    }

    public void dropConnection(Connection c) {
        if (this.connections.remove(c)) {
            this.conByTree1.remove(c.getTreeA());
            this.conByTree2.remove(c.getTreeB());
        }
    }

    public Connection getConnectionForNode(TreeNode node) {
        Connection c = this.conByTree1.get(node);
        if (c != null) {
            return c;
        }
        c = this.conByTree2.get(node);
        return c;
    }

    public Connection getConnectionOfNodes(TreeNode a, TreeNode b) {
        Connection c = this.conByTree1.get(a);
        if (c != null && c.getTreeB() == b) {
            return c;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("connections: " + this.connections.size() + "-" + this.conByTree1.size() + "-" + this.conByTree2.size() + "\n");
        for (Connection connection : this.connections) {
            sb.append(connection + "\n");
        }
        return sb.toString();
    }

    public List<TreeNode> getUnmatched(TreeNode subtree, List<TreeNode> unmatched) {
        Connection c = this.getConnectionForNode(subtree);
        if (c == null) {
            unmatched.add(subtree);
        }
        if (subtree.getType() == 1) {
            DocumentNode dn = (DocumentNode)subtree;
            for (TreeNode kid : dn.getChildren()) {
                this.getUnmatched(kid, unmatched);
            }
        }
        return unmatched;
    }

    public void deleteMatchedNodes(List<TreeNode> vec) {
        for (int c = vec.size() - 1; c >= 0; --c) {
            Connection ccs = this.getConnectionForNode(vec.get(c));
            if (ccs == null) continue;
            vec.remove(c);
        }
    }

    public boolean parentsConnected(Connection c) {
        DocumentNode pA = c.getTreeA().getParent();
        DocumentNode pB = c.getTreeB().getParent();
        if (pA == null && pB == null) {
            return true;
        }
        if (pA == null || pB == null) {
            return false;
        }
        return this.getConnectionOfNodes((TreeNode)pA, (TreeNode)pB) != null;
    }
}

