/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.DiffAnnotator;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.algorithm.general.DefaultDiffAnnotator;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.comodi.Change;
import de.unirostock.sems.comodi.ChangeFactory;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class Patch {
    public static URI PATCH_FILE_NAME = URI.create("file://bives-differences.patch");
    private URI patchFileName;
    private ChangeFactory changeAnnotationFactory;
    private DiffAnnotator diffAnnotator;
    private int id;
    private Document xmlDoc;
    private Element insert;
    private Element delete;
    private Element update;
    private Element move;
    private boolean fullDiff;

    public Patch(URI patchFileName, DiffAnnotator diffAnnotator) {
        this.fullDiff = true;
        this.init(patchFileName, diffAnnotator);
    }

    public Patch(DiffAnnotator diffAnnotator) {
        this.fullDiff = true;
        this.init(PATCH_FILE_NAME, diffAnnotator);
    }

    public Patch(boolean fullDiff, URI patchFileName, DiffAnnotator diffAnnotator) {
        this.fullDiff = fullDiff;
        this.init(patchFileName, diffAnnotator);
    }

    public Patch(boolean fullDiff, DiffAnnotator diffAnnotator) {
        this.fullDiff = fullDiff;
        this.init(PATCH_FILE_NAME, diffAnnotator);
    }

    public Patch(URI patchFileName) {
        this.fullDiff = true;
        this.init(patchFileName, new DefaultDiffAnnotator());
    }

    public Patch() {
        this.fullDiff = true;
        this.init(PATCH_FILE_NAME, new DefaultDiffAnnotator());
    }

    public Patch(boolean fullDiff, URI patchFileName) {
        this.fullDiff = fullDiff;
        this.init(patchFileName, new DefaultDiffAnnotator());
    }

    public Patch(boolean fullDiff) {
        this.fullDiff = fullDiff;
        this.init(PATCH_FILE_NAME, new DefaultDiffAnnotator());
    }

    public int getNumMoves() {
        return this.move.getChildren().size();
    }

    public int getNumUpdates() {
        return this.update.getChildren().size();
    }

    public int getNumDeletes() {
        return this.delete.getChildren().size();
    }

    public int getNumInserts() {
        return this.insert.getChildren().size();
    }

    public Element getDeletes() {
        return this.delete;
    }

    public Element getInserts() {
        return this.insert;
    }

    public Element getUpdates() {
        return this.update;
    }

    public Element getMoves() {
        return this.move;
    }

    public int getNumNodeChanges() {
        return this.insert.getChildren("node").size() + this.delete.getChildren("node").size() + this.update.getChildren("node").size() + this.move.getChildren("node").size();
    }

    public int getNumTextChanges() {
        return this.insert.getChildren("text").size() + this.delete.getChildren("text").size() + this.update.getChildren("text").size() + this.move.getChildren("text").size();
    }

    public int getNumAttributeChanges() {
        return this.insert.getChildren("attribute").size() + this.delete.getChildren("attribute").size() + this.update.getChildren("attribute").size() + this.move.getChildren("attribute").size();
    }

    public Document getDocument(boolean inclAnnotations) {
        Element rootElement = new Element("bives");
        this.xmlDoc = new Document(rootElement);
        rootElement.setAttribute("type", "fullDiff");
        rootElement.setAttribute("id", "bivesPatch");
        rootElement.addContent((Content)new Comment(BivesTools.getBivesVersion()));
        rootElement.addContent((Content)this.update.clone());
        rootElement.addContent((Content)this.delete.clone());
        rootElement.addContent((Content)this.insert.clone());
        rootElement.addContent((Content)this.move.clone());
        if (inclAnnotations) {
            String xml = this.changeAnnotationFactory.getRdfXml();
            try {
                rootElement.addContent((Content)XmlTools.readDocument((String)xml.replaceAll(this.patchFileName.toString(), "")).getRootElement().detach());
            }
            catch (Exception e) {
                LOGGER.error((Exception)e, (Object[])new Object[]{"wasn't able to read rdf-annotations subtree to add it to the diff"});
            }
        }
        return this.xmlDoc;
    }

    public int getNumAnnotations() {
        return this.changeAnnotationFactory.getNumStatements();
    }

    public Document getDocument() {
        return this.getDocument(true);
    }

    public String getAnnotationDocumentXml() {
        return this.changeAnnotationFactory.getRdfXml();
    }

    public ChangeFactory getAnnotations() {
        return this.changeAnnotationFactory;
    }

    private void init(URI patchFileName, DiffAnnotator diffAnnotator) {
        this.patchFileName = patchFileName;
        this.diffAnnotator = diffAnnotator;
        LOGGER.info((Object[])new Object[]{"initializing patch w/ fullDiff = ", this.fullDiff});
        this.id = 0;
        this.update = new Element("update");
        this.delete = new Element("delete");
        this.insert = new Element("insert");
        this.move = new Element("move");
        this.changeAnnotationFactory = new ChangeFactory(this.patchFileName);
        LOGGER.info((Object[])new Object[]{"initialized patch"});
    }

    private Element createAttributeElement(int nodeId, String oldPath, String newPath, String name, String oldValue, String newValue, int chainId) {
        LOGGER.info((Object[])new Object[]{"create attribute element for ", oldPath, " -> ", newPath});
        Element attribute = new Element("attribute");
        attribute.setAttribute("name", name);
        attribute.setAttribute("id", nodeId + "");
        if (chainId > 0) {
            attribute.setAttribute("triggeredBy", chainId + "");
        }
        if (oldValue != null) {
            attribute.setAttribute("oldValue", oldValue);
        }
        if (newValue != null) {
            attribute.setAttribute("newValue", newValue);
        }
        if (oldPath != null) {
            attribute.setAttribute("oldPath", oldPath);
        }
        if (newPath != null) {
            attribute.setAttribute("newPath", newPath);
        }
        return attribute;
    }

    private Element createNodeElement(int nodeId, String oldParent, String newParent, String oldPath, String newPath, int oldChildNo, int newChildNo, String oldTag, String newTag, int chainId) {
        LOGGER.info((Object[])new Object[]{"create node element for ", oldPath, " -> ", newPath});
        Element node = new Element("node");
        node.setAttribute("id", "" + nodeId);
        if (chainId > 0) {
            node.setAttribute("triggeredBy", chainId + "");
        }
        if (oldParent != null) {
            node.setAttribute("oldParent", oldParent);
        }
        if (newParent != null) {
            node.setAttribute("newParent", newParent);
        }
        if (oldChildNo > 0) {
            node.setAttribute("oldChildNo", "" + oldChildNo);
        }
        if (newChildNo > 0) {
            node.setAttribute("newChildNo", newChildNo + "");
        }
        if (oldPath != null) {
            node.setAttribute("oldPath", oldPath);
        }
        if (newPath != null) {
            node.setAttribute("newPath", newPath);
        }
        if (oldTag != null) {
            node.setAttribute("oldTag", oldTag);
        }
        if (newTag != null) {
            node.setAttribute("newTag", newTag);
        }
        return node;
    }

    private Element createTextElement(int nodeId, String oldParent, String newParent, String oldPath, String newPath, int oldChildNo, int newChildNo, String oldText, String newText, int chainId) {
        LOGGER.info((Object[])new Object[]{"create text element for ", oldPath, " -> ", newPath});
        Element node = new Element("text");
        node.setAttribute("id", nodeId + "");
        if (chainId > 0) {
            node.setAttribute("triggeredBy", chainId + "");
        }
        if (oldParent != null) {
            node.setAttribute("oldParent", oldParent);
        }
        if (newParent != null) {
            node.setAttribute("newParent", newParent);
        }
        if (oldChildNo > 0) {
            node.setAttribute("oldChildNo", "" + oldChildNo);
        }
        if (newChildNo > 0) {
            node.setAttribute("newChildNo", "" + newChildNo);
        }
        if (oldPath != null) {
            node.setAttribute("oldPath", oldPath);
        }
        if (newPath != null) {
            node.setAttribute("newPath", newPath);
        }
        if (this.fullDiff) {
            if (oldText != null) {
                node.setAttribute("oldText", oldText);
            }
            if (newText != null) {
                node.setAttribute("newText", newText);
            }
        }
        return node;
    }

    public void deleteSubtree(TreeNode toDelete, int chainId) {
        switch (toDelete.getType()) {
            case 1: {
                DocumentNode dnode = (DocumentNode)toDelete;
                int parentId = this.deleteNode(dnode, chainId);
                for (TreeNode tn : dnode.getChildren()) {
                    this.deleteSubtree(tn, parentId);
                }
                break;
            }
            case 2: {
                this.deleteNode((TextNode)toDelete, chainId);
                break;
            }
            default: {
                LOGGER.error((Object[])new Object[]{"unsupported tree node type for deletion..."});
                throw new UnsupportedOperationException("unsupported tree node type...");
            }
        }
    }

    public void deleteNode(TreeNode toDelete, int chainId) {
        switch (toDelete.getType()) {
            case 1: {
                this.deleteNode((DocumentNode)toDelete, chainId);
                break;
            }
            case 2: {
                this.deleteNode((TextNode)toDelete, chainId);
                break;
            }
            default: {
                LOGGER.error((Object[])new Object[]{"unsupported tree node type for deletion..."});
                throw new UnsupportedOperationException("unsupported tree node type...");
            }
        }
    }

    private int deleteNode(DocumentNode toDelete, int chainId) {
        LOGGER.info((Object[])new Object[]{"deleting node ", toDelete.getXPath()});
        int nodeId = ++this.id;
        Element diffElement = this.createNodeElement(nodeId, this.getParentXpath((TreeNode)toDelete), null, toDelete.getXPath(), null, this.getChildNo((TreeNode)toDelete), -1, toDelete.getTagName(), null, chainId);
        this.delete.addContent((Content)diffElement);
        this.diffAnnotator.annotateDeletion((TreeNode)toDelete, diffElement, this.changeAnnotationFactory);
        if (!this.fullDiff) {
            return nodeId;
        }
        LOGGER.info((Object[])new Object[]{"checking attributes for full diff"});
        Set attr = toDelete.getAttributes();
        for (String a : attr) {
            this.deleteAttribute(toDelete, a, nodeId);
        }
        return nodeId;
    }

    private void deleteAttribute(DocumentNode node, String attribute, int chainId) {
        LOGGER.info((Object[])new Object[]{"deleting attribute ", attribute, " of ", node.getXPath()});
        Element diffElement = this.createAttributeElement(++this.id, node.getXPath(), null, attribute, node.getAttributeValue(attribute), null, chainId);
        this.delete.addContent((Content)diffElement);
        this.diffAnnotator.annotateDeletion((TreeNode)node, diffElement, this.changeAnnotationFactory);
    }

    private void deleteNode(TextNode toDelete, int chainId) {
        LOGGER.info((Object[])new Object[]{"deleting text of ", toDelete.getXPath()});
        Element diffElement = this.createTextElement(++this.id, this.getParentXpath((TreeNode)toDelete), null, toDelete.getXPath(), null, this.getChildNo((TreeNode)toDelete), -1, toDelete.getText(), null, chainId);
        this.delete.addContent((Content)diffElement);
        this.diffAnnotator.annotateDeletion((TreeNode)toDelete, diffElement, this.changeAnnotationFactory);
    }

    public void insertSubtree(TreeNode toInsert, int chainId) {
        switch (toInsert.getType()) {
            case 1: {
                DocumentNode dnode = (DocumentNode)toInsert;
                int parentId = this.insertNode(dnode, chainId);
                for (TreeNode tn : dnode.getChildren()) {
                    this.insertSubtree(tn, parentId);
                }
                break;
            }
            case 2: {
                this.insertNode((TextNode)toInsert, chainId);
                break;
            }
            default: {
                LOGGER.error((Object[])new Object[]{"unsupported tree node type for insertion..."});
                throw new UnsupportedOperationException("unsupported tree node type...");
            }
        }
    }

    public void insertNode(TreeNode toInsert, int chainId) {
        switch (toInsert.getType()) {
            case 1: {
                this.insertNode((DocumentNode)toInsert, chainId);
                break;
            }
            case 2: {
                this.insertNode((TextNode)toInsert, chainId);
                break;
            }
            default: {
                LOGGER.error((Object[])new Object[]{"unsupported tree node type for insertion..."});
                throw new UnsupportedOperationException("unsupported tree node type...");
            }
        }
    }

    public int insertNode(DocumentNode toInsert, int chainId) {
        LOGGER.info((Object[])new Object[]{"inserting node ", toInsert.getXPath()});
        int nodeId = ++this.id;
        Element diffElement = this.createNodeElement(nodeId, null, this.getParentXpath((TreeNode)toInsert), null, toInsert.getXPath(), -1, this.getChildNo((TreeNode)toInsert), null, toInsert.getTagName(), chainId);
        this.insert.addContent((Content)diffElement);
        this.diffAnnotator.annotateInsertion((TreeNode)toInsert, diffElement, this.changeAnnotationFactory);
        if (!this.fullDiff) {
            return nodeId;
        }
        LOGGER.info((Object[])new Object[]{"checking attributes for full diff"});
        Set attr = toInsert.getAttributes();
        for (String a : attr) {
            this.insertAttribute(toInsert, a, nodeId);
        }
        return nodeId;
    }

    private void insertAttribute(DocumentNode node, String attribute, int chainId) {
        LOGGER.info((Object[])new Object[]{"inserting attribute ", attribute, " of ", node.getXPath()});
        Element diffElement = this.createAttributeElement(++this.id, null, node.getXPath(), attribute, null, node.getAttributeValue(attribute), chainId);
        this.insert.addContent((Content)diffElement);
        this.diffAnnotator.annotateInsertion((TreeNode)node, diffElement, this.changeAnnotationFactory);
    }

    private void insertNode(TextNode toInsert, int chainId) {
        LOGGER.info((Object[])new Object[]{"inserting text of ", toInsert.getXPath()});
        Element diffElement = this.createTextElement(++this.id, null, this.getParentXpath((TreeNode)toInsert), null, toInsert.getXPath(), -1, this.getChildNo((TreeNode)toInsert), null, toInsert.getText(), chainId);
        this.insert.addContent((Content)diffElement);
        this.diffAnnotator.annotateInsertion((TreeNode)toInsert, diffElement, this.changeAnnotationFactory);
    }

    public void updateNode(NodeConnection c, SimpleConnectionManager conMgmt) {
        Element diffElement;
        boolean moveThem;
        TreeNode a = c.getTreeA();
        TreeNode b = c.getTreeB();
        LOGGER.info((Object[])new Object[]{"updating node ", a.getXPath(), " to become ", b.getXPath()});
        if (a.getType() != b.getType()) {
            LOGGER.error((Object[])new Object[]{"node types differ, not supported"});
            throw new UnsupportedOperationException("cannot update nodes of different type...");
        }
        if (((a.getModification() | b.getModification()) & 0x30) != 0) {
            throw new UnsupportedOperationException("copy & glue not supported yet...");
        }
        boolean bl = moveThem = (a.getModification() & 0x82) != 0;
        if (moveThem && LOGGER.isInfoEnabled()) {
            LOGGER.info((Object[])new Object[]{"will move them: par: ", conMgmt.parentsConnected(c), " chNoA: ", this.getChildNo(a), " chNoB: ", this.getChildNo(b)});
        }
        Change change = null;
        if (a.getType() == 2) {
            if ((a.getModification() & 4) != 0) {
                LOGGER.info((Object[])new Object[]{"text differs"});
                Element e = this.createTextElement(++this.id, this.getParentXpath(a), this.getParentXpath(b), a.getXPath(), b.getXPath(), this.getChildNo(a), this.getChildNo(b), ((TextNode)a).getText(), ((TextNode)b).getText(), -1);
                change = this.diffAnnotator.annotateUpdateText((TextNode)a, (TextNode)b, e, this.changeAnnotationFactory);
                if (moveThem) {
                    this.move.addContent((Content)e);
                    change = this.diffAnnotator.annotateMove(a, b, e, this.changeAnnotationFactory, conMgmt.parentsConnected(c));
                } else {
                    this.update.addContent((Content)e);
                }
            } else if (moveThem) {
                LOGGER.info((Object[])new Object[]{"equal text"});
                Element diffElement2 = this.createTextElement(++this.id, this.getParentXpath(a), this.getParentXpath(b), a.getXPath(), b.getXPath(), this.getChildNo(a), this.getChildNo(b), null, null, -1);
                this.move.addContent((Content)diffElement2);
                change = this.diffAnnotator.annotateMove(a, b, diffElement2, this.changeAnnotationFactory, conMgmt.parentsConnected(c));
            }
            if (change != null) {
                for (Map.Entry<Property, RDFNode> annotation : c.getAnnotations()) {
                    change.addAnnotation(annotation.getKey(), annotation.getValue());
                }
            }
            return;
        }
        DocumentNode dA = (DocumentNode)a;
        DocumentNode dB = (DocumentNode)b;
        if ((a.getModification() & 4) == 0) {
            if (moveThem) {
                LOGGER.info((Object[])new Object[]{"nodes unmodified"});
                diffElement = this.createNodeElement(++this.id, this.getParentXpath(a), this.getParentXpath(b), a.getXPath(), b.getXPath(), this.getChildNo(a), this.getChildNo(b), null, null, -1);
                this.move.addContent((Content)diffElement);
                change = this.diffAnnotator.annotateMove(a, b, diffElement, this.changeAnnotationFactory, conMgmt.parentsConnected(c));
            }
        } else {
            if (!dA.getTagName().equals(dB.getTagName())) {
                LOGGER.info((Object[])new Object[]{"label of nodes differ -> updating"});
                diffElement = this.createNodeElement(++this.id, this.getParentXpath(a), this.getParentXpath(b), a.getXPath(), b.getXPath(), this.getChildNo(a), this.getChildNo(b), dA.getTagName(), dB.getTagName(), -1);
                this.update.addContent((Content)diffElement);
            } else if (moveThem) {
                LOGGER.info((Object[])new Object[]{"label of nodes do not differ -> moving"});
                diffElement = this.createNodeElement(++this.id, this.getParentXpath(a), this.getParentXpath(b), a.getXPath(), b.getXPath(), this.getChildNo(a), this.getChildNo(b), null, null, -1);
                this.move.addContent((Content)diffElement);
                change = this.diffAnnotator.annotateMove(a, b, diffElement, this.changeAnnotationFactory, conMgmt.parentsConnected(c));
            }
            if (this.fullDiff) {
                LOGGER.info((Object[])new Object[]{"checking attributes for full diff"});
                HashSet allAttr = new HashSet();
                allAttr.addAll(dA.getAttributes());
                allAttr.addAll(dB.getAttributes());
                for (String attr : allAttr) {
                    String aA = dA.getAttributeValue(attr);
                    String bA = dB.getAttributeValue(attr);
                    if (aA == null) {
                        this.insertAttribute(dB, attr, -1);
                        continue;
                    }
                    if (bA == null) {
                        this.deleteAttribute(dA, attr, -1);
                        continue;
                    }
                    if (aA.equals(bA)) continue;
                    Element diffElement3 = this.createAttributeElement(++this.id, a.getXPath(), b.getXPath(), attr, aA, bA, -1);
                    this.update.addContent((Content)diffElement3);
                    change = this.diffAnnotator.annotateUpdateAttribute(a, b, attr, diffElement3, this.changeAnnotationFactory);
                }
            }
        }
        if (change != null) {
            for (Map.Entry<Property, RDFNode> annotation : c.getAnnotations()) {
                change.addAnnotation(annotation.getKey(), annotation.getValue());
            }
        }
    }

    private int getChildNo(TreeNode n) {
        return n.isRoot() ? -1 : n.getParent().getNoOfChild(n);
    }

    private String getParentXpath(TreeNode n) {
        return n.isRoot() ? "" : n.getParent().getXPath();
    }

    public void annotatePatch() {
        this.diffAnnotator.annotatePatch("bivesPatch", this.changeAnnotationFactory);
    }
}

