/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.ds.rn;

import de.unirostock.sems.bives.ds.ontology.SBOTerm;
import de.unirostock.sems.bives.ds.rn.ReactionNetwork;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkEntity;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstanceRef;
import de.unirostock.sems.bives.exception.BivesUnsupportedException;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class ReactionNetworkReaction
extends ReactionNetworkEntity {
    private boolean reversible;
    private ReactionNetworkCompartment compartmentA;
    private ReactionNetworkCompartment compartmentB;
    private HashMap<ReactionNetworkSubstance, ReactionNetworkSubstanceRef> in = new HashMap();
    private HashMap<ReactionNetworkSubstance, ReactionNetworkSubstanceRef> out = new HashMap();
    private Vector<ReactionNetworkSubstanceRef> mod = new Vector();

    public ReactionNetworkReaction(ReactionNetwork rn, String labelA, String labelB, DocumentNode docA, DocumentNode docB, ReactionNetworkCompartment compartmentA, ReactionNetworkCompartment compartmentB, boolean reversible) {
        super("r" + rn.getNextReactionID(), labelA, labelB, docA, docB);
        this.compartmentA = compartmentA;
        this.compartmentB = compartmentB;
        this.singleDoc = false;
        this.reversible = reversible;
    }

    public void setCompartmentA(ReactionNetworkCompartment compartment) {
        this.compartmentA = compartment;
    }

    public void setCompartmentB(ReactionNetworkCompartment compartment) {
        this.compartmentB = compartment;
    }

    public ReactionNetworkCompartment getCompartment() {
        if (this.compartmentA != null && this.compartmentA == this.compartmentB) {
            return this.compartmentA;
        }
        boolean sameCompartment = true;
        ReactionNetworkCompartment compartment = null;
        if (sameCompartment) {
            for (ReactionNetworkSubstance reactionNetworkSubstance : this.in.keySet()) {
                if (compartment == null) {
                    compartment = reactionNetworkSubstance.getCompartment();
                    continue;
                }
                if (compartment == reactionNetworkSubstance.getCompartment()) continue;
                sameCompartment = false;
            }
        }
        if (sameCompartment) {
            for (ReactionNetworkSubstance reactionNetworkSubstance : this.out.keySet()) {
                if (compartment == null) {
                    compartment = reactionNetworkSubstance.getCompartment();
                    continue;
                }
                if (compartment == reactionNetworkSubstance.getCompartment()) continue;
                sameCompartment = false;
            }
        }
        if (sameCompartment) {
            for (ReactionNetworkSubstanceRef reactionNetworkSubstanceRef : this.mod) {
                if (compartment == null) {
                    compartment = reactionNetworkSubstanceRef.subst.getCompartment();
                    continue;
                }
                if (compartment == reactionNetworkSubstanceRef.subst.getCompartment()) continue;
                sameCompartment = false;
            }
        }
        if (sameCompartment) {
            return compartment;
        }
        return null;
    }

    public void addInputA(ReactionNetworkSubstance subst, SBOTerm sbo) {
        ReactionNetworkSubstanceRef r = this.in.get(subst);
        if (r == null) {
            try {
                this.in.put(subst, new ReactionNetworkSubstanceRef(subst, true, false, sbo, null));
            }
            catch (BivesUnsupportedException bivesUnsupportedException) {}
        } else {
            r.setFlagA(true);
        }
    }

    public void addOutputA(ReactionNetworkSubstance subst, SBOTerm sbo) {
        ReactionNetworkSubstanceRef r = this.out.get(subst);
        if (r == null) {
            try {
                this.out.put(subst, new ReactionNetworkSubstanceRef(subst, true, false, sbo, null));
            }
            catch (BivesUnsupportedException bivesUnsupportedException) {}
        } else {
            r.setFlagA(true);
        }
    }

    public void addModA(ReactionNetworkSubstance subst, SBOTerm sbo) throws BivesUnsupportedException {
        for (ReactionNetworkSubstanceRef sub : this.mod) {
            if (sub.subst != subst || !SBOTerm.sameModifier(sub.modTermB, sbo)) continue;
            sub.setFlagA(true);
            sub.modTermA = sbo;
            return;
        }
        this.mod.add(new ReactionNetworkSubstanceRef(subst, true, false, sbo, null));
    }

    public void addInputB(ReactionNetworkSubstance subst, SBOTerm sbo) {
        ReactionNetworkSubstanceRef r = this.in.get(subst);
        if (r == null) {
            try {
                this.in.put(subst, new ReactionNetworkSubstanceRef(subst, false, true, null, sbo));
            }
            catch (BivesUnsupportedException bivesUnsupportedException) {}
        } else {
            r.setFlagB(true);
        }
    }

    public void addOutputB(ReactionNetworkSubstance subst, SBOTerm sbo) {
        ReactionNetworkSubstanceRef r = this.out.get(subst);
        if (r == null) {
            try {
                this.out.put(subst, new ReactionNetworkSubstanceRef(subst, false, true, null, sbo));
            }
            catch (BivesUnsupportedException bivesUnsupportedException) {}
        } else {
            r.setFlagB(true);
        }
    }

    public void addModB(ReactionNetworkSubstance subst, SBOTerm sbo) throws BivesUnsupportedException {
        for (ReactionNetworkSubstanceRef sub : this.mod) {
            if (sub.subst != subst || !SBOTerm.sameModifier(sub.modTermA, sbo)) continue;
            sub.setFlagB(true);
            sub.modTermB = sbo;
            return;
        }
        this.mod.add(new ReactionNetworkSubstanceRef(subst, false, true, null, sbo));
    }

    public Collection<ReactionNetworkSubstanceRef> getInputs() {
        return this.in.values();
    }

    public Collection<ReactionNetworkSubstanceRef> getOutputs() {
        return this.out.values();
    }

    public Collection<ReactionNetworkSubstanceRef> getModifiers() {
        return this.mod;
    }

    public String getSBO() {
        if (this.docA == null && this.docB == null) {
            return "";
        }
        String a = null;
        String b = null;
        if (this.docA != null) {
            a = this.docA.getAttributeValue("sboTerm");
        }
        if (this.docB != null) {
            b = this.docB.getAttributeValue("sboTerm");
        }
        if (a == null || b == null || !a.equals(b)) {
            return "";
        }
        return a;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    @Override
    public void setSingleDocument() {
        this.singleDoc = true;
        for (ReactionNetworkSubstanceRef subst : this.in.values()) {
            subst.setSingleDocument();
        }
        for (ReactionNetworkSubstanceRef subst : this.out.values()) {
            subst.setSingleDocument();
        }
        for (ReactionNetworkSubstanceRef subst : this.mod) {
            subst.setSingleDocument();
        }
    }

    @Override
    public int getModification() {
        int i = super.getModification();
        if (i != 0) {
            return i;
        }
        if (this.changes(this.in.values()) || this.changes(this.out.values()) || this.changes(this.mod)) {
            return 2;
        }
        return 0;
    }

    private boolean changes(Collection<ReactionNetworkSubstanceRef> substances) {
        for (ReactionNetworkSubstanceRef substance : substances) {
            if (substance.getModification() == 0) continue;
            return true;
        }
        return false;
    }
}

