/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.markup;

import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.markup.MarkupSection;
import de.unirostock.sems.bives.markup.Typesetting;
import java.util.List;

public class TypesettingHTML
extends Typesetting {
    @Override
    public String typeset(MarkupDocument doc) {
        String s = "<h1>" + doc.getHeadline() + "</h1>";
        String sub = "";
        List<String> headers = doc.getHeader();
        for (String head : headers) {
            sub = sub + "<li>" + head + "</li>";
        }
        if (sub.length() > 0) {
            s = s + "<ul>" + sub + "</ul>";
        }
        List<MarkupSection> sections = doc.getSections();
        for (MarkupSection sec : sections) {
            s = s + this.typesetSection(sec);
        }
        s = MarkupDocument.replaceHighlights(s, "<strong>", "</strong>");
        s = MarkupDocument.replaceInserts(s, "<span class='bives-insert'>", "</span>");
        s = MarkupDocument.replaceDeletes(s, "<span class='bives-delete'>", "</span>");
        s = MarkupDocument.replaceSupplementals(s, "<span class='bives-suppl'>", "</span>");
        s = MarkupDocument.replaceAttributes(s, "<span class='bives-attr'>", "</span>");
        s = MarkupDocument.replaceOriginalMaths(s, "<div class='bives-math bives-math-original'>", "</div>");
        s = MarkupDocument.replaceModifiedMaths(s, "<div class='bives-math bives-math-modified'>", "</div>");
        s = MarkupDocument.replaceUnchangedMaths(s, "<div class='bives-math'>", "</div>");
        s = MarkupDocument.replaceRightArrow(s, "&rarr;");
        s = MarkupDocument.replaceMultiplication(s, "&middot;");
        return s;
    }

    private String typesetSection(MarkupSection section) {
        String s = "<h2>" + section.getHeader() + "</h2>";
        String sub = "";
        List<MarkupElement> elements = section.getValues();
        for (MarkupElement e : elements) {
            sub = sub + this.typesetElement(e);
        }
        if (sub.length() > 0) {
            return s + "<table class='bives-table-" + section.getHeader().replaceAll("[^a-zA-Z0-9]", "_") + "'>" + sub + "</table>";
        }
        return "";
    }

    private String typesetElement(MarkupElement element) {
        String s = "<tr><td class='bives-table-left'>" + element.getHeader() + "</td><td class='" + "bives-table-right" + "'>";
        String sub = "";
        List<String> values = element.getValues();
        for (String v : values) {
            sub = sub + "<li>" + v + "</li>";
        }
        List<MarkupElement> subElements = element.getSubElements();
        for (MarkupElement e : subElements) {
            sub = sub + "<li>" + this.typesetSubElement(e) + "</li>";
        }
        if (sub.length() > 0) {
            s = s + "<ul>" + sub + "</ul>";
        }
        if (element.hasInvisibleModifications()) {
            s = s + "<small>There are modifications (annotations/notes/..), which are not displayed in this report</small>";
        }
        return s + "</td></tr>";
    }

    private String typesetSubElement(MarkupElement element) {
        String s = "<strong>" + element.getHeader() + "</strong>";
        String sub = "";
        List<String> values = element.getValues();
        for (String v : values) {
            sub = sub + "<li>" + v + "</li>";
        }
        if (sub.length() > 0) {
            s = s + "<ul>" + sub + "</ul>";
        }
        if (element.hasInvisibleModifications()) {
            s = s + "<small>There are modifications (annotations/notes/..), which are not displayed in this report</small>";
        }
        return s;
    }
}

