/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.merge.algorithm;

import de.unirostock.sems.bives.api.Diff;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class ModelMerger {
    protected Diff diff;
    protected Document xmlDocA;
    protected Document xmlDocB;
    protected File fileA;
    protected File fileB;
    protected Map<String, String> moveMap;

    public ModelMerger(Document docA, Document docB, Diff diffed, boolean masterRight) throws IOException, JDOMException {
        if (masterRight) {
            this.xmlDocB = docA;
            this.xmlDocA = docB;
        } else {
            this.xmlDocA = docA;
            this.xmlDocB = docB;
        }
        this.diff = diffed;
    }

    public ModelMerger(Document docA, Document docB, Diff diffed) throws IOException, JDOMException {
        this.xmlDocA = docA;
        this.xmlDocB = docB;
        this.diff = diffed;
    }

    public void mapMoves() throws IOException {
        this.moveMap = new HashMap<String, String>();
        List moves = this.diff.getPatch().getMoves().getChildren();
        for (Element move : moves) {
            String oldPath = move.getAttributeValue("oldPath");
            String newPath = move.getAttributeValue("newPath");
            this.moveMap.put(oldPath, newPath);
        }
    }

    public String getMerge() throws BivesConnectionException, JDOMException, IOException {
        String mergedDoc = null;
        try {
            this.mapMoves();
            Document doc = this.xmlDocA;
            Document newDoc = this.xmlDocB;
            XPathFactory xpathFactory = XPathFactory.instance();
            List deletes = this.diff.getPatch().getDeletes().getChildren();
            if (deletes == null) {
                System.out.println("no nodes that exist only in the first model");
                return null;
            }
            for (Element del : deletes) {
                Text element;
                XPathExpression expr;
                if (del.getAttribute("triggeredBy") != null) continue;
                String oldPath = del.getAttributeValue("oldPath");
                String localPath = this.getLocalPath(oldPath);
                String localParent = this.getLocalPath(this.parentFrom(this.movedAncestor(oldPath)));
                XPathExpression exprAddTo = xpathFactory.compile(localParent, Filters.element());
                Element addTo = (Element)exprAddTo.evaluateFirst((Object)newDoc);
                if (oldPath.contains("text()")) {
                    expr = xpathFactory.compile(localPath, Filters.text());
                    element = (Text)expr.evaluateFirst((Object)doc);
                    addTo.addContent(element.getText());
                    continue;
                }
                expr = xpathFactory.compile(localPath, Filters.element());
                element = (Element)expr.evaluateFirst((Object)doc);
                addTo.addContent((Content)element.clone());
            }
            XMLOutputter xout = new XMLOutputter();
            Format f = Format.getPrettyFormat();
            xout.setFormat(f);
            mergedDoc = xout.outputString(newDoc);
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return mergedDoc;
    }

    public String getLocalPath(String path) {
        String locPath = "";
        path = path.substring(1);
        for (String s : path.split("/")) {
            String[] k = s.split("\\[");
            locPath = !k[0].contains("text()") ? locPath + "/*[local-name() = '" + k[0] + "'][" + k[1] : locPath + "/text()";
        }
        return locPath;
    }

    public String parentFrom(String path) {
        int lastOcc = path.lastIndexOf(47);
        String parentPath = path.substring(0, lastOcc);
        return parentPath;
    }

    public String movedAncestor(String path) {
        String end = path;
        while (path.contains("/")) {
            int cutoff = path.lastIndexOf(47);
            if (!this.moveMap.containsKey(path = path.substring(0, cutoff))) continue;
            end = end.substring(cutoff);
            String movedOldPath = this.moveMap.get(path) + end;
            System.out.println("Moved Ancestor");
            return movedOldPath;
        }
        return end;
    }
}

